# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import DocumentElementLength

class DocumentBodyVideoProperties(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        DocumentBodyVideoProperties - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'background_color': 'str',
            'align': 'str',
            'indentation': 'float',
            'width': 'DocumentElementLength',
            'height': 'DocumentElementLength'
        }

        self.attribute_map = {
            'background_color': 'backgroundColor',
            'align': 'align',
            'indentation': 'indentation',
            'width': 'width',
            'height': 'height'
        }

        self._background_color = None
        self._align = None
        self._indentation = None
        self._width = None
        self._height = None

    @property
    def background_color(self) -> str:
        """
        Gets the background_color of this DocumentBodyVideoProperties.
        The background color for the video. The valid values in hex color code representation. For example black color - #000000

        :return: The background_color of this DocumentBodyVideoProperties.
        :rtype: str
        """
        return self._background_color

    @background_color.setter
    def background_color(self, background_color: str) -> None:
        """
        Sets the background_color of this DocumentBodyVideoProperties.
        The background color for the video. The valid values in hex color code representation. For example black color - #000000

        :param background_color: The background_color of this DocumentBodyVideoProperties.
        :type: str
        """
        

        self._background_color = background_color

    @property
    def align(self) -> str:
        """
        Gets the align of this DocumentBodyVideoProperties.
        The align type for the video.

        :return: The align of this DocumentBodyVideoProperties.
        :rtype: str
        """
        return self._align

    @align.setter
    def align(self, align: str) -> None:
        """
        Sets the align of this DocumentBodyVideoProperties.
        The align type for the video.

        :param align: The align of this DocumentBodyVideoProperties.
        :type: str
        """
        if isinstance(align, int):
            align = str(align)
        allowed_values = ["Center", "Left", "Right", "Justify"]
        if align.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for align -> " + align)
            self._align = "outdated_sdk_version"
        else:
            self._align = align

    @property
    def indentation(self) -> float:
        """
        Gets the indentation of this DocumentBodyVideoProperties.
        The indentation for the video. The valid values in 'em'.

        :return: The indentation of this DocumentBodyVideoProperties.
        :rtype: float
        """
        return self._indentation

    @indentation.setter
    def indentation(self, indentation: float) -> None:
        """
        Sets the indentation of this DocumentBodyVideoProperties.
        The indentation for the video. The valid values in 'em'.

        :param indentation: The indentation of this DocumentBodyVideoProperties.
        :type: float
        """
        

        self._indentation = indentation

    @property
    def width(self) -> 'DocumentElementLength':
        """
        Gets the width of this DocumentBodyVideoProperties.
        The width of the video in the specified unit.

        :return: The width of this DocumentBodyVideoProperties.
        :rtype: DocumentElementLength
        """
        return self._width

    @width.setter
    def width(self, width: 'DocumentElementLength') -> None:
        """
        Sets the width of this DocumentBodyVideoProperties.
        The width of the video in the specified unit.

        :param width: The width of this DocumentBodyVideoProperties.
        :type: DocumentElementLength
        """
        

        self._width = width

    @property
    def height(self) -> 'DocumentElementLength':
        """
        Gets the height of this DocumentBodyVideoProperties.
        The height of the video in the specified unit.

        :return: The height of this DocumentBodyVideoProperties.
        :rtype: DocumentElementLength
        """
        return self._height

    @height.setter
    def height(self, height: 'DocumentElementLength') -> None:
        """
        Sets the height of this DocumentBodyVideoProperties.
        The height of the video in the specified unit.

        :param height: The height of this DocumentBodyVideoProperties.
        :type: DocumentElementLength
        """
        

        self._height = height

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

