# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class DocumentBodyTableRowBlockProperties(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        DocumentBodyTableRowBlockProperties - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'row_type': 'str',
            'alignment': 'str',
            'height': 'float',
            'border_style': 'str',
            'border_color': 'str',
            'background_color': 'str'
        }

        self.attribute_map = {
            'row_type': 'rowType',
            'alignment': 'alignment',
            'height': 'height',
            'border_style': 'borderStyle',
            'border_color': 'borderColor',
            'background_color': 'backgroundColor'
        }

        self._row_type = None
        self._alignment = None
        self._height = None
        self._border_style = None
        self._border_color = None
        self._background_color = None

    @property
    def row_type(self) -> str:
        """
        Gets the row_type of this DocumentBodyTableRowBlockProperties.
        The type of the table row.

        :return: The row_type of this DocumentBodyTableRowBlockProperties.
        :rtype: str
        """
        return self._row_type

    @row_type.setter
    def row_type(self, row_type: str) -> None:
        """
        Sets the row_type of this DocumentBodyTableRowBlockProperties.
        The type of the table row.

        :param row_type: The row_type of this DocumentBodyTableRowBlockProperties.
        :type: str
        """
        if isinstance(row_type, int):
            row_type = str(row_type)
        allowed_values = ["Header", "Footer", "Body"]
        if row_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for row_type -> " + row_type)
            self._row_type = "outdated_sdk_version"
        else:
            self._row_type = row_type

    @property
    def alignment(self) -> str:
        """
        Gets the alignment of this DocumentBodyTableRowBlockProperties.
        The alignment for the table row.

        :return: The alignment of this DocumentBodyTableRowBlockProperties.
        :rtype: str
        """
        return self._alignment

    @alignment.setter
    def alignment(self, alignment: str) -> None:
        """
        Sets the alignment of this DocumentBodyTableRowBlockProperties.
        The alignment for the table row.

        :param alignment: The alignment of this DocumentBodyTableRowBlockProperties.
        :type: str
        """
        if isinstance(alignment, int):
            alignment = str(alignment)
        allowed_values = ["Center", "Left", "Right"]
        if alignment.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for alignment -> " + alignment)
            self._alignment = "outdated_sdk_version"
        else:
            self._alignment = alignment

    @property
    def height(self) -> float:
        """
        Gets the height of this DocumentBodyTableRowBlockProperties.
        The height for the table row.

        :return: The height of this DocumentBodyTableRowBlockProperties.
        :rtype: float
        """
        return self._height

    @height.setter
    def height(self, height: float) -> None:
        """
        Sets the height of this DocumentBodyTableRowBlockProperties.
        The height for the table row.

        :param height: The height of this DocumentBodyTableRowBlockProperties.
        :type: float
        """
        

        self._height = height

    @property
    def border_style(self) -> str:
        """
        Gets the border_style of this DocumentBodyTableRowBlockProperties.
        The border style for the table row.

        :return: The border_style of this DocumentBodyTableRowBlockProperties.
        :rtype: str
        """
        return self._border_style

    @border_style.setter
    def border_style(self, border_style: str) -> None:
        """
        Sets the border_style of this DocumentBodyTableRowBlockProperties.
        The border style for the table row.

        :param border_style: The border_style of this DocumentBodyTableRowBlockProperties.
        :type: str
        """
        if isinstance(border_style, int):
            border_style = str(border_style)
        allowed_values = ["Solid", "Dotted", "Dashed", "Double", "Groove", "Ridge", "Inset", "Outset", "Hidden", "None"]
        if border_style.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for border_style -> " + border_style)
            self._border_style = "outdated_sdk_version"
        else:
            self._border_style = border_style

    @property
    def border_color(self) -> str:
        """
        Gets the border_color of this DocumentBodyTableRowBlockProperties.
        The border color for the table row. For example black color - #000000

        :return: The border_color of this DocumentBodyTableRowBlockProperties.
        :rtype: str
        """
        return self._border_color

    @border_color.setter
    def border_color(self, border_color: str) -> None:
        """
        Sets the border_color of this DocumentBodyTableRowBlockProperties.
        The border color for the table row. For example black color - #000000

        :param border_color: The border_color of this DocumentBodyTableRowBlockProperties.
        :type: str
        """
        

        self._border_color = border_color

    @property
    def background_color(self) -> str:
        """
        Gets the background_color of this DocumentBodyTableRowBlockProperties.
        The background color for the table row. For example black color - #000000

        :return: The background_color of this DocumentBodyTableRowBlockProperties.
        :rtype: str
        """
        return self._background_color

    @background_color.setter
    def background_color(self, background_color: str) -> None:
        """
        Sets the background_color of this DocumentBodyTableRowBlockProperties.
        The background color for the table row. For example black color - #000000

        :param background_color: The background_color of this DocumentBodyTableRowBlockProperties.
        :type: str
        """
        

        self._background_color = background_color

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

