# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class DnsRecordEntry(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        DnsRecordEntry - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'host': 'str',
            'record_contents': 'str',
            'verification_status': 'str'
        }

        self.attribute_map = {
            'host': 'host',
            'record_contents': 'recordContents',
            'verification_status': 'verificationStatus'
        }

        self._host = None
        self._record_contents = None
        self._verification_status = None

    @property
    def host(self) -> str:
        """
        Gets the host of this DnsRecordEntry.
        the hostname of the DNS entry

        :return: The host of this DnsRecordEntry.
        :rtype: str
        """
        return self._host

    @host.setter
    def host(self, host: str) -> None:
        """
        Sets the host of this DnsRecordEntry.
        the hostname of the DNS entry

        :param host: The host of this DnsRecordEntry.
        :type: str
        """
        

        self._host = host

    @property
    def record_contents(self) -> str:
        """
        Gets the record_contents of this DnsRecordEntry.
        the payload of the DNS entry

        :return: The record_contents of this DnsRecordEntry.
        :rtype: str
        """
        return self._record_contents

    @record_contents.setter
    def record_contents(self, record_contents: str) -> None:
        """
        Sets the record_contents of this DnsRecordEntry.
        the payload of the DNS entry

        :param record_contents: The record_contents of this DnsRecordEntry.
        :type: str
        """
        

        self._record_contents = record_contents

    @property
    def verification_status(self) -> str:
        """
        Gets the verification_status of this DnsRecordEntry.
        the current status of the related verification process

        :return: The verification_status of this DnsRecordEntry.
        :rtype: str
        """
        return self._verification_status

    @verification_status.setter
    def verification_status(self, verification_status: str) -> None:
        """
        Sets the verification_status of this DnsRecordEntry.
        the current status of the related verification process

        :param verification_status: The verification_status of this DnsRecordEntry.
        :type: str
        """
        if isinstance(verification_status, int):
            verification_status = str(verification_status)
        allowed_values = ["Pending", "Verified", "Failed", "Unknown"]
        if verification_status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for verification_status -> " + verification_status)
            self._verification_status = "outdated_sdk_version"
        else:
            self._verification_status = verification_status

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

