# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import DialerCampaignScheduleConfigChangeAlteration
    from . import DialerCampaignScheduleConfigChangeRecurrencePattern
    from . import DialerCampaignScheduleConfigChangeRecurrenceRange

class DialerCampaignScheduleConfigChangeScheduleRecurrence(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        DialerCampaignScheduleConfigChangeScheduleRecurrence - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'start': 'str',
            'end': 'str',
            'time_zone': 'str',
            'range': 'DialerCampaignScheduleConfigChangeRecurrenceRange',
            'pattern': 'DialerCampaignScheduleConfigChangeRecurrencePattern',
            'alterations': 'list[DialerCampaignScheduleConfigChangeAlteration]',
            'additional_properties': 'dict(str, object)'
        }

        self.attribute_map = {
            'id': 'id',
            'start': 'start',
            'end': 'end',
            'time_zone': 'timeZone',
            'range': 'range',
            'pattern': 'pattern',
            'alterations': 'alterations',
            'additional_properties': 'additionalProperties'
        }

        self._id = None
        self._start = None
        self._end = None
        self._time_zone = None
        self._range = None
        self._pattern = None
        self._alterations = None
        self._additional_properties = None

    @property
    def id(self) -> str:
        """
        Gets the id of this DialerCampaignScheduleConfigChangeScheduleRecurrence.
        the recurrence id

        :return: The id of this DialerCampaignScheduleConfigChangeScheduleRecurrence.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this DialerCampaignScheduleConfigChangeScheduleRecurrence.
        the recurrence id

        :param id: The id of this DialerCampaignScheduleConfigChangeScheduleRecurrence.
        :type: str
        """
        

        self._id = id

    @property
    def start(self) -> str:
        """
        Gets the start of this DialerCampaignScheduleConfigChangeScheduleRecurrence.
        scheduled start time represented as an ISO-8601 string; for example, yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The start of this DialerCampaignScheduleConfigChangeScheduleRecurrence.
        :rtype: str
        """
        return self._start

    @start.setter
    def start(self, start: str) -> None:
        """
        Sets the start of this DialerCampaignScheduleConfigChangeScheduleRecurrence.
        scheduled start time represented as an ISO-8601 string; for example, yyyy-MM-ddTHH:mm:ss.SSSZ

        :param start: The start of this DialerCampaignScheduleConfigChangeScheduleRecurrence.
        :type: str
        """
        

        self._start = start

    @property
    def end(self) -> str:
        """
        Gets the end of this DialerCampaignScheduleConfigChangeScheduleRecurrence.
        scheduled end time represented as an ISO-8601 string; for example, yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The end of this DialerCampaignScheduleConfigChangeScheduleRecurrence.
        :rtype: str
        """
        return self._end

    @end.setter
    def end(self, end: str) -> None:
        """
        Sets the end of this DialerCampaignScheduleConfigChangeScheduleRecurrence.
        scheduled end time represented as an ISO-8601 string; for example, yyyy-MM-ddTHH:mm:ss.SSSZ

        :param end: The end of this DialerCampaignScheduleConfigChangeScheduleRecurrence.
        :type: str
        """
        

        self._end = end

    @property
    def time_zone(self) -> str:
        """
        Gets the time_zone of this DialerCampaignScheduleConfigChangeScheduleRecurrence.
        the timezone the recurrence will use

        :return: The time_zone of this DialerCampaignScheduleConfigChangeScheduleRecurrence.
        :rtype: str
        """
        return self._time_zone

    @time_zone.setter
    def time_zone(self, time_zone: str) -> None:
        """
        Sets the time_zone of this DialerCampaignScheduleConfigChangeScheduleRecurrence.
        the timezone the recurrence will use

        :param time_zone: The time_zone of this DialerCampaignScheduleConfigChangeScheduleRecurrence.
        :type: str
        """
        

        self._time_zone = time_zone

    @property
    def range(self) -> 'DialerCampaignScheduleConfigChangeRecurrenceRange':
        """
        Gets the range of this DialerCampaignScheduleConfigChangeScheduleRecurrence.


        :return: The range of this DialerCampaignScheduleConfigChangeScheduleRecurrence.
        :rtype: DialerCampaignScheduleConfigChangeRecurrenceRange
        """
        return self._range

    @range.setter
    def range(self, range: 'DialerCampaignScheduleConfigChangeRecurrenceRange') -> None:
        """
        Sets the range of this DialerCampaignScheduleConfigChangeScheduleRecurrence.


        :param range: The range of this DialerCampaignScheduleConfigChangeScheduleRecurrence.
        :type: DialerCampaignScheduleConfigChangeRecurrenceRange
        """
        

        self._range = range

    @property
    def pattern(self) -> 'DialerCampaignScheduleConfigChangeRecurrencePattern':
        """
        Gets the pattern of this DialerCampaignScheduleConfigChangeScheduleRecurrence.


        :return: The pattern of this DialerCampaignScheduleConfigChangeScheduleRecurrence.
        :rtype: DialerCampaignScheduleConfigChangeRecurrencePattern
        """
        return self._pattern

    @pattern.setter
    def pattern(self, pattern: 'DialerCampaignScheduleConfigChangeRecurrencePattern') -> None:
        """
        Sets the pattern of this DialerCampaignScheduleConfigChangeScheduleRecurrence.


        :param pattern: The pattern of this DialerCampaignScheduleConfigChangeScheduleRecurrence.
        :type: DialerCampaignScheduleConfigChangeRecurrencePattern
        """
        

        self._pattern = pattern

    @property
    def alterations(self) -> List['DialerCampaignScheduleConfigChangeAlteration']:
        """
        Gets the alterations of this DialerCampaignScheduleConfigChangeScheduleRecurrence.
        modifications to the original recurrence schedule

        :return: The alterations of this DialerCampaignScheduleConfigChangeScheduleRecurrence.
        :rtype: list[DialerCampaignScheduleConfigChangeAlteration]
        """
        return self._alterations

    @alterations.setter
    def alterations(self, alterations: List['DialerCampaignScheduleConfigChangeAlteration']) -> None:
        """
        Sets the alterations of this DialerCampaignScheduleConfigChangeScheduleRecurrence.
        modifications to the original recurrence schedule

        :param alterations: The alterations of this DialerCampaignScheduleConfigChangeScheduleRecurrence.
        :type: list[DialerCampaignScheduleConfigChangeAlteration]
        """
        

        self._alterations = alterations

    @property
    def additional_properties(self) -> Dict[str, object]:
        """
        Gets the additional_properties of this DialerCampaignScheduleConfigChangeScheduleRecurrence.


        :return: The additional_properties of this DialerCampaignScheduleConfigChangeScheduleRecurrence.
        :rtype: dict(str, object)
        """
        return self._additional_properties

    @additional_properties.setter
    def additional_properties(self, additional_properties: Dict[str, object]) -> None:
        """
        Sets the additional_properties of this DialerCampaignScheduleConfigChangeScheduleRecurrence.


        :param additional_properties: The additional_properties of this DialerCampaignScheduleConfigChangeScheduleRecurrence.
        :type: dict(str, object)
        """
        

        self._additional_properties = additional_properties

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

