# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ContentOffer
    from . import OpenActionProperties
    from . import WebMessagingOfferProperties

class DeploymentWebAction(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        DeploymentWebAction - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'media_type': 'str',
            'customer_id': 'str',
            'customer_id_type': 'str',
            'action_map_id': 'str',
            'action_map_version': 'int',
            'session_id': 'str',
            'web_messaging_offer_properties': 'WebMessagingOfferProperties',
            'content_offer_properties': 'ContentOffer',
            'open_action_properties': 'OpenActionProperties'
        }

        self.attribute_map = {
            'id': 'id',
            'media_type': 'mediaType',
            'customer_id': 'customerId',
            'customer_id_type': 'customerIdType',
            'action_map_id': 'actionMapId',
            'action_map_version': 'actionMapVersion',
            'session_id': 'sessionId',
            'web_messaging_offer_properties': 'webMessagingOfferProperties',
            'content_offer_properties': 'contentOfferProperties',
            'open_action_properties': 'openActionProperties'
        }

        self._id = None
        self._media_type = None
        self._customer_id = None
        self._customer_id_type = None
        self._action_map_id = None
        self._action_map_version = None
        self._session_id = None
        self._web_messaging_offer_properties = None
        self._content_offer_properties = None
        self._open_action_properties = None

    @property
    def id(self) -> str:
        """
        Gets the id of this DeploymentWebAction.
        System-generated UUID for the action.

        :return: The id of this DeploymentWebAction.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this DeploymentWebAction.
        System-generated UUID for the action.

        :param id: The id of this DeploymentWebAction.
        :type: str
        """
        

        self._id = id

    @property
    def media_type(self) -> str:
        """
        Gets the media_type of this DeploymentWebAction.
        Action media type used to deliver the action.

        :return: The media_type of this DeploymentWebAction.
        :rtype: str
        """
        return self._media_type

    @media_type.setter
    def media_type(self, media_type: str) -> None:
        """
        Sets the media_type of this DeploymentWebAction.
        Action media type used to deliver the action.

        :param media_type: The media_type of this DeploymentWebAction.
        :type: str
        """
        if isinstance(media_type, int):
            media_type = str(media_type)
        allowed_values = ["webchat", "webMessagingOffer", "contentOffer", "integrationAction", "architectFlow", "openAction"]
        if media_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for media_type -> " + media_type)
            self._media_type = "outdated_sdk_version"
        else:
            self._media_type = media_type

    @property
    def customer_id(self) -> str:
        """
        Gets the customer_id of this DeploymentWebAction.
        ID string of the customer that the action was triggered for.

        :return: The customer_id of this DeploymentWebAction.
        :rtype: str
        """
        return self._customer_id

    @customer_id.setter
    def customer_id(self, customer_id: str) -> None:
        """
        Sets the customer_id of this DeploymentWebAction.
        ID string of the customer that the action was triggered for.

        :param customer_id: The customer_id of this DeploymentWebAction.
        :type: str
        """
        

        self._customer_id = customer_id

    @property
    def customer_id_type(self) -> str:
        """
        Gets the customer_id_type of this DeploymentWebAction.
        Type of the customer ID that the action was triggered for.

        :return: The customer_id_type of this DeploymentWebAction.
        :rtype: str
        """
        return self._customer_id_type

    @customer_id_type.setter
    def customer_id_type(self, customer_id_type: str) -> None:
        """
        Sets the customer_id_type of this DeploymentWebAction.
        Type of the customer ID that the action was triggered for.

        :param customer_id_type: The customer_id_type of this DeploymentWebAction.
        :type: str
        """
        

        self._customer_id_type = customer_id_type

    @property
    def action_map_id(self) -> str:
        """
        Gets the action_map_id of this DeploymentWebAction.
        ID of the action map that triggered the action.

        :return: The action_map_id of this DeploymentWebAction.
        :rtype: str
        """
        return self._action_map_id

    @action_map_id.setter
    def action_map_id(self, action_map_id: str) -> None:
        """
        Sets the action_map_id of this DeploymentWebAction.
        ID of the action map that triggered the action.

        :param action_map_id: The action_map_id of this DeploymentWebAction.
        :type: str
        """
        

        self._action_map_id = action_map_id

    @property
    def action_map_version(self) -> int:
        """
        Gets the action_map_version of this DeploymentWebAction.
        Version of the action map that triggered the action.

        :return: The action_map_version of this DeploymentWebAction.
        :rtype: int
        """
        return self._action_map_version

    @action_map_version.setter
    def action_map_version(self, action_map_version: int) -> None:
        """
        Sets the action_map_version of this DeploymentWebAction.
        Version of the action map that triggered the action.

        :param action_map_version: The action_map_version of this DeploymentWebAction.
        :type: int
        """
        

        self._action_map_version = action_map_version

    @property
    def session_id(self) -> str:
        """
        Gets the session_id of this DeploymentWebAction.
        ID of the session that the action was triggered for.

        :return: The session_id of this DeploymentWebAction.
        :rtype: str
        """
        return self._session_id

    @session_id.setter
    def session_id(self, session_id: str) -> None:
        """
        Sets the session_id of this DeploymentWebAction.
        ID of the session that the action was triggered for.

        :param session_id: The session_id of this DeploymentWebAction.
        :type: str
        """
        

        self._session_id = session_id

    @property
    def web_messaging_offer_properties(self) -> 'WebMessagingOfferProperties':
        """
        Gets the web_messaging_offer_properties of this DeploymentWebAction.
        Web messaging offer specific properties.

        :return: The web_messaging_offer_properties of this DeploymentWebAction.
        :rtype: WebMessagingOfferProperties
        """
        return self._web_messaging_offer_properties

    @web_messaging_offer_properties.setter
    def web_messaging_offer_properties(self, web_messaging_offer_properties: 'WebMessagingOfferProperties') -> None:
        """
        Sets the web_messaging_offer_properties of this DeploymentWebAction.
        Web messaging offer specific properties.

        :param web_messaging_offer_properties: The web_messaging_offer_properties of this DeploymentWebAction.
        :type: WebMessagingOfferProperties
        """
        

        self._web_messaging_offer_properties = web_messaging_offer_properties

    @property
    def content_offer_properties(self) -> 'ContentOffer':
        """
        Gets the content_offer_properties of this DeploymentWebAction.
        Content offer specific properties.

        :return: The content_offer_properties of this DeploymentWebAction.
        :rtype: ContentOffer
        """
        return self._content_offer_properties

    @content_offer_properties.setter
    def content_offer_properties(self, content_offer_properties: 'ContentOffer') -> None:
        """
        Sets the content_offer_properties of this DeploymentWebAction.
        Content offer specific properties.

        :param content_offer_properties: The content_offer_properties of this DeploymentWebAction.
        :type: ContentOffer
        """
        

        self._content_offer_properties = content_offer_properties

    @property
    def open_action_properties(self) -> 'OpenActionProperties':
        """
        Gets the open_action_properties of this DeploymentWebAction.
        Open action specific properties.

        :return: The open_action_properties of this DeploymentWebAction.
        :rtype: OpenActionProperties
        """
        return self._open_action_properties

    @open_action_properties.setter
    def open_action_properties(self, open_action_properties: 'OpenActionProperties') -> None:
        """
        Sets the open_action_properties of this DeploymentWebAction.
        Open action specific properties.

        :param open_action_properties: The open_action_properties of this DeploymentWebAction.
        :type: OpenActionProperties
        """
        

        self._open_action_properties = open_action_properties

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

