# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class DataIngestionRulesMetadata(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        DataIngestionRulesMetadata - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'count_by_status': 'dict(str, int)',
            'platform': 'str',
            'total_count': 'int'
        }

        self.attribute_map = {
            'count_by_status': 'countByStatus',
            'platform': 'platform',
            'total_count': 'totalCount'
        }

        self._count_by_status = None
        self._platform = None
        self._total_count = None

    @property
    def count_by_status(self) -> Dict[str, int]:
        """
        Gets the count_by_status of this DataIngestionRulesMetadata.
        Count of data ingestion rules by status

        :return: The count_by_status of this DataIngestionRulesMetadata.
        :rtype: dict(str, int)
        """
        return self._count_by_status

    @count_by_status.setter
    def count_by_status(self, count_by_status: Dict[str, int]) -> None:
        """
        Sets the count_by_status of this DataIngestionRulesMetadata.
        Count of data ingestion rules by status

        :param count_by_status: The count_by_status of this DataIngestionRulesMetadata.
        :type: dict(str, int)
        """
        

        self._count_by_status = count_by_status

    @property
    def platform(self) -> str:
        """
        Gets the platform of this DataIngestionRulesMetadata.
        The platform for which the data ingestion rules are available

        :return: The platform of this DataIngestionRulesMetadata.
        :rtype: str
        """
        return self._platform

    @platform.setter
    def platform(self, platform: str) -> None:
        """
        Sets the platform of this DataIngestionRulesMetadata.
        The platform for which the data ingestion rules are available

        :param platform: The platform of this DataIngestionRulesMetadata.
        :type: str
        """
        

        self._platform = platform

    @property
    def total_count(self) -> int:
        """
        Gets the total_count of this DataIngestionRulesMetadata.
        The total count of data ingestion rule

        :return: The total_count of this DataIngestionRulesMetadata.
        :rtype: int
        """
        return self._total_count

    @total_count.setter
    def total_count(self, total_count: int) -> None:
        """
        Sets the total_count of this DataIngestionRulesMetadata.
        The total count of data ingestion rule

        :param total_count: The total_count of this DataIngestionRulesMetadata.
        :type: int
        """
        

        self._total_count = total_count

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

