# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import CreateObjective

class CreateMetric(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CreateMetric - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'metric_definition_id': 'str',
            'external_metric_definition_id': 'str',
            'objective': 'CreateObjective',
            'performance_profile_id': 'str',
            'name': 'str',
            'precision': 'int',
            'time_display_unit': 'str'
        }

        self.attribute_map = {
            'metric_definition_id': 'metricDefinitionId',
            'external_metric_definition_id': 'externalMetricDefinitionId',
            'objective': 'objective',
            'performance_profile_id': 'performanceProfileId',
            'name': 'name',
            'precision': 'precision',
            'time_display_unit': 'timeDisplayUnit'
        }

        self._metric_definition_id = None
        self._external_metric_definition_id = None
        self._objective = None
        self._performance_profile_id = None
        self._name = None
        self._precision = None
        self._time_display_unit = None

    @property
    def metric_definition_id(self) -> str:
        """
        Gets the metric_definition_id of this CreateMetric.
        The id of associated metric definition

        :return: The metric_definition_id of this CreateMetric.
        :rtype: str
        """
        return self._metric_definition_id

    @metric_definition_id.setter
    def metric_definition_id(self, metric_definition_id: str) -> None:
        """
        Sets the metric_definition_id of this CreateMetric.
        The id of associated metric definition

        :param metric_definition_id: The metric_definition_id of this CreateMetric.
        :type: str
        """
        

        self._metric_definition_id = metric_definition_id

    @property
    def external_metric_definition_id(self) -> str:
        """
        Gets the external_metric_definition_id of this CreateMetric.
        The id of associated external metric definition

        :return: The external_metric_definition_id of this CreateMetric.
        :rtype: str
        """
        return self._external_metric_definition_id

    @external_metric_definition_id.setter
    def external_metric_definition_id(self, external_metric_definition_id: str) -> None:
        """
        Sets the external_metric_definition_id of this CreateMetric.
        The id of associated external metric definition

        :param external_metric_definition_id: The external_metric_definition_id of this CreateMetric.
        :type: str
        """
        

        self._external_metric_definition_id = external_metric_definition_id

    @property
    def objective(self) -> 'CreateObjective':
        """
        Gets the objective of this CreateMetric.
        Associated objective for this metric

        :return: The objective of this CreateMetric.
        :rtype: CreateObjective
        """
        return self._objective

    @objective.setter
    def objective(self, objective: 'CreateObjective') -> None:
        """
        Sets the objective of this CreateMetric.
        Associated objective for this metric

        :param objective: The objective of this CreateMetric.
        :type: CreateObjective
        """
        

        self._objective = objective

    @property
    def performance_profile_id(self) -> str:
        """
        Gets the performance_profile_id of this CreateMetric.
        Performance profile id of this metric

        :return: The performance_profile_id of this CreateMetric.
        :rtype: str
        """
        return self._performance_profile_id

    @performance_profile_id.setter
    def performance_profile_id(self, performance_profile_id: str) -> None:
        """
        Sets the performance_profile_id of this CreateMetric.
        Performance profile id of this metric

        :param performance_profile_id: The performance_profile_id of this CreateMetric.
        :type: str
        """
        

        self._performance_profile_id = performance_profile_id

    @property
    def name(self) -> str:
        """
        Gets the name of this CreateMetric.
        The name of this metric

        :return: The name of this CreateMetric.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this CreateMetric.
        The name of this metric

        :param name: The name of this CreateMetric.
        :type: str
        """
        

        self._name = name

    @property
    def precision(self) -> int:
        """
        Gets the precision of this CreateMetric.
        The precision of the metric, must be between 0 and 5

        :return: The precision of this CreateMetric.
        :rtype: int
        """
        return self._precision

    @precision.setter
    def precision(self, precision: int) -> None:
        """
        Sets the precision of this CreateMetric.
        The precision of the metric, must be between 0 and 5

        :param precision: The precision of this CreateMetric.
        :type: int
        """
        

        self._precision = precision

    @property
    def time_display_unit(self) -> str:
        """
        Gets the time_display_unit of this CreateMetric.
        The time unit in which the metric should be displayed -- this parameter is ignored when displaying non-time values

        :return: The time_display_unit of this CreateMetric.
        :rtype: str
        """
        return self._time_display_unit

    @time_display_unit.setter
    def time_display_unit(self, time_display_unit: str) -> None:
        """
        Sets the time_display_unit of this CreateMetric.
        The time unit in which the metric should be displayed -- this parameter is ignored when displaying non-time values

        :param time_display_unit: The time_display_unit of this CreateMetric.
        :type: str
        """
        if isinstance(time_display_unit, int):
            time_display_unit = str(time_display_unit)
        allowed_values = ["None", "Seconds", "Minutes", "Hours"]
        if time_display_unit.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for time_display_unit -> " + time_display_unit)
            self._time_display_unit = "outdated_sdk_version"
        else:
            self._time_display_unit = time_display_unit

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

