# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ConversationVideoEventTopicConversationRoutingData
    from . import ConversationVideoEventTopicErrorBody
    from . import ConversationVideoEventTopicJourneyContext
    from . import ConversationVideoEventTopicQueueMediaSettings
    from . import ConversationVideoEventTopicUriReference
    from . import ConversationVideoEventTopicWrapup

class ConversationVideoEventTopicVideoMediaParticipant(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ConversationVideoEventTopicVideoMediaParticipant - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'address': 'str',
            'start_time': 'datetime',
            'connected_time': 'datetime',
            'end_time': 'datetime',
            'start_hold_time': 'datetime',
            'purpose': 'str',
            'state': 'str',
            'initial_state': 'str',
            'direction': 'str',
            'disconnect_type': 'str',
            'held': 'bool',
            'wrapup_required': 'bool',
            'wrapup_prompt': 'str',
            'user': 'ConversationVideoEventTopicUriReference',
            'queue': 'ConversationVideoEventTopicUriReference',
            'team': 'ConversationVideoEventTopicUriReference',
            'attributes': 'dict(str, str)',
            'error_info': 'ConversationVideoEventTopicErrorBody',
            'script': 'ConversationVideoEventTopicUriReference',
            'wrapup_timeout_ms': 'int',
            'wrapup_skipped': 'bool',
            'alerting_timeout_ms': 'int',
            'provider': 'str',
            'external_contact': 'ConversationVideoEventTopicUriReference',
            'external_contact_initial_division_id': 'str',
            'external_organization': 'ConversationVideoEventTopicUriReference',
            'wrapup': 'ConversationVideoEventTopicWrapup',
            'conversation_routing_data': 'ConversationVideoEventTopicConversationRoutingData',
            'peer': 'str',
            'screen_recording_state': 'str',
            'flagged_reason': 'str',
            'journey_context': 'ConversationVideoEventTopicJourneyContext',
            'start_acw_time': 'datetime',
            'end_acw_time': 'datetime',
            'resume_time': 'datetime',
            'park_time': 'datetime',
            'media_roles': 'list[str]',
            'queue_media_settings': 'ConversationVideoEventTopicQueueMediaSettings',
            'audio_muted': 'bool',
            'video_muted': 'bool',
            'sharing_screen': 'bool',
            'peer_count': 'int',
            'context': 'str',
            'msids': 'list[str]'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'address': 'address',
            'start_time': 'startTime',
            'connected_time': 'connectedTime',
            'end_time': 'endTime',
            'start_hold_time': 'startHoldTime',
            'purpose': 'purpose',
            'state': 'state',
            'initial_state': 'initialState',
            'direction': 'direction',
            'disconnect_type': 'disconnectType',
            'held': 'held',
            'wrapup_required': 'wrapupRequired',
            'wrapup_prompt': 'wrapupPrompt',
            'user': 'user',
            'queue': 'queue',
            'team': 'team',
            'attributes': 'attributes',
            'error_info': 'errorInfo',
            'script': 'script',
            'wrapup_timeout_ms': 'wrapupTimeoutMs',
            'wrapup_skipped': 'wrapupSkipped',
            'alerting_timeout_ms': 'alertingTimeoutMs',
            'provider': 'provider',
            'external_contact': 'externalContact',
            'external_contact_initial_division_id': 'externalContactInitialDivisionId',
            'external_organization': 'externalOrganization',
            'wrapup': 'wrapup',
            'conversation_routing_data': 'conversationRoutingData',
            'peer': 'peer',
            'screen_recording_state': 'screenRecordingState',
            'flagged_reason': 'flaggedReason',
            'journey_context': 'journeyContext',
            'start_acw_time': 'startAcwTime',
            'end_acw_time': 'endAcwTime',
            'resume_time': 'resumeTime',
            'park_time': 'parkTime',
            'media_roles': 'mediaRoles',
            'queue_media_settings': 'queueMediaSettings',
            'audio_muted': 'audioMuted',
            'video_muted': 'videoMuted',
            'sharing_screen': 'sharingScreen',
            'peer_count': 'peerCount',
            'context': 'context',
            'msids': 'msids'
        }

        self._id = None
        self._name = None
        self._address = None
        self._start_time = None
        self._connected_time = None
        self._end_time = None
        self._start_hold_time = None
        self._purpose = None
        self._state = None
        self._initial_state = None
        self._direction = None
        self._disconnect_type = None
        self._held = None
        self._wrapup_required = None
        self._wrapup_prompt = None
        self._user = None
        self._queue = None
        self._team = None
        self._attributes = None
        self._error_info = None
        self._script = None
        self._wrapup_timeout_ms = None
        self._wrapup_skipped = None
        self._alerting_timeout_ms = None
        self._provider = None
        self._external_contact = None
        self._external_contact_initial_division_id = None
        self._external_organization = None
        self._wrapup = None
        self._conversation_routing_data = None
        self._peer = None
        self._screen_recording_state = None
        self._flagged_reason = None
        self._journey_context = None
        self._start_acw_time = None
        self._end_acw_time = None
        self._resume_time = None
        self._park_time = None
        self._media_roles = None
        self._queue_media_settings = None
        self._audio_muted = None
        self._video_muted = None
        self._sharing_screen = None
        self._peer_count = None
        self._context = None
        self._msids = None

    @property
    def id(self) -> str:
        """
        Gets the id of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The id of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ConversationVideoEventTopicVideoMediaParticipant.


        :param id: The id of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The name of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this ConversationVideoEventTopicVideoMediaParticipant.


        :param name: The name of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: str
        """
        

        self._name = name

    @property
    def address(self) -> str:
        """
        Gets the address of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The address of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: str
        """
        return self._address

    @address.setter
    def address(self, address: str) -> None:
        """
        Sets the address of this ConversationVideoEventTopicVideoMediaParticipant.


        :param address: The address of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: str
        """
        

        self._address = address

    @property
    def start_time(self) -> datetime:
        """
        Gets the start_time of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The start_time of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: datetime
        """
        return self._start_time

    @start_time.setter
    def start_time(self, start_time: datetime) -> None:
        """
        Sets the start_time of this ConversationVideoEventTopicVideoMediaParticipant.


        :param start_time: The start_time of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: datetime
        """
        

        self._start_time = start_time

    @property
    def connected_time(self) -> datetime:
        """
        Gets the connected_time of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The connected_time of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: datetime
        """
        return self._connected_time

    @connected_time.setter
    def connected_time(self, connected_time: datetime) -> None:
        """
        Sets the connected_time of this ConversationVideoEventTopicVideoMediaParticipant.


        :param connected_time: The connected_time of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: datetime
        """
        

        self._connected_time = connected_time

    @property
    def end_time(self) -> datetime:
        """
        Gets the end_time of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The end_time of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: datetime
        """
        return self._end_time

    @end_time.setter
    def end_time(self, end_time: datetime) -> None:
        """
        Sets the end_time of this ConversationVideoEventTopicVideoMediaParticipant.


        :param end_time: The end_time of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: datetime
        """
        

        self._end_time = end_time

    @property
    def start_hold_time(self) -> datetime:
        """
        Gets the start_hold_time of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The start_hold_time of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: datetime
        """
        return self._start_hold_time

    @start_hold_time.setter
    def start_hold_time(self, start_hold_time: datetime) -> None:
        """
        Sets the start_hold_time of this ConversationVideoEventTopicVideoMediaParticipant.


        :param start_hold_time: The start_hold_time of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: datetime
        """
        

        self._start_hold_time = start_hold_time

    @property
    def purpose(self) -> str:
        """
        Gets the purpose of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The purpose of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: str
        """
        return self._purpose

    @purpose.setter
    def purpose(self, purpose: str) -> None:
        """
        Sets the purpose of this ConversationVideoEventTopicVideoMediaParticipant.


        :param purpose: The purpose of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: str
        """
        

        self._purpose = purpose

    @property
    def state(self) -> str:
        """
        Gets the state of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The state of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this ConversationVideoEventTopicVideoMediaParticipant.


        :param state: The state of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: str
        """
        if isinstance(state, int):
            state = str(state)
        allowed_values = ["alerting", "dialing", "contacting", "offering", "connected", "disconnected", "terminated", "converting", "uploading", "transmitting", "scheduled", "parked", "none"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def initial_state(self) -> str:
        """
        Gets the initial_state of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The initial_state of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: str
        """
        return self._initial_state

    @initial_state.setter
    def initial_state(self, initial_state: str) -> None:
        """
        Sets the initial_state of this ConversationVideoEventTopicVideoMediaParticipant.


        :param initial_state: The initial_state of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: str
        """
        if isinstance(initial_state, int):
            initial_state = str(initial_state)
        allowed_values = ["alerting", "dialing", "contacting", "offering", "connected", "disconnected", "terminated", "converting", "uploading", "transmitting", "scheduled", "parked", "none"]
        if initial_state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for initial_state -> " + initial_state)
            self._initial_state = "outdated_sdk_version"
        else:
            self._initial_state = initial_state

    @property
    def direction(self) -> str:
        """
        Gets the direction of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The direction of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: str
        """
        return self._direction

    @direction.setter
    def direction(self, direction: str) -> None:
        """
        Sets the direction of this ConversationVideoEventTopicVideoMediaParticipant.


        :param direction: The direction of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: str
        """
        if isinstance(direction, int):
            direction = str(direction)
        allowed_values = ["inbound", "outbound"]
        if direction.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for direction -> " + direction)
            self._direction = "outdated_sdk_version"
        else:
            self._direction = direction

    @property
    def disconnect_type(self) -> str:
        """
        Gets the disconnect_type of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The disconnect_type of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: str
        """
        return self._disconnect_type

    @disconnect_type.setter
    def disconnect_type(self, disconnect_type: str) -> None:
        """
        Sets the disconnect_type of this ConversationVideoEventTopicVideoMediaParticipant.


        :param disconnect_type: The disconnect_type of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: str
        """
        if isinstance(disconnect_type, int):
            disconnect_type = str(disconnect_type)
        allowed_values = ["endpoint", "endpoint.dnd", "client", "system", "transfer", "timeout", "transfer.conference", "transfer.consult", "transfer.forward", "transfer.noanswer", "transfer.notavailable", "transfer.dnd", "transport.failure", "error", "peer", "other", "spam", "uncallable"]
        if disconnect_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for disconnect_type -> " + disconnect_type)
            self._disconnect_type = "outdated_sdk_version"
        else:
            self._disconnect_type = disconnect_type

    @property
    def held(self) -> bool:
        """
        Gets the held of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The held of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: bool
        """
        return self._held

    @held.setter
    def held(self, held: bool) -> None:
        """
        Sets the held of this ConversationVideoEventTopicVideoMediaParticipant.


        :param held: The held of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: bool
        """
        

        self._held = held

    @property
    def wrapup_required(self) -> bool:
        """
        Gets the wrapup_required of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The wrapup_required of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: bool
        """
        return self._wrapup_required

    @wrapup_required.setter
    def wrapup_required(self, wrapup_required: bool) -> None:
        """
        Sets the wrapup_required of this ConversationVideoEventTopicVideoMediaParticipant.


        :param wrapup_required: The wrapup_required of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: bool
        """
        

        self._wrapup_required = wrapup_required

    @property
    def wrapup_prompt(self) -> str:
        """
        Gets the wrapup_prompt of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The wrapup_prompt of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: str
        """
        return self._wrapup_prompt

    @wrapup_prompt.setter
    def wrapup_prompt(self, wrapup_prompt: str) -> None:
        """
        Sets the wrapup_prompt of this ConversationVideoEventTopicVideoMediaParticipant.


        :param wrapup_prompt: The wrapup_prompt of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: str
        """
        

        self._wrapup_prompt = wrapup_prompt

    @property
    def user(self) -> 'ConversationVideoEventTopicUriReference':
        """
        Gets the user of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The user of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: ConversationVideoEventTopicUriReference
        """
        return self._user

    @user.setter
    def user(self, user: 'ConversationVideoEventTopicUriReference') -> None:
        """
        Sets the user of this ConversationVideoEventTopicVideoMediaParticipant.


        :param user: The user of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: ConversationVideoEventTopicUriReference
        """
        

        self._user = user

    @property
    def queue(self) -> 'ConversationVideoEventTopicUriReference':
        """
        Gets the queue of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The queue of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: ConversationVideoEventTopicUriReference
        """
        return self._queue

    @queue.setter
    def queue(self, queue: 'ConversationVideoEventTopicUriReference') -> None:
        """
        Sets the queue of this ConversationVideoEventTopicVideoMediaParticipant.


        :param queue: The queue of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: ConversationVideoEventTopicUriReference
        """
        

        self._queue = queue

    @property
    def team(self) -> 'ConversationVideoEventTopicUriReference':
        """
        Gets the team of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The team of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: ConversationVideoEventTopicUriReference
        """
        return self._team

    @team.setter
    def team(self, team: 'ConversationVideoEventTopicUriReference') -> None:
        """
        Sets the team of this ConversationVideoEventTopicVideoMediaParticipant.


        :param team: The team of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: ConversationVideoEventTopicUriReference
        """
        

        self._team = team

    @property
    def attributes(self) -> Dict[str, str]:
        """
        Gets the attributes of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The attributes of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: dict(str, str)
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes: Dict[str, str]) -> None:
        """
        Sets the attributes of this ConversationVideoEventTopicVideoMediaParticipant.


        :param attributes: The attributes of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: dict(str, str)
        """
        

        self._attributes = attributes

    @property
    def error_info(self) -> 'ConversationVideoEventTopicErrorBody':
        """
        Gets the error_info of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The error_info of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: ConversationVideoEventTopicErrorBody
        """
        return self._error_info

    @error_info.setter
    def error_info(self, error_info: 'ConversationVideoEventTopicErrorBody') -> None:
        """
        Sets the error_info of this ConversationVideoEventTopicVideoMediaParticipant.


        :param error_info: The error_info of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: ConversationVideoEventTopicErrorBody
        """
        

        self._error_info = error_info

    @property
    def script(self) -> 'ConversationVideoEventTopicUriReference':
        """
        Gets the script of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The script of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: ConversationVideoEventTopicUriReference
        """
        return self._script

    @script.setter
    def script(self, script: 'ConversationVideoEventTopicUriReference') -> None:
        """
        Sets the script of this ConversationVideoEventTopicVideoMediaParticipant.


        :param script: The script of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: ConversationVideoEventTopicUriReference
        """
        

        self._script = script

    @property
    def wrapup_timeout_ms(self) -> int:
        """
        Gets the wrapup_timeout_ms of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The wrapup_timeout_ms of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: int
        """
        return self._wrapup_timeout_ms

    @wrapup_timeout_ms.setter
    def wrapup_timeout_ms(self, wrapup_timeout_ms: int) -> None:
        """
        Sets the wrapup_timeout_ms of this ConversationVideoEventTopicVideoMediaParticipant.


        :param wrapup_timeout_ms: The wrapup_timeout_ms of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: int
        """
        

        self._wrapup_timeout_ms = wrapup_timeout_ms

    @property
    def wrapup_skipped(self) -> bool:
        """
        Gets the wrapup_skipped of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The wrapup_skipped of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: bool
        """
        return self._wrapup_skipped

    @wrapup_skipped.setter
    def wrapup_skipped(self, wrapup_skipped: bool) -> None:
        """
        Sets the wrapup_skipped of this ConversationVideoEventTopicVideoMediaParticipant.


        :param wrapup_skipped: The wrapup_skipped of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: bool
        """
        

        self._wrapup_skipped = wrapup_skipped

    @property
    def alerting_timeout_ms(self) -> int:
        """
        Gets the alerting_timeout_ms of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The alerting_timeout_ms of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: int
        """
        return self._alerting_timeout_ms

    @alerting_timeout_ms.setter
    def alerting_timeout_ms(self, alerting_timeout_ms: int) -> None:
        """
        Sets the alerting_timeout_ms of this ConversationVideoEventTopicVideoMediaParticipant.


        :param alerting_timeout_ms: The alerting_timeout_ms of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: int
        """
        

        self._alerting_timeout_ms = alerting_timeout_ms

    @property
    def provider(self) -> str:
        """
        Gets the provider of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The provider of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: str
        """
        return self._provider

    @provider.setter
    def provider(self, provider: str) -> None:
        """
        Sets the provider of this ConversationVideoEventTopicVideoMediaParticipant.


        :param provider: The provider of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: str
        """
        

        self._provider = provider

    @property
    def external_contact(self) -> 'ConversationVideoEventTopicUriReference':
        """
        Gets the external_contact of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The external_contact of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: ConversationVideoEventTopicUriReference
        """
        return self._external_contact

    @external_contact.setter
    def external_contact(self, external_contact: 'ConversationVideoEventTopicUriReference') -> None:
        """
        Sets the external_contact of this ConversationVideoEventTopicVideoMediaParticipant.


        :param external_contact: The external_contact of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: ConversationVideoEventTopicUriReference
        """
        

        self._external_contact = external_contact

    @property
    def external_contact_initial_division_id(self) -> str:
        """
        Gets the external_contact_initial_division_id of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The external_contact_initial_division_id of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: str
        """
        return self._external_contact_initial_division_id

    @external_contact_initial_division_id.setter
    def external_contact_initial_division_id(self, external_contact_initial_division_id: str) -> None:
        """
        Sets the external_contact_initial_division_id of this ConversationVideoEventTopicVideoMediaParticipant.


        :param external_contact_initial_division_id: The external_contact_initial_division_id of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: str
        """
        

        self._external_contact_initial_division_id = external_contact_initial_division_id

    @property
    def external_organization(self) -> 'ConversationVideoEventTopicUriReference':
        """
        Gets the external_organization of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The external_organization of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: ConversationVideoEventTopicUriReference
        """
        return self._external_organization

    @external_organization.setter
    def external_organization(self, external_organization: 'ConversationVideoEventTopicUriReference') -> None:
        """
        Sets the external_organization of this ConversationVideoEventTopicVideoMediaParticipant.


        :param external_organization: The external_organization of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: ConversationVideoEventTopicUriReference
        """
        

        self._external_organization = external_organization

    @property
    def wrapup(self) -> 'ConversationVideoEventTopicWrapup':
        """
        Gets the wrapup of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The wrapup of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: ConversationVideoEventTopicWrapup
        """
        return self._wrapup

    @wrapup.setter
    def wrapup(self, wrapup: 'ConversationVideoEventTopicWrapup') -> None:
        """
        Sets the wrapup of this ConversationVideoEventTopicVideoMediaParticipant.


        :param wrapup: The wrapup of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: ConversationVideoEventTopicWrapup
        """
        

        self._wrapup = wrapup

    @property
    def conversation_routing_data(self) -> 'ConversationVideoEventTopicConversationRoutingData':
        """
        Gets the conversation_routing_data of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The conversation_routing_data of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: ConversationVideoEventTopicConversationRoutingData
        """
        return self._conversation_routing_data

    @conversation_routing_data.setter
    def conversation_routing_data(self, conversation_routing_data: 'ConversationVideoEventTopicConversationRoutingData') -> None:
        """
        Sets the conversation_routing_data of this ConversationVideoEventTopicVideoMediaParticipant.


        :param conversation_routing_data: The conversation_routing_data of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: ConversationVideoEventTopicConversationRoutingData
        """
        

        self._conversation_routing_data = conversation_routing_data

    @property
    def peer(self) -> str:
        """
        Gets the peer of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The peer of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: str
        """
        return self._peer

    @peer.setter
    def peer(self, peer: str) -> None:
        """
        Sets the peer of this ConversationVideoEventTopicVideoMediaParticipant.


        :param peer: The peer of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: str
        """
        

        self._peer = peer

    @property
    def screen_recording_state(self) -> str:
        """
        Gets the screen_recording_state of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The screen_recording_state of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: str
        """
        return self._screen_recording_state

    @screen_recording_state.setter
    def screen_recording_state(self, screen_recording_state: str) -> None:
        """
        Sets the screen_recording_state of this ConversationVideoEventTopicVideoMediaParticipant.


        :param screen_recording_state: The screen_recording_state of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: str
        """
        

        self._screen_recording_state = screen_recording_state

    @property
    def flagged_reason(self) -> str:
        """
        Gets the flagged_reason of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The flagged_reason of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: str
        """
        return self._flagged_reason

    @flagged_reason.setter
    def flagged_reason(self, flagged_reason: str) -> None:
        """
        Sets the flagged_reason of this ConversationVideoEventTopicVideoMediaParticipant.


        :param flagged_reason: The flagged_reason of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: str
        """
        if isinstance(flagged_reason, int):
            flagged_reason = str(flagged_reason)
        allowed_values = ["general"]
        if flagged_reason.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for flagged_reason -> " + flagged_reason)
            self._flagged_reason = "outdated_sdk_version"
        else:
            self._flagged_reason = flagged_reason

    @property
    def journey_context(self) -> 'ConversationVideoEventTopicJourneyContext':
        """
        Gets the journey_context of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The journey_context of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: ConversationVideoEventTopicJourneyContext
        """
        return self._journey_context

    @journey_context.setter
    def journey_context(self, journey_context: 'ConversationVideoEventTopicJourneyContext') -> None:
        """
        Sets the journey_context of this ConversationVideoEventTopicVideoMediaParticipant.


        :param journey_context: The journey_context of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: ConversationVideoEventTopicJourneyContext
        """
        

        self._journey_context = journey_context

    @property
    def start_acw_time(self) -> datetime:
        """
        Gets the start_acw_time of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The start_acw_time of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: datetime
        """
        return self._start_acw_time

    @start_acw_time.setter
    def start_acw_time(self, start_acw_time: datetime) -> None:
        """
        Sets the start_acw_time of this ConversationVideoEventTopicVideoMediaParticipant.


        :param start_acw_time: The start_acw_time of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: datetime
        """
        

        self._start_acw_time = start_acw_time

    @property
    def end_acw_time(self) -> datetime:
        """
        Gets the end_acw_time of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The end_acw_time of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: datetime
        """
        return self._end_acw_time

    @end_acw_time.setter
    def end_acw_time(self, end_acw_time: datetime) -> None:
        """
        Sets the end_acw_time of this ConversationVideoEventTopicVideoMediaParticipant.


        :param end_acw_time: The end_acw_time of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: datetime
        """
        

        self._end_acw_time = end_acw_time

    @property
    def resume_time(self) -> datetime:
        """
        Gets the resume_time of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The resume_time of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: datetime
        """
        return self._resume_time

    @resume_time.setter
    def resume_time(self, resume_time: datetime) -> None:
        """
        Sets the resume_time of this ConversationVideoEventTopicVideoMediaParticipant.


        :param resume_time: The resume_time of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: datetime
        """
        

        self._resume_time = resume_time

    @property
    def park_time(self) -> datetime:
        """
        Gets the park_time of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The park_time of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: datetime
        """
        return self._park_time

    @park_time.setter
    def park_time(self, park_time: datetime) -> None:
        """
        Sets the park_time of this ConversationVideoEventTopicVideoMediaParticipant.


        :param park_time: The park_time of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: datetime
        """
        

        self._park_time = park_time

    @property
    def media_roles(self) -> List[str]:
        """
        Gets the media_roles of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The media_roles of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: list[str]
        """
        return self._media_roles

    @media_roles.setter
    def media_roles(self, media_roles: List[str]) -> None:
        """
        Sets the media_roles of this ConversationVideoEventTopicVideoMediaParticipant.


        :param media_roles: The media_roles of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: list[str]
        """
        

        self._media_roles = media_roles

    @property
    def queue_media_settings(self) -> 'ConversationVideoEventTopicQueueMediaSettings':
        """
        Gets the queue_media_settings of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The queue_media_settings of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: ConversationVideoEventTopicQueueMediaSettings
        """
        return self._queue_media_settings

    @queue_media_settings.setter
    def queue_media_settings(self, queue_media_settings: 'ConversationVideoEventTopicQueueMediaSettings') -> None:
        """
        Sets the queue_media_settings of this ConversationVideoEventTopicVideoMediaParticipant.


        :param queue_media_settings: The queue_media_settings of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: ConversationVideoEventTopicQueueMediaSettings
        """
        

        self._queue_media_settings = queue_media_settings

    @property
    def audio_muted(self) -> bool:
        """
        Gets the audio_muted of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The audio_muted of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: bool
        """
        return self._audio_muted

    @audio_muted.setter
    def audio_muted(self, audio_muted: bool) -> None:
        """
        Sets the audio_muted of this ConversationVideoEventTopicVideoMediaParticipant.


        :param audio_muted: The audio_muted of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: bool
        """
        

        self._audio_muted = audio_muted

    @property
    def video_muted(self) -> bool:
        """
        Gets the video_muted of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The video_muted of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: bool
        """
        return self._video_muted

    @video_muted.setter
    def video_muted(self, video_muted: bool) -> None:
        """
        Sets the video_muted of this ConversationVideoEventTopicVideoMediaParticipant.


        :param video_muted: The video_muted of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: bool
        """
        

        self._video_muted = video_muted

    @property
    def sharing_screen(self) -> bool:
        """
        Gets the sharing_screen of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The sharing_screen of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: bool
        """
        return self._sharing_screen

    @sharing_screen.setter
    def sharing_screen(self, sharing_screen: bool) -> None:
        """
        Sets the sharing_screen of this ConversationVideoEventTopicVideoMediaParticipant.


        :param sharing_screen: The sharing_screen of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: bool
        """
        

        self._sharing_screen = sharing_screen

    @property
    def peer_count(self) -> int:
        """
        Gets the peer_count of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The peer_count of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: int
        """
        return self._peer_count

    @peer_count.setter
    def peer_count(self, peer_count: int) -> None:
        """
        Sets the peer_count of this ConversationVideoEventTopicVideoMediaParticipant.


        :param peer_count: The peer_count of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: int
        """
        

        self._peer_count = peer_count

    @property
    def context(self) -> str:
        """
        Gets the context of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The context of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: str
        """
        return self._context

    @context.setter
    def context(self, context: str) -> None:
        """
        Sets the context of this ConversationVideoEventTopicVideoMediaParticipant.


        :param context: The context of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: str
        """
        

        self._context = context

    @property
    def msids(self) -> List[str]:
        """
        Gets the msids of this ConversationVideoEventTopicVideoMediaParticipant.


        :return: The msids of this ConversationVideoEventTopicVideoMediaParticipant.
        :rtype: list[str]
        """
        return self._msids

    @msids.setter
    def msids(self, msids: List[str]) -> None:
        """
        Sets the msids of this ConversationVideoEventTopicVideoMediaParticipant.


        :param msids: The msids of this ConversationVideoEventTopicVideoMediaParticipant.
        :type: list[str]
        """
        

        self._msids = msids

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

