# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef
    from . import ConversationEditedInput
    from . import ConversationSummaryFollowup
    from . import ConversationSummaryReason
    from . import ConversationSummaryResolution
    from . import ConversationSummaryWrapupCode
    from . import Entity

class ConversationSessionSummary(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ConversationSessionSummary - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'text': 'str',
            'status': 'str',
            'media_type': 'str',
            'language': 'str',
            'predicted_wrapup_codes': 'list[ConversationSummaryWrapupCode]',
            'edited_summary': 'ConversationEditedInput',
            'reason': 'ConversationSummaryReason',
            'followup': 'ConversationSummaryFollowup',
            'resolution': 'ConversationSummaryResolution',
            'date_created': 'datetime',
            'id': 'str',
            'confidence': 'float',
            'participants': 'list[AddressableEntityRef]',
            'communication': 'Entity'
        }

        self.attribute_map = {
            'text': 'text',
            'status': 'status',
            'media_type': 'mediaType',
            'language': 'language',
            'predicted_wrapup_codes': 'predictedWrapupCodes',
            'edited_summary': 'editedSummary',
            'reason': 'reason',
            'followup': 'followup',
            'resolution': 'resolution',
            'date_created': 'dateCreated',
            'id': 'id',
            'confidence': 'confidence',
            'participants': 'participants',
            'communication': 'communication'
        }

        self._text = None
        self._status = None
        self._media_type = None
        self._language = None
        self._predicted_wrapup_codes = None
        self._edited_summary = None
        self._reason = None
        self._followup = None
        self._resolution = None
        self._date_created = None
        self._id = None
        self._confidence = None
        self._participants = None
        self._communication = None

    @property
    def text(self) -> str:
        """
        Gets the text of this ConversationSessionSummary.
        The text of the summary.

        :return: The text of this ConversationSessionSummary.
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text: str) -> None:
        """
        Sets the text of this ConversationSessionSummary.
        The text of the summary.

        :param text: The text of this ConversationSessionSummary.
        :type: str
        """
        

        self._text = text

    @property
    def status(self) -> str:
        """
        Gets the status of this ConversationSessionSummary.
        The status of the conversation summary.

        :return: The status of this ConversationSessionSummary.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this ConversationSessionSummary.
        The status of the conversation summary.

        :param status: The status of this ConversationSessionSummary.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Pending", "Queued", "Started", "Completed", "Error", "Processing"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def media_type(self) -> str:
        """
        Gets the media_type of this ConversationSessionSummary.
        The media type of the conversation.

        :return: The media_type of this ConversationSessionSummary.
        :rtype: str
        """
        return self._media_type

    @media_type.setter
    def media_type(self, media_type: str) -> None:
        """
        Sets the media_type of this ConversationSessionSummary.
        The media type of the conversation.

        :param media_type: The media_type of this ConversationSessionSummary.
        :type: str
        """
        if isinstance(media_type, int):
            media_type = str(media_type)
        allowed_values = ["Email", "Call", "Chat", "Message", "Webmessaging", "Unknown"]
        if media_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for media_type -> " + media_type)
            self._media_type = "outdated_sdk_version"
        else:
            self._media_type = media_type

    @property
    def language(self) -> str:
        """
        Gets the language of this ConversationSessionSummary.
        The language of the conversation.

        :return: The language of this ConversationSessionSummary.
        :rtype: str
        """
        return self._language

    @language.setter
    def language(self, language: str) -> None:
        """
        Sets the language of this ConversationSessionSummary.
        The language of the conversation.

        :param language: The language of this ConversationSessionSummary.
        :type: str
        """
        

        self._language = language

    @property
    def predicted_wrapup_codes(self) -> List['ConversationSummaryWrapupCode']:
        """
        Gets the predicted_wrapup_codes of this ConversationSessionSummary.
        The wrapup codes of the conversation summary.

        :return: The predicted_wrapup_codes of this ConversationSessionSummary.
        :rtype: list[ConversationSummaryWrapupCode]
        """
        return self._predicted_wrapup_codes

    @predicted_wrapup_codes.setter
    def predicted_wrapup_codes(self, predicted_wrapup_codes: List['ConversationSummaryWrapupCode']) -> None:
        """
        Sets the predicted_wrapup_codes of this ConversationSessionSummary.
        The wrapup codes of the conversation summary.

        :param predicted_wrapup_codes: The predicted_wrapup_codes of this ConversationSessionSummary.
        :type: list[ConversationSummaryWrapupCode]
        """
        

        self._predicted_wrapup_codes = predicted_wrapup_codes

    @property
    def edited_summary(self) -> 'ConversationEditedInput':
        """
        Gets the edited_summary of this ConversationSessionSummary.
        The edited summary of the conversation.

        :return: The edited_summary of this ConversationSessionSummary.
        :rtype: ConversationEditedInput
        """
        return self._edited_summary

    @edited_summary.setter
    def edited_summary(self, edited_summary: 'ConversationEditedInput') -> None:
        """
        Sets the edited_summary of this ConversationSessionSummary.
        The edited summary of the conversation.

        :param edited_summary: The edited_summary of this ConversationSessionSummary.
        :type: ConversationEditedInput
        """
        

        self._edited_summary = edited_summary

    @property
    def reason(self) -> 'ConversationSummaryReason':
        """
        Gets the reason of this ConversationSessionSummary.
        The reason of the conversation summary.

        :return: The reason of this ConversationSessionSummary.
        :rtype: ConversationSummaryReason
        """
        return self._reason

    @reason.setter
    def reason(self, reason: 'ConversationSummaryReason') -> None:
        """
        Sets the reason of this ConversationSessionSummary.
        The reason of the conversation summary.

        :param reason: The reason of this ConversationSessionSummary.
        :type: ConversationSummaryReason
        """
        

        self._reason = reason

    @property
    def followup(self) -> 'ConversationSummaryFollowup':
        """
        Gets the followup of this ConversationSessionSummary.
        The followup of the conversation summary.

        :return: The followup of this ConversationSessionSummary.
        :rtype: ConversationSummaryFollowup
        """
        return self._followup

    @followup.setter
    def followup(self, followup: 'ConversationSummaryFollowup') -> None:
        """
        Sets the followup of this ConversationSessionSummary.
        The followup of the conversation summary.

        :param followup: The followup of this ConversationSessionSummary.
        :type: ConversationSummaryFollowup
        """
        

        self._followup = followup

    @property
    def resolution(self) -> 'ConversationSummaryResolution':
        """
        Gets the resolution of this ConversationSessionSummary.
        The resolution of the conversation summary.

        :return: The resolution of this ConversationSessionSummary.
        :rtype: ConversationSummaryResolution
        """
        return self._resolution

    @resolution.setter
    def resolution(self, resolution: 'ConversationSummaryResolution') -> None:
        """
        Sets the resolution of this ConversationSessionSummary.
        The resolution of the conversation summary.

        :param resolution: The resolution of this ConversationSessionSummary.
        :type: ConversationSummaryResolution
        """
        

        self._resolution = resolution

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this ConversationSessionSummary.
        The created date of the summary. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this ConversationSessionSummary.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this ConversationSessionSummary.
        The created date of the summary. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this ConversationSessionSummary.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def id(self) -> str:
        """
        Gets the id of this ConversationSessionSummary.
        The id of the summary.

        :return: The id of this ConversationSessionSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ConversationSessionSummary.
        The id of the summary.

        :param id: The id of this ConversationSessionSummary.
        :type: str
        """
        

        self._id = id

    @property
    def confidence(self) -> float:
        """
        Gets the confidence of this ConversationSessionSummary.
        The AI confidence value.

        :return: The confidence of this ConversationSessionSummary.
        :rtype: float
        """
        return self._confidence

    @confidence.setter
    def confidence(self, confidence: float) -> None:
        """
        Sets the confidence of this ConversationSessionSummary.
        The AI confidence value.

        :param confidence: The confidence of this ConversationSessionSummary.
        :type: float
        """
        

        self._confidence = confidence

    @property
    def participants(self) -> List['AddressableEntityRef']:
        """
        Gets the participants of this ConversationSessionSummary.
        The list of participants.

        :return: The participants of this ConversationSessionSummary.
        :rtype: list[AddressableEntityRef]
        """
        return self._participants

    @participants.setter
    def participants(self, participants: List['AddressableEntityRef']) -> None:
        """
        Sets the participants of this ConversationSessionSummary.
        The list of participants.

        :param participants: The participants of this ConversationSessionSummary.
        :type: list[AddressableEntityRef]
        """
        

        self._participants = participants

    @property
    def communication(self) -> 'Entity':
        """
        Gets the communication of this ConversationSessionSummary.
        The communication object of the summary.

        :return: The communication of this ConversationSessionSummary.
        :rtype: Entity
        """
        return self._communication

    @communication.setter
    def communication(self, communication: 'Entity') -> None:
        """
        Sets the communication of this ConversationSessionSummary.
        The communication object of the summary.

        :param communication: The communication of this ConversationSessionSummary.
        :type: Entity
        """
        

        self._communication = communication

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

