# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ConversationContentReceivedReplyMessage

class ConversationContentInteractiveApplication(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ConversationContentInteractiveApplication - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'url': 'str',
            'received_message': 'ConversationContentReceivedReplyMessage',
            'reply_message': 'ConversationContentReceivedReplyMessage'
        }

        self.attribute_map = {
            'name': 'name',
            'url': 'url',
            'received_message': 'receivedMessage',
            'reply_message': 'replyMessage'
        }

        self._name = None
        self._url = None
        self._received_message = None
        self._reply_message = None

    @property
    def name(self) -> str:
        """
        Gets the name of this ConversationContentInteractiveApplication.
        The name of the message app.

        :return: The name of this ConversationContentInteractiveApplication.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this ConversationContentInteractiveApplication.
        The name of the message app.

        :param name: The name of this ConversationContentInteractiveApplication.
        :type: str
        """
        

        self._name = name

    @property
    def url(self) -> str:
        """
        Gets the url of this ConversationContentInteractiveApplication.
        Contains the data that is sent to the message app.

        :return: The url of this ConversationContentInteractiveApplication.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url: str) -> None:
        """
        Sets the url of this ConversationContentInteractiveApplication.
        Contains the data that is sent to the message app.

        :param url: The url of this ConversationContentInteractiveApplication.
        :type: str
        """
        

        self._url = url

    @property
    def received_message(self) -> 'ConversationContentReceivedReplyMessage':
        """
        Gets the received_message of this ConversationContentInteractiveApplication.
        The message displayed in the received message bubble.

        :return: The received_message of this ConversationContentInteractiveApplication.
        :rtype: ConversationContentReceivedReplyMessage
        """
        return self._received_message

    @received_message.setter
    def received_message(self, received_message: 'ConversationContentReceivedReplyMessage') -> None:
        """
        Sets the received_message of this ConversationContentInteractiveApplication.
        The message displayed in the received message bubble.

        :param received_message: The received_message of this ConversationContentInteractiveApplication.
        :type: ConversationContentReceivedReplyMessage
        """
        

        self._received_message = received_message

    @property
    def reply_message(self) -> 'ConversationContentReceivedReplyMessage':
        """
        Gets the reply_message of this ConversationContentInteractiveApplication.
        The message displayed in the reply message bubble.

        :return: The reply_message of this ConversationContentInteractiveApplication.
        :rtype: ConversationContentReceivedReplyMessage
        """
        return self._reply_message

    @reply_message.setter
    def reply_message(self, reply_message: 'ConversationContentReceivedReplyMessage') -> None:
        """
        Sets the reply_message of this ConversationContentInteractiveApplication.
        The message displayed in the reply message bubble.

        :param reply_message: The reply_message of this ConversationContentInteractiveApplication.
        :type: ConversationContentReceivedReplyMessage
        """
        

        self._reply_message = reply_message

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

