# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import Operand

class ConversationCategory(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ConversationCategory - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'description': 'str',
            'interaction_type': 'str',
            'criteria': 'Operand'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'interaction_type': 'interactionType',
            'criteria': 'criteria'
        }

        self._id = None
        self._name = None
        self._description = None
        self._interaction_type = None
        self._criteria = None

    @property
    def id(self) -> str:
        """
        Gets the id of this ConversationCategory.
        The id of the category

        :return: The id of this ConversationCategory.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ConversationCategory.
        The id of the category

        :param id: The id of this ConversationCategory.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this ConversationCategory.
        The name of the category

        :return: The name of this ConversationCategory.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this ConversationCategory.
        The name of the category

        :param name: The name of this ConversationCategory.
        :type: str
        """
        

        self._name = name

    @property
    def description(self) -> str:
        """
        Gets the description of this ConversationCategory.
        The description of the category

        :return: The description of this ConversationCategory.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this ConversationCategory.
        The description of the category

        :param description: The description of this ConversationCategory.
        :type: str
        """
        

        self._description = description

    @property
    def interaction_type(self) -> str:
        """
        Gets the interaction_type of this ConversationCategory.
        The type of interaction the category will apply to

        :return: The interaction_type of this ConversationCategory.
        :rtype: str
        """
        return self._interaction_type

    @interaction_type.setter
    def interaction_type(self, interaction_type: str) -> None:
        """
        Sets the interaction_type of this ConversationCategory.
        The type of interaction the category will apply to

        :param interaction_type: The interaction_type of this ConversationCategory.
        :type: str
        """
        if isinstance(interaction_type, int):
            interaction_type = str(interaction_type)
        allowed_values = ["Voice", "Digital", "All"]
        if interaction_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for interaction_type -> " + interaction_type)
            self._interaction_type = "outdated_sdk_version"
        else:
            self._interaction_type = interaction_type

    @property
    def criteria(self) -> 'Operand':
        """
        Gets the criteria of this ConversationCategory.
        A collection of conditions joined together by logical operation to provide more refined filtering of conversations

        :return: The criteria of this ConversationCategory.
        :rtype: Operand
        """
        return self._criteria

    @criteria.setter
    def criteria(self, criteria: 'Operand') -> None:
        """
        Sets the criteria of this ConversationCategory.
        A collection of conditions joined together by logical operation to provide more refined filtering of conversations

        :param criteria: The criteria of this ConversationCategory.
        :type: Operand
        """
        

        self._criteria = criteria

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

