# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AutoStart
    from . import ConversationClearSettings
    from . import ConversationDisconnectSettings
    from . import Humanize
    from . import Markdown
    from . import NotificationsSettings

class ConversationAppSettings(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ConversationAppSettings - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'enabled': 'bool',
            'show_agent_typing_indicator': 'bool',
            'show_user_typing_indicator': 'bool',
            'auto_start': 'AutoStart',
            'markdown': 'Markdown',
            'conversation_disconnect': 'ConversationDisconnectSettings',
            'conversation_clear': 'ConversationClearSettings',
            'humanize': 'Humanize',
            'notifications': 'NotificationsSettings'
        }

        self.attribute_map = {
            'enabled': 'enabled',
            'show_agent_typing_indicator': 'showAgentTypingIndicator',
            'show_user_typing_indicator': 'showUserTypingIndicator',
            'auto_start': 'autoStart',
            'markdown': 'markdown',
            'conversation_disconnect': 'conversationDisconnect',
            'conversation_clear': 'conversationClear',
            'humanize': 'humanize',
            'notifications': 'notifications'
        }

        self._enabled = None
        self._show_agent_typing_indicator = None
        self._show_user_typing_indicator = None
        self._auto_start = None
        self._markdown = None
        self._conversation_disconnect = None
        self._conversation_clear = None
        self._humanize = None
        self._notifications = None

    @property
    def enabled(self) -> bool:
        """
        Gets the enabled of this ConversationAppSettings.
        The toggle to enable or disable conversations

        :return: The enabled of this ConversationAppSettings.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled: bool) -> None:
        """
        Sets the enabled of this ConversationAppSettings.
        The toggle to enable or disable conversations

        :param enabled: The enabled of this ConversationAppSettings.
        :type: bool
        """
        

        self._enabled = enabled

    @property
    def show_agent_typing_indicator(self) -> bool:
        """
        Gets the show_agent_typing_indicator of this ConversationAppSettings.
        The toggle to enable or disable typing indicator for messenger

        :return: The show_agent_typing_indicator of this ConversationAppSettings.
        :rtype: bool
        """
        return self._show_agent_typing_indicator

    @show_agent_typing_indicator.setter
    def show_agent_typing_indicator(self, show_agent_typing_indicator: bool) -> None:
        """
        Sets the show_agent_typing_indicator of this ConversationAppSettings.
        The toggle to enable or disable typing indicator for messenger

        :param show_agent_typing_indicator: The show_agent_typing_indicator of this ConversationAppSettings.
        :type: bool
        """
        

        self._show_agent_typing_indicator = show_agent_typing_indicator

    @property
    def show_user_typing_indicator(self) -> bool:
        """
        Gets the show_user_typing_indicator of this ConversationAppSettings.
        The toggle to enable or disable typing indicator for messenger

        :return: The show_user_typing_indicator of this ConversationAppSettings.
        :rtype: bool
        """
        return self._show_user_typing_indicator

    @show_user_typing_indicator.setter
    def show_user_typing_indicator(self, show_user_typing_indicator: bool) -> None:
        """
        Sets the show_user_typing_indicator of this ConversationAppSettings.
        The toggle to enable or disable typing indicator for messenger

        :param show_user_typing_indicator: The show_user_typing_indicator of this ConversationAppSettings.
        :type: bool
        """
        

        self._show_user_typing_indicator = show_user_typing_indicator

    @property
    def auto_start(self) -> 'AutoStart':
        """
        Gets the auto_start of this ConversationAppSettings.
        The auto start for the messenger conversation

        :return: The auto_start of this ConversationAppSettings.
        :rtype: AutoStart
        """
        return self._auto_start

    @auto_start.setter
    def auto_start(self, auto_start: 'AutoStart') -> None:
        """
        Sets the auto_start of this ConversationAppSettings.
        The auto start for the messenger conversation

        :param auto_start: The auto_start of this ConversationAppSettings.
        :type: AutoStart
        """
        

        self._auto_start = auto_start

    @property
    def markdown(self) -> 'Markdown':
        """
        Gets the markdown of this ConversationAppSettings.
        The markdown for the messenger app

        :return: The markdown of this ConversationAppSettings.
        :rtype: Markdown
        """
        return self._markdown

    @markdown.setter
    def markdown(self, markdown: 'Markdown') -> None:
        """
        Sets the markdown of this ConversationAppSettings.
        The markdown for the messenger app

        :param markdown: The markdown of this ConversationAppSettings.
        :type: Markdown
        """
        

        self._markdown = markdown

    @property
    def conversation_disconnect(self) -> 'ConversationDisconnectSettings':
        """
        Gets the conversation_disconnect of this ConversationAppSettings.
        The conversation disconnect settings for the messenger app

        :return: The conversation_disconnect of this ConversationAppSettings.
        :rtype: ConversationDisconnectSettings
        """
        return self._conversation_disconnect

    @conversation_disconnect.setter
    def conversation_disconnect(self, conversation_disconnect: 'ConversationDisconnectSettings') -> None:
        """
        Sets the conversation_disconnect of this ConversationAppSettings.
        The conversation disconnect settings for the messenger app

        :param conversation_disconnect: The conversation_disconnect of this ConversationAppSettings.
        :type: ConversationDisconnectSettings
        """
        

        self._conversation_disconnect = conversation_disconnect

    @property
    def conversation_clear(self) -> 'ConversationClearSettings':
        """
        Gets the conversation_clear of this ConversationAppSettings.
        The conversation clear settings for the messenger app

        :return: The conversation_clear of this ConversationAppSettings.
        :rtype: ConversationClearSettings
        """
        return self._conversation_clear

    @conversation_clear.setter
    def conversation_clear(self, conversation_clear: 'ConversationClearSettings') -> None:
        """
        Sets the conversation_clear of this ConversationAppSettings.
        The conversation clear settings for the messenger app

        :param conversation_clear: The conversation_clear of this ConversationAppSettings.
        :type: ConversationClearSettings
        """
        

        self._conversation_clear = conversation_clear

    @property
    def humanize(self) -> 'Humanize':
        """
        Gets the humanize of this ConversationAppSettings.
        The humanize conversations settings for the messenger app

        :return: The humanize of this ConversationAppSettings.
        :rtype: Humanize
        """
        return self._humanize

    @humanize.setter
    def humanize(self, humanize: 'Humanize') -> None:
        """
        Sets the humanize of this ConversationAppSettings.
        The humanize conversations settings for the messenger app

        :param humanize: The humanize of this ConversationAppSettings.
        :type: Humanize
        """
        

        self._humanize = humanize

    @property
    def notifications(self) -> 'NotificationsSettings':
        """
        Gets the notifications of this ConversationAppSettings.
        The notification settings for messenger apps

        :return: The notifications of this ConversationAppSettings.
        :rtype: NotificationsSettings
        """
        return self._notifications

    @notifications.setter
    def notifications(self, notifications: 'NotificationsSettings') -> None:
        """
        Sets the notifications of this ConversationAppSettings.
        The notification settings for messenger apps

        :param notifications: The notifications of this ConversationAppSettings.
        :type: NotificationsSettings
        """
        

        self._notifications = notifications

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

