# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ConversationActivityEntityData
    from . import ConversationActivityMetricValue

class ConversationActivityData(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ConversationActivityData - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'group': 'dict(str, str)',
            'data': 'list[ConversationActivityMetricValue]',
            'truncated': 'bool',
            'entities': 'list[ConversationActivityEntityData]'
        }

        self.attribute_map = {
            'group': 'group',
            'data': 'data',
            'truncated': 'truncated',
            'entities': 'entities'
        }

        self._group = None
        self._data = None
        self._truncated = None
        self._entities = None

    @property
    def group(self) -> Dict[str, str]:
        """
        Gets the group of this ConversationActivityData.
        A mapping from grouping dimension to value

        :return: The group of this ConversationActivityData.
        :rtype: dict(str, str)
        """
        return self._group

    @group.setter
    def group(self, group: Dict[str, str]) -> None:
        """
        Sets the group of this ConversationActivityData.
        A mapping from grouping dimension to value

        :param group: The group of this ConversationActivityData.
        :type: dict(str, str)
        """
        

        self._group = group

    @property
    def data(self) -> List['ConversationActivityMetricValue']:
        """
        Gets the data of this ConversationActivityData.
        Data for metrics

        :return: The data of this ConversationActivityData.
        :rtype: list[ConversationActivityMetricValue]
        """
        return self._data

    @data.setter
    def data(self, data: List['ConversationActivityMetricValue']) -> None:
        """
        Sets the data of this ConversationActivityData.
        Data for metrics

        :param data: The data of this ConversationActivityData.
        :type: list[ConversationActivityMetricValue]
        """
        

        self._data = data

    @property
    def truncated(self) -> bool:
        """
        Gets the truncated of this ConversationActivityData.
        Flag for a truncated list of entities. If truncated, the first half of the list of entities will contain the oldest entities and the second half the newest entities.

        :return: The truncated of this ConversationActivityData.
        :rtype: bool
        """
        return self._truncated

    @truncated.setter
    def truncated(self, truncated: bool) -> None:
        """
        Sets the truncated of this ConversationActivityData.
        Flag for a truncated list of entities. If truncated, the first half of the list of entities will contain the oldest entities and the second half the newest entities.

        :param truncated: The truncated of this ConversationActivityData.
        :type: bool
        """
        

        self._truncated = truncated

    @property
    def entities(self) -> List['ConversationActivityEntityData']:
        """
        Gets the entities of this ConversationActivityData.
        Details for active entities

        :return: The entities of this ConversationActivityData.
        :rtype: list[ConversationActivityEntityData]
        """
        return self._entities

    @entities.setter
    def entities(self, entities: List['ConversationActivityEntityData']) -> None:
        """
        Sets the entities of this ConversationActivityData.
        Details for active entities

        :param entities: The entities of this ConversationActivityData.
        :type: list[ConversationActivityEntityData]
        """
        

        self._entities = entities

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

