# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ContestDisqualifiedAgents
    from . import ContestWinnersRequest

class ContestsFinalizeRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ContestsFinalizeRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'status': 'str',
            'winners': 'list[ContestWinnersRequest]',
            'disqualified_agents': 'list[ContestDisqualifiedAgents]'
        }

        self.attribute_map = {
            'status': 'status',
            'winners': 'winners',
            'disqualified_agents': 'disqualifiedAgents'
        }

        self._status = None
        self._winners = None
        self._disqualified_agents = None

    @property
    def status(self) -> str:
        """
        Gets the status of this ContestsFinalizeRequest.
        The Contest finalization status

        :return: The status of this ContestsFinalizeRequest.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this ContestsFinalizeRequest.
        The Contest finalization status

        :param status: The status of this ContestsFinalizeRequest.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Completed", "Cancelled"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def winners(self) -> List['ContestWinnersRequest']:
        """
        Gets the winners of this ContestsFinalizeRequest.
        The Contest finalization winners

        :return: The winners of this ContestsFinalizeRequest.
        :rtype: list[ContestWinnersRequest]
        """
        return self._winners

    @winners.setter
    def winners(self, winners: List['ContestWinnersRequest']) -> None:
        """
        Sets the winners of this ContestsFinalizeRequest.
        The Contest finalization winners

        :param winners: The winners of this ContestsFinalizeRequest.
        :type: list[ContestWinnersRequest]
        """
        

        self._winners = winners

    @property
    def disqualified_agents(self) -> List['ContestDisqualifiedAgents']:
        """
        Gets the disqualified_agents of this ContestsFinalizeRequest.
        The Contest finalization disqualified agents

        :return: The disqualified_agents of this ContestsFinalizeRequest.
        :rtype: list[ContestDisqualifiedAgents]
        """
        return self._disqualified_agents

    @disqualified_agents.setter
    def disqualified_agents(self, disqualified_agents: List['ContestDisqualifiedAgents']) -> None:
        """
        Sets the disqualified_agents of this ContestsFinalizeRequest.
        The Contest finalization disqualified agents

        :param disqualified_agents: The disqualified_agents of this ContestsFinalizeRequest.
        :type: list[ContestDisqualifiedAgents]
        """
        

        self._disqualified_agents = disqualified_agents

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

