# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ContestMetricScore
    from . import ContestScore

class ContestScoresGroupTrend(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ContestScoresGroupTrend - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'date_workday': 'date',
            'contest_score': 'ContestScore',
            'metric_scores': 'list[ContestMetricScore]'
        }

        self.attribute_map = {
            'date_workday': 'dateWorkday',
            'contest_score': 'contestScore',
            'metric_scores': 'metricScores'
        }

        self._date_workday = None
        self._contest_score = None
        self._metric_scores = None

    @property
    def date_workday(self) -> date:
        """
        Gets the date_workday of this ContestScoresGroupTrend.
        Workday of the contest score. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_workday of this ContestScoresGroupTrend.
        :rtype: date
        """
        return self._date_workday

    @date_workday.setter
    def date_workday(self, date_workday: date) -> None:
        """
        Sets the date_workday of this ContestScoresGroupTrend.
        Workday of the contest score. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_workday: The date_workday of this ContestScoresGroupTrend.
        :type: date
        """
        

        self._date_workday = date_workday

    @property
    def contest_score(self) -> 'ContestScore':
        """
        Gets the contest_score of this ContestScoresGroupTrend.
        The Contest score

        :return: The contest_score of this ContestScoresGroupTrend.
        :rtype: ContestScore
        """
        return self._contest_score

    @contest_score.setter
    def contest_score(self, contest_score: 'ContestScore') -> None:
        """
        Sets the contest_score of this ContestScoresGroupTrend.
        The Contest score

        :param contest_score: The contest_score of this ContestScoresGroupTrend.
        :type: ContestScore
        """
        

        self._contest_score = contest_score

    @property
    def metric_scores(self) -> List['ContestMetricScore']:
        """
        Gets the metric_scores of this ContestScoresGroupTrend.
        The Contest metric scores

        :return: The metric_scores of this ContestScoresGroupTrend.
        :rtype: list[ContestMetricScore]
        """
        return self._metric_scores

    @metric_scores.setter
    def metric_scores(self, metric_scores: List['ContestMetricScore']) -> None:
        """
        Sets the metric_scores of this ContestScoresGroupTrend.
        The Contest metric scores

        :param metric_scores: The metric_scores of this ContestScoresGroupTrend.
        :type: list[ContestMetricScore]
        """
        

        self._metric_scores = metric_scores

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

