# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ContestCompleteDataScore
    from . import ContestDataWinnersUsers

class ContestDataWinners(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ContestDataWinners - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'tier': 'int',
            'winners_count': 'int',
            'contest_score': 'ContestCompleteDataScore',
            'users': 'list[ContestDataWinnersUsers]'
        }

        self.attribute_map = {
            'tier': 'tier',
            'winners_count': 'winnersCount',
            'contest_score': 'contestScore',
            'users': 'users'
        }

        self._tier = None
        self._winners_count = None
        self._contest_score = None
        self._users = None

    @property
    def tier(self) -> int:
        """
        Gets the tier of this ContestDataWinners.
        Tier of the winners

        :return: The tier of this ContestDataWinners.
        :rtype: int
        """
        return self._tier

    @tier.setter
    def tier(self, tier: int) -> None:
        """
        Sets the tier of this ContestDataWinners.
        Tier of the winners

        :param tier: The tier of this ContestDataWinners.
        :type: int
        """
        

        self._tier = tier

    @property
    def winners_count(self) -> int:
        """
        Gets the winners_count of this ContestDataWinners.
        Number of winners in this tier

        :return: The winners_count of this ContestDataWinners.
        :rtype: int
        """
        return self._winners_count

    @winners_count.setter
    def winners_count(self, winners_count: int) -> None:
        """
        Sets the winners_count of this ContestDataWinners.
        Number of winners in this tier

        :param winners_count: The winners_count of this ContestDataWinners.
        :type: int
        """
        

        self._winners_count = winners_count

    @property
    def contest_score(self) -> 'ContestCompleteDataScore':
        """
        Gets the contest_score of this ContestDataWinners.
        Number of winners in this tier

        :return: The contest_score of this ContestDataWinners.
        :rtype: ContestCompleteDataScore
        """
        return self._contest_score

    @contest_score.setter
    def contest_score(self, contest_score: 'ContestCompleteDataScore') -> None:
        """
        Sets the contest_score of this ContestDataWinners.
        Number of winners in this tier

        :param contest_score: The contest_score of this ContestDataWinners.
        :type: ContestCompleteDataScore
        """
        

        self._contest_score = contest_score

    @property
    def users(self) -> List['ContestDataWinnersUsers']:
        """
        Gets the users of this ContestDataWinners.
        List of users in this tier

        :return: The users of this ContestDataWinners.
        :rtype: list[ContestDataWinnersUsers]
        """
        return self._users

    @users.setter
    def users(self, users: List['ContestDataWinnersUsers']) -> None:
        """
        Sets the users of this ContestDataWinners.
        List of users in this tier

        :param users: The users of this ContestDataWinners.
        :type: list[ContestDataWinnersUsers]
        """
        

        self._users = users

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

