# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class ContentFileResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ContentFileResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'type': 'str',
            'checksum': 'str',
            'size': 'int',
            'content_url': 'str'
        }

        self.attribute_map = {
            'name': 'name',
            'type': 'type',
            'checksum': 'checksum',
            'size': 'size',
            'content_url': 'contentUrl'
        }

        self._name = None
        self._type = None
        self._checksum = None
        self._size = None
        self._content_url = None

    @property
    def name(self) -> str:
        """
        Gets the name of this ContentFileResponse.
        The name of the file

        :return: The name of this ContentFileResponse.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this ContentFileResponse.
        The name of the file

        :param name: The name of this ContentFileResponse.
        :type: str
        """
        

        self._name = name

    @property
    def type(self) -> str:
        """
        Gets the type of this ContentFileResponse.
        The file format

        :return: The type of this ContentFileResponse.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this ContentFileResponse.
        The file format

        :param type: The type of this ContentFileResponse.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["Pdf", "Docx", "Doc"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def checksum(self) -> str:
        """
        Gets the checksum of this ContentFileResponse.
        The checksum of the file

        :return: The checksum of this ContentFileResponse.
        :rtype: str
        """
        return self._checksum

    @checksum.setter
    def checksum(self, checksum: str) -> None:
        """
        Sets the checksum of this ContentFileResponse.
        The checksum of the file

        :param checksum: The checksum of this ContentFileResponse.
        :type: str
        """
        

        self._checksum = checksum

    @property
    def size(self) -> int:
        """
        Gets the size of this ContentFileResponse.
        The size of the file in bytes

        :return: The size of this ContentFileResponse.
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size: int) -> None:
        """
        Sets the size of this ContentFileResponse.
        The size of the file in bytes

        :param size: The size of this ContentFileResponse.
        :type: int
        """
        

        self._size = size

    @property
    def content_url(self) -> str:
        """
        Gets the content_url of this ContentFileResponse.
        Public download url for content. Needs to be expanded

        :return: The content_url of this ContentFileResponse.
        :rtype: str
        """
        return self._content_url

    @content_url.setter
    def content_url(self, content_url: str) -> None:
        """
        Sets the content_url of this ContentFileResponse.
        Public download url for content. Needs to be expanded

        :param content_url: The content_url of this ContentFileResponse.
        :type: str
        """
        

        self._content_url = content_url

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

