# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ContactsExportFieldFilter
    from . import ContactsExportFieldListFilter

class ContactsExportFilter(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ContactsExportFilter - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'eq': 'ContactsExportFieldFilter',
            'pcIn': 'ContactsExportFieldListFilter',
            'pcAnd': 'list[ContactsExportFilter]',
            'pcOr': 'list[ContactsExportFilter]',
            'pcNot': 'ContactsExportFilter'
        }

        self.attribute_map = {
            'eq': 'eq',
            'pcIn': 'in',
            'pcAnd': 'and',
            'pcOr': 'or',
            'pcNot': 'not'
        }

        self._eq = None
        self._pcIn = None
        self._pcAnd = None
        self._pcOr = None
        self._pcNot = None

    @property
    def eq(self) -> 'ContactsExportFieldFilter':
        """
        Gets the eq of this ContactsExportFilter.
        Filtered field should have the same value

        :return: The eq of this ContactsExportFilter.
        :rtype: ContactsExportFieldFilter
        """
        return self._eq

    @eq.setter
    def eq(self, eq: 'ContactsExportFieldFilter') -> None:
        """
        Sets the eq of this ContactsExportFilter.
        Filtered field should have the same value

        :param eq: The eq of this ContactsExportFilter.
        :type: ContactsExportFieldFilter
        """
        

        self._eq = eq

    @property
    def pcIn(self) -> 'ContactsExportFieldListFilter':
        """
        Gets the pcIn of this ContactsExportFilter.
        Filtered field should match one of the listed values

        :return: The pcIn of this ContactsExportFilter.
        :rtype: ContactsExportFieldListFilter
        """
        return self._pcIn

    @pcIn.setter
    def pcIn(self, pcIn: 'ContactsExportFieldListFilter') -> None:
        """
        Sets the pcIn of this ContactsExportFilter.
        Filtered field should match one of the listed values

        :param pcIn: The pcIn of this ContactsExportFilter.
        :type: ContactsExportFieldListFilter
        """
        

        self._pcIn = pcIn

    @property
    def pcAnd(self) -> List['ContactsExportFilter']:
        """
        Gets the pcAnd of this ContactsExportFilter.
        Boolean AND combination of filters

        :return: The pcAnd of this ContactsExportFilter.
        :rtype: list[ContactsExportFilter]
        """
        return self._pcAnd

    @pcAnd.setter
    def pcAnd(self, pcAnd: List['ContactsExportFilter']) -> None:
        """
        Sets the pcAnd of this ContactsExportFilter.
        Boolean AND combination of filters

        :param pcAnd: The pcAnd of this ContactsExportFilter.
        :type: list[ContactsExportFilter]
        """
        

        self._pcAnd = pcAnd

    @property
    def pcOr(self) -> List['ContactsExportFilter']:
        """
        Gets the pcOr of this ContactsExportFilter.
        Boolean OR combination of filters

        :return: The pcOr of this ContactsExportFilter.
        :rtype: list[ContactsExportFilter]
        """
        return self._pcOr

    @pcOr.setter
    def pcOr(self, pcOr: List['ContactsExportFilter']) -> None:
        """
        Sets the pcOr of this ContactsExportFilter.
        Boolean OR combination of filters

        :param pcOr: The pcOr of this ContactsExportFilter.
        :type: list[ContactsExportFilter]
        """
        

        self._pcOr = pcOr

    @property
    def pcNot(self) -> 'ContactsExportFilter':
        """
        Gets the pcNot of this ContactsExportFilter.
        Boolean negation of filters

        :return: The pcNot of this ContactsExportFilter.
        :rtype: ContactsExportFilter
        """
        return self._pcNot

    @pcNot.setter
    def pcNot(self, pcNot: 'ContactsExportFilter') -> None:
        """
        Sets the pcNot of this ContactsExportFilter.
        Boolean negation of filters

        :param pcNot: The pcNot of this ContactsExportFilter.
        :type: ContactsExportFilter
        """
        

        self._pcNot = pcNot

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

