# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ContactBulkSearchCriteria
    from . import ContactSort

class ContactListingRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ContactListingRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'contact_list_filter_id': 'str',
            'criteria': 'ContactBulkSearchCriteria',
            'page_number': 'int',
            'page_size': 'int',
            'contact_sorts': 'list[ContactSort]'
        }

        self.attribute_map = {
            'contact_list_filter_id': 'contactListFilterId',
            'criteria': 'criteria',
            'page_number': 'pageNumber',
            'page_size': 'pageSize',
            'contact_sorts': 'contactSorts'
        }

        self._contact_list_filter_id = None
        self._criteria = None
        self._page_number = None
        self._page_size = None
        self._contact_sorts = None

    @property
    def contact_list_filter_id(self) -> str:
        """
        Gets the contact_list_filter_id of this ContactListingRequest.
        Contact List Filter ID.

        :return: The contact_list_filter_id of this ContactListingRequest.
        :rtype: str
        """
        return self._contact_list_filter_id

    @contact_list_filter_id.setter
    def contact_list_filter_id(self, contact_list_filter_id: str) -> None:
        """
        Sets the contact_list_filter_id of this ContactListingRequest.
        Contact List Filter ID.

        :param contact_list_filter_id: The contact_list_filter_id of this ContactListingRequest.
        :type: str
        """
        

        self._contact_list_filter_id = contact_list_filter_id

    @property
    def criteria(self) -> 'ContactBulkSearchCriteria':
        """
        Gets the criteria of this ContactListingRequest.
        Criteria to filter the contacts by.

        :return: The criteria of this ContactListingRequest.
        :rtype: ContactBulkSearchCriteria
        """
        return self._criteria

    @criteria.setter
    def criteria(self, criteria: 'ContactBulkSearchCriteria') -> None:
        """
        Sets the criteria of this ContactListingRequest.
        Criteria to filter the contacts by.

        :param criteria: The criteria of this ContactListingRequest.
        :type: ContactBulkSearchCriteria
        """
        

        self._criteria = criteria

    @property
    def page_number(self) -> int:
        """
        Gets the page_number of this ContactListingRequest.
        Page number.

        :return: The page_number of this ContactListingRequest.
        :rtype: int
        """
        return self._page_number

    @page_number.setter
    def page_number(self, page_number: int) -> None:
        """
        Sets the page_number of this ContactListingRequest.
        Page number.

        :param page_number: The page_number of this ContactListingRequest.
        :type: int
        """
        

        self._page_number = page_number

    @property
    def page_size(self) -> int:
        """
        Gets the page_size of this ContactListingRequest.
        Page size. The max that will be returned is 100.

        :return: The page_size of this ContactListingRequest.
        :rtype: int
        """
        return self._page_size

    @page_size.setter
    def page_size(self, page_size: int) -> None:
        """
        Sets the page_size of this ContactListingRequest.
        Page size. The max that will be returned is 100.

        :param page_size: The page_size of this ContactListingRequest.
        :type: int
        """
        

        self._page_size = page_size

    @property
    def contact_sorts(self) -> List['ContactSort']:
        """
        Gets the contact_sorts of this ContactListingRequest.
        The order in which to sort contacts.

        :return: The contact_sorts of this ContactListingRequest.
        :rtype: list[ContactSort]
        """
        return self._contact_sorts

    @contact_sorts.setter
    def contact_sorts(self, contact_sorts: List['ContactSort']) -> None:
        """
        Sets the contact_sorts of this ContactListingRequest.
        The order in which to sort contacts.

        :param contact_sorts: The contact_sorts of this ContactListingRequest.
        :type: list[ContactSort]
        """
        

        self._contact_sorts = contact_sorts

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

