# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ColumnDataTypeSpecification
    from . import ContactPhoneNumberColumn
    from . import DomainEntityRef
    from . import EmailColumn
    from . import WhatsAppColumn

class ContactListTemplate(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ContactListTemplate - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'version': 'int',
            'column_names': 'list[str]',
            'phone_columns': 'list[ContactPhoneNumberColumn]',
            'email_columns': 'list[EmailColumn]',
            'whats_app_columns': 'list[WhatsAppColumn]',
            'preview_mode_column_name': 'str',
            'preview_mode_accepted_values': 'list[str]',
            'attempt_limits': 'DomainEntityRef',
            'automatic_time_zone_mapping': 'bool',
            'zip_code_column_name': 'str',
            'column_data_type_specifications': 'list[ColumnDataTypeSpecification]',
            'trim_whitespace': 'bool',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'version': 'version',
            'column_names': 'columnNames',
            'phone_columns': 'phoneColumns',
            'email_columns': 'emailColumns',
            'whats_app_columns': 'whatsAppColumns',
            'preview_mode_column_name': 'previewModeColumnName',
            'preview_mode_accepted_values': 'previewModeAcceptedValues',
            'attempt_limits': 'attemptLimits',
            'automatic_time_zone_mapping': 'automaticTimeZoneMapping',
            'zip_code_column_name': 'zipCodeColumnName',
            'column_data_type_specifications': 'columnDataTypeSpecifications',
            'trim_whitespace': 'trimWhitespace',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._date_created = None
        self._date_modified = None
        self._version = None
        self._column_names = None
        self._phone_columns = None
        self._email_columns = None
        self._whats_app_columns = None
        self._preview_mode_column_name = None
        self._preview_mode_accepted_values = None
        self._attempt_limits = None
        self._automatic_time_zone_mapping = None
        self._zip_code_column_name = None
        self._column_data_type_specifications = None
        self._trim_whitespace = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this ContactListTemplate.
        The globally unique identifier for the object.

        :return: The id of this ContactListTemplate.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ContactListTemplate.
        The globally unique identifier for the object.

        :param id: The id of this ContactListTemplate.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this ContactListTemplate.


        :return: The name of this ContactListTemplate.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this ContactListTemplate.


        :param name: The name of this ContactListTemplate.
        :type: str
        """
        

        self._name = name

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this ContactListTemplate.
        Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this ContactListTemplate.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this ContactListTemplate.
        Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this ContactListTemplate.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this ContactListTemplate.
        Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this ContactListTemplate.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this ContactListTemplate.
        Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this ContactListTemplate.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def version(self) -> int:
        """
        Gets the version of this ContactListTemplate.
        Required for updates, must match the version number of the most recent update

        :return: The version of this ContactListTemplate.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version: int) -> None:
        """
        Sets the version of this ContactListTemplate.
        Required for updates, must match the version number of the most recent update

        :param version: The version of this ContactListTemplate.
        :type: int
        """
        

        self._version = version

    @property
    def column_names(self) -> List[str]:
        """
        Gets the column_names of this ContactListTemplate.
        The names of the contact data columns.

        :return: The column_names of this ContactListTemplate.
        :rtype: list[str]
        """
        return self._column_names

    @column_names.setter
    def column_names(self, column_names: List[str]) -> None:
        """
        Sets the column_names of this ContactListTemplate.
        The names of the contact data columns.

        :param column_names: The column_names of this ContactListTemplate.
        :type: list[str]
        """
        

        self._column_names = column_names

    @property
    def phone_columns(self) -> List['ContactPhoneNumberColumn']:
        """
        Gets the phone_columns of this ContactListTemplate.
        Indicates which columns are phone numbers.

        :return: The phone_columns of this ContactListTemplate.
        :rtype: list[ContactPhoneNumberColumn]
        """
        return self._phone_columns

    @phone_columns.setter
    def phone_columns(self, phone_columns: List['ContactPhoneNumberColumn']) -> None:
        """
        Sets the phone_columns of this ContactListTemplate.
        Indicates which columns are phone numbers.

        :param phone_columns: The phone_columns of this ContactListTemplate.
        :type: list[ContactPhoneNumberColumn]
        """
        

        self._phone_columns = phone_columns

    @property
    def email_columns(self) -> List['EmailColumn']:
        """
        Gets the email_columns of this ContactListTemplate.
        Indicates which columns are email addresses

        :return: The email_columns of this ContactListTemplate.
        :rtype: list[EmailColumn]
        """
        return self._email_columns

    @email_columns.setter
    def email_columns(self, email_columns: List['EmailColumn']) -> None:
        """
        Sets the email_columns of this ContactListTemplate.
        Indicates which columns are email addresses

        :param email_columns: The email_columns of this ContactListTemplate.
        :type: list[EmailColumn]
        """
        

        self._email_columns = email_columns

    @property
    def whats_app_columns(self) -> List['WhatsAppColumn']:
        """
        Gets the whats_app_columns of this ContactListTemplate.
        Indicates which columns are whatsApp contacts

        :return: The whats_app_columns of this ContactListTemplate.
        :rtype: list[WhatsAppColumn]
        """
        return self._whats_app_columns

    @whats_app_columns.setter
    def whats_app_columns(self, whats_app_columns: List['WhatsAppColumn']) -> None:
        """
        Sets the whats_app_columns of this ContactListTemplate.
        Indicates which columns are whatsApp contacts

        :param whats_app_columns: The whats_app_columns of this ContactListTemplate.
        :type: list[WhatsAppColumn]
        """
        

        self._whats_app_columns = whats_app_columns

    @property
    def preview_mode_column_name(self) -> str:
        """
        Gets the preview_mode_column_name of this ContactListTemplate.
        A column to check if a contact should always be dialed in preview mode.

        :return: The preview_mode_column_name of this ContactListTemplate.
        :rtype: str
        """
        return self._preview_mode_column_name

    @preview_mode_column_name.setter
    def preview_mode_column_name(self, preview_mode_column_name: str) -> None:
        """
        Sets the preview_mode_column_name of this ContactListTemplate.
        A column to check if a contact should always be dialed in preview mode.

        :param preview_mode_column_name: The preview_mode_column_name of this ContactListTemplate.
        :type: str
        """
        

        self._preview_mode_column_name = preview_mode_column_name

    @property
    def preview_mode_accepted_values(self) -> List[str]:
        """
        Gets the preview_mode_accepted_values of this ContactListTemplate.
        The values in the previewModeColumnName column that indicate a contact should always be dialed in preview mode.

        :return: The preview_mode_accepted_values of this ContactListTemplate.
        :rtype: list[str]
        """
        return self._preview_mode_accepted_values

    @preview_mode_accepted_values.setter
    def preview_mode_accepted_values(self, preview_mode_accepted_values: List[str]) -> None:
        """
        Sets the preview_mode_accepted_values of this ContactListTemplate.
        The values in the previewModeColumnName column that indicate a contact should always be dialed in preview mode.

        :param preview_mode_accepted_values: The preview_mode_accepted_values of this ContactListTemplate.
        :type: list[str]
        """
        

        self._preview_mode_accepted_values = preview_mode_accepted_values

    @property
    def attempt_limits(self) -> 'DomainEntityRef':
        """
        Gets the attempt_limits of this ContactListTemplate.
        AttemptLimits for this ContactListTemplate.

        :return: The attempt_limits of this ContactListTemplate.
        :rtype: DomainEntityRef
        """
        return self._attempt_limits

    @attempt_limits.setter
    def attempt_limits(self, attempt_limits: 'DomainEntityRef') -> None:
        """
        Sets the attempt_limits of this ContactListTemplate.
        AttemptLimits for this ContactListTemplate.

        :param attempt_limits: The attempt_limits of this ContactListTemplate.
        :type: DomainEntityRef
        """
        

        self._attempt_limits = attempt_limits

    @property
    def automatic_time_zone_mapping(self) -> bool:
        """
        Gets the automatic_time_zone_mapping of this ContactListTemplate.
        Indicates if automatic time zone mapping is to be used for this ContactListTemplate.

        :return: The automatic_time_zone_mapping of this ContactListTemplate.
        :rtype: bool
        """
        return self._automatic_time_zone_mapping

    @automatic_time_zone_mapping.setter
    def automatic_time_zone_mapping(self, automatic_time_zone_mapping: bool) -> None:
        """
        Sets the automatic_time_zone_mapping of this ContactListTemplate.
        Indicates if automatic time zone mapping is to be used for this ContactListTemplate.

        :param automatic_time_zone_mapping: The automatic_time_zone_mapping of this ContactListTemplate.
        :type: bool
        """
        

        self._automatic_time_zone_mapping = automatic_time_zone_mapping

    @property
    def zip_code_column_name(self) -> str:
        """
        Gets the zip_code_column_name of this ContactListTemplate.
        The name of ContactListTemplate column containing the zip code for use with automatic time zone mapping. Only allowed if 'automaticTimeZoneMapping' is set to true.

        :return: The zip_code_column_name of this ContactListTemplate.
        :rtype: str
        """
        return self._zip_code_column_name

    @zip_code_column_name.setter
    def zip_code_column_name(self, zip_code_column_name: str) -> None:
        """
        Sets the zip_code_column_name of this ContactListTemplate.
        The name of ContactListTemplate column containing the zip code for use with automatic time zone mapping. Only allowed if 'automaticTimeZoneMapping' is set to true.

        :param zip_code_column_name: The zip_code_column_name of this ContactListTemplate.
        :type: str
        """
        

        self._zip_code_column_name = zip_code_column_name

    @property
    def column_data_type_specifications(self) -> List['ColumnDataTypeSpecification']:
        """
        Gets the column_data_type_specifications of this ContactListTemplate.
        The settings of the columns selected for dynamic queueing

        :return: The column_data_type_specifications of this ContactListTemplate.
        :rtype: list[ColumnDataTypeSpecification]
        """
        return self._column_data_type_specifications

    @column_data_type_specifications.setter
    def column_data_type_specifications(self, column_data_type_specifications: List['ColumnDataTypeSpecification']) -> None:
        """
        Sets the column_data_type_specifications of this ContactListTemplate.
        The settings of the columns selected for dynamic queueing

        :param column_data_type_specifications: The column_data_type_specifications of this ContactListTemplate.
        :type: list[ColumnDataTypeSpecification]
        """
        

        self._column_data_type_specifications = column_data_type_specifications

    @property
    def trim_whitespace(self) -> bool:
        """
        Gets the trim_whitespace of this ContactListTemplate.
        Whether to trim white space when importing a ContactListTemplate csv file, default value = true

        :return: The trim_whitespace of this ContactListTemplate.
        :rtype: bool
        """
        return self._trim_whitespace

    @trim_whitespace.setter
    def trim_whitespace(self, trim_whitespace: bool) -> None:
        """
        Sets the trim_whitespace of this ContactListTemplate.
        Whether to trim white space when importing a ContactListTemplate csv file, default value = true

        :param trim_whitespace: The trim_whitespace of this ContactListTemplate.
        :type: bool
        """
        

        self._trim_whitespace = trim_whitespace

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this ContactListTemplate.
        The URI for this object

        :return: The self_uri of this ContactListTemplate.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this ContactListTemplate.
        The URI for this object

        :param self_uri: The self_uri of this ContactListTemplate.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

