# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ContactListFilterClause
    from . import DomainEntityRef

class ContactListFilter(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ContactListFilter - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'version': 'int',
            'contact_list': 'DomainEntityRef',
            'contact_list_template': 'DomainEntityRef',
            'source_type': 'str',
            'clauses': 'list[ContactListFilterClause]',
            'filter_type': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'version': 'version',
            'contact_list': 'contactList',
            'contact_list_template': 'contactListTemplate',
            'source_type': 'sourceType',
            'clauses': 'clauses',
            'filter_type': 'filterType',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._date_created = None
        self._date_modified = None
        self._version = None
        self._contact_list = None
        self._contact_list_template = None
        self._source_type = None
        self._clauses = None
        self._filter_type = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this ContactListFilter.
        The globally unique identifier for the object.

        :return: The id of this ContactListFilter.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ContactListFilter.
        The globally unique identifier for the object.

        :param id: The id of this ContactListFilter.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this ContactListFilter.
        The name of the list.

        :return: The name of this ContactListFilter.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this ContactListFilter.
        The name of the list.

        :param name: The name of this ContactListFilter.
        :type: str
        """
        

        self._name = name

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this ContactListFilter.
        Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this ContactListFilter.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this ContactListFilter.
        Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this ContactListFilter.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this ContactListFilter.
        Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this ContactListFilter.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this ContactListFilter.
        Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this ContactListFilter.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def version(self) -> int:
        """
        Gets the version of this ContactListFilter.
        Required for updates, must match the version number of the most recent update

        :return: The version of this ContactListFilter.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version: int) -> None:
        """
        Sets the version of this ContactListFilter.
        Required for updates, must match the version number of the most recent update

        :param version: The version of this ContactListFilter.
        :type: int
        """
        

        self._version = version

    @property
    def contact_list(self) -> 'DomainEntityRef':
        """
        Gets the contact_list of this ContactListFilter.
        The contact list the filter is based on. Required if sourceType is ContactList

        :return: The contact_list of this ContactListFilter.
        :rtype: DomainEntityRef
        """
        return self._contact_list

    @contact_list.setter
    def contact_list(self, contact_list: 'DomainEntityRef') -> None:
        """
        Sets the contact_list of this ContactListFilter.
        The contact list the filter is based on. Required if sourceType is ContactList

        :param contact_list: The contact_list of this ContactListFilter.
        :type: DomainEntityRef
        """
        

        self._contact_list = contact_list

    @property
    def contact_list_template(self) -> 'DomainEntityRef':
        """
        Gets the contact_list_template of this ContactListFilter.
        The contact list template the filter is based on. Required if sourceType is ContactListTemplate

        :return: The contact_list_template of this ContactListFilter.
        :rtype: DomainEntityRef
        """
        return self._contact_list_template

    @contact_list_template.setter
    def contact_list_template(self, contact_list_template: 'DomainEntityRef') -> None:
        """
        Sets the contact_list_template of this ContactListFilter.
        The contact list template the filter is based on. Required if sourceType is ContactListTemplate

        :param contact_list_template: The contact_list_template of this ContactListFilter.
        :type: DomainEntityRef
        """
        

        self._contact_list_template = contact_list_template

    @property
    def source_type(self) -> str:
        """
        Gets the source_type of this ContactListFilter.
        The source type the filter is based on.

        :return: The source_type of this ContactListFilter.
        :rtype: str
        """
        return self._source_type

    @source_type.setter
    def source_type(self, source_type: str) -> None:
        """
        Sets the source_type of this ContactListFilter.
        The source type the filter is based on.

        :param source_type: The source_type of this ContactListFilter.
        :type: str
        """
        if isinstance(source_type, int):
            source_type = str(source_type)
        allowed_values = ["ContactList", "ContactListTemplate"]
        if source_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for source_type -> " + source_type)
            self._source_type = "outdated_sdk_version"
        else:
            self._source_type = source_type

    @property
    def clauses(self) -> List['ContactListFilterClause']:
        """
        Gets the clauses of this ContactListFilter.
        Groups of conditions to filter the contacts by.

        :return: The clauses of this ContactListFilter.
        :rtype: list[ContactListFilterClause]
        """
        return self._clauses

    @clauses.setter
    def clauses(self, clauses: List['ContactListFilterClause']) -> None:
        """
        Sets the clauses of this ContactListFilter.
        Groups of conditions to filter the contacts by.

        :param clauses: The clauses of this ContactListFilter.
        :type: list[ContactListFilterClause]
        """
        

        self._clauses = clauses

    @property
    def filter_type(self) -> str:
        """
        Gets the filter_type of this ContactListFilter.
        How to join clauses together.

        :return: The filter_type of this ContactListFilter.
        :rtype: str
        """
        return self._filter_type

    @filter_type.setter
    def filter_type(self, filter_type: str) -> None:
        """
        Sets the filter_type of this ContactListFilter.
        How to join clauses together.

        :param filter_type: The filter_type of this ContactListFilter.
        :type: str
        """
        if isinstance(filter_type, int):
            filter_type = str(filter_type)
        allowed_values = ["AND", "OR"]
        if filter_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for filter_type -> " + filter_type)
            self._filter_type = "outdated_sdk_version"
        else:
            self._filter_type = filter_type

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this ContactListFilter.
        The URI for this object

        :return: The self_uri of this ContactListFilter.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this ContactListFilter.
        The URI for this object

        :param self_uri: The self_uri of this ContactListFilter.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

