# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class ContactImportJobMetadata(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ContactImportJobMetadata - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'file_name': 'str',
            'dry_run_failed_count': 'int',
            'dry_run_success_count': 'int',
            'dry_run_report_download_url': 'str',
            'import_failed_count': 'int',
            'import_success_count': 'int',
            'import_report_download_url': 'str'
        }

        self.attribute_map = {
            'file_name': 'fileName',
            'dry_run_failed_count': 'dryRunFailedCount',
            'dry_run_success_count': 'dryRunSuccessCount',
            'dry_run_report_download_url': 'dryRunReportDownloadUrl',
            'import_failed_count': 'importFailedCount',
            'import_success_count': 'importSuccessCount',
            'import_report_download_url': 'importReportDownloadUrl'
        }

        self._file_name = None
        self._dry_run_failed_count = None
        self._dry_run_success_count = None
        self._dry_run_report_download_url = None
        self._import_failed_count = None
        self._import_success_count = None
        self._import_report_download_url = None

    @property
    def file_name(self) -> str:
        """
        Gets the file_name of this ContactImportJobMetadata.


        :return: The file_name of this ContactImportJobMetadata.
        :rtype: str
        """
        return self._file_name

    @file_name.setter
    def file_name(self, file_name: str) -> None:
        """
        Sets the file_name of this ContactImportJobMetadata.


        :param file_name: The file_name of this ContactImportJobMetadata.
        :type: str
        """
        

        self._file_name = file_name

    @property
    def dry_run_failed_count(self) -> int:
        """
        Gets the dry_run_failed_count of this ContactImportJobMetadata.


        :return: The dry_run_failed_count of this ContactImportJobMetadata.
        :rtype: int
        """
        return self._dry_run_failed_count

    @dry_run_failed_count.setter
    def dry_run_failed_count(self, dry_run_failed_count: int) -> None:
        """
        Sets the dry_run_failed_count of this ContactImportJobMetadata.


        :param dry_run_failed_count: The dry_run_failed_count of this ContactImportJobMetadata.
        :type: int
        """
        

        self._dry_run_failed_count = dry_run_failed_count

    @property
    def dry_run_success_count(self) -> int:
        """
        Gets the dry_run_success_count of this ContactImportJobMetadata.


        :return: The dry_run_success_count of this ContactImportJobMetadata.
        :rtype: int
        """
        return self._dry_run_success_count

    @dry_run_success_count.setter
    def dry_run_success_count(self, dry_run_success_count: int) -> None:
        """
        Sets the dry_run_success_count of this ContactImportJobMetadata.


        :param dry_run_success_count: The dry_run_success_count of this ContactImportJobMetadata.
        :type: int
        """
        

        self._dry_run_success_count = dry_run_success_count

    @property
    def dry_run_report_download_url(self) -> str:
        """
        Gets the dry_run_report_download_url of this ContactImportJobMetadata.


        :return: The dry_run_report_download_url of this ContactImportJobMetadata.
        :rtype: str
        """
        return self._dry_run_report_download_url

    @dry_run_report_download_url.setter
    def dry_run_report_download_url(self, dry_run_report_download_url: str) -> None:
        """
        Sets the dry_run_report_download_url of this ContactImportJobMetadata.


        :param dry_run_report_download_url: The dry_run_report_download_url of this ContactImportJobMetadata.
        :type: str
        """
        

        self._dry_run_report_download_url = dry_run_report_download_url

    @property
    def import_failed_count(self) -> int:
        """
        Gets the import_failed_count of this ContactImportJobMetadata.


        :return: The import_failed_count of this ContactImportJobMetadata.
        :rtype: int
        """
        return self._import_failed_count

    @import_failed_count.setter
    def import_failed_count(self, import_failed_count: int) -> None:
        """
        Sets the import_failed_count of this ContactImportJobMetadata.


        :param import_failed_count: The import_failed_count of this ContactImportJobMetadata.
        :type: int
        """
        

        self._import_failed_count = import_failed_count

    @property
    def import_success_count(self) -> int:
        """
        Gets the import_success_count of this ContactImportJobMetadata.


        :return: The import_success_count of this ContactImportJobMetadata.
        :rtype: int
        """
        return self._import_success_count

    @import_success_count.setter
    def import_success_count(self, import_success_count: int) -> None:
        """
        Sets the import_success_count of this ContactImportJobMetadata.


        :param import_success_count: The import_success_count of this ContactImportJobMetadata.
        :type: int
        """
        

        self._import_success_count = import_success_count

    @property
    def import_report_download_url(self) -> str:
        """
        Gets the import_report_download_url of this ContactImportJobMetadata.


        :return: The import_report_download_url of this ContactImportJobMetadata.
        :rtype: str
        """
        return self._import_report_download_url

    @import_report_download_url.setter
    def import_report_download_url(self, import_report_download_url: str) -> None:
        """
        Sets the import_report_download_url of this ContactImportJobMetadata.


        :param import_report_download_url: The import_report_download_url of this ContactImportJobMetadata.
        :type: str
        """
        

        self._import_report_download_url = import_report_download_url

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

