# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ExternalSource
    from . import WritableStarrableDivision

class ContactIdentifier(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ContactIdentifier - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'division': 'WritableStarrableDivision',
            'type': 'str',
            'value': 'str',
            'date_created': 'datetime',
            'external_source': 'ExternalSource',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'division': 'division',
            'type': 'type',
            'value': 'value',
            'date_created': 'dateCreated',
            'external_source': 'externalSource',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._division = None
        self._type = None
        self._value = None
        self._date_created = None
        self._external_source = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this ContactIdentifier.
        The globally unique identifier for the object.

        :return: The id of this ContactIdentifier.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ContactIdentifier.
        The globally unique identifier for the object.

        :param id: The id of this ContactIdentifier.
        :type: str
        """
        

        self._id = id

    @property
    def division(self) -> 'WritableStarrableDivision':
        """
        Gets the division of this ContactIdentifier.
        The division to which this entity belongs.

        :return: The division of this ContactIdentifier.
        :rtype: WritableStarrableDivision
        """
        return self._division

    @division.setter
    def division(self, division: 'WritableStarrableDivision') -> None:
        """
        Sets the division of this ContactIdentifier.
        The division to which this entity belongs.

        :param division: The division of this ContactIdentifier.
        :type: WritableStarrableDivision
        """
        

        self._division = division

    @property
    def type(self) -> str:
        """
        Gets the type of this ContactIdentifier.
        The type of this identifier

        :return: The type of this ContactIdentifier.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this ContactIdentifier.
        The type of this identifier

        :param type: The type of this ContactIdentifier.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["SocialLine", "SocialFacebook", "SocialTwitter", "SocialWhatsapp", "SocialInstagram", "Email", "Phone", "Cookie", "ExternalId"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def value(self) -> str:
        """
        Gets the value of this ContactIdentifier.
        The string value of the identifier. Will vary in syntax by type.

        :return: The value of this ContactIdentifier.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value: str) -> None:
        """
        Sets the value of this ContactIdentifier.
        The string value of the identifier. Will vary in syntax by type.

        :param value: The value of this ContactIdentifier.
        :type: str
        """
        

        self._value = value

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this ContactIdentifier.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this ContactIdentifier.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this ContactIdentifier.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this ContactIdentifier.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def external_source(self) -> 'ExternalSource':
        """
        Gets the external_source of this ContactIdentifier.
        The External Source ID of the identifier

        :return: The external_source of this ContactIdentifier.
        :rtype: ExternalSource
        """
        return self._external_source

    @external_source.setter
    def external_source(self, external_source: 'ExternalSource') -> None:
        """
        Sets the external_source of this ContactIdentifier.
        The External Source ID of the identifier

        :param external_source: The external_source of this ContactIdentifier.
        :type: ExternalSource
        """
        

        self._external_source = external_source

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this ContactIdentifier.
        The URI for this object

        :return: The self_uri of this ContactIdentifier.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this ContactIdentifier.
        The URI for this object

        :param self_uri: The self_uri of this ContactIdentifier.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

