# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ContactEnrichOptions
    from . import ContactIdentifier
    from . import EnrichFieldRules
    from . import ExternalContact
    from . import WritableStarrableDivision

class ContactEnrichRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ContactEnrichRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'division': 'WritableStarrableDivision',
            'matching_identifiers': 'list[ContactIdentifier]',
            'action': 'str',
            'contact': 'ExternalContact',
            'field_rules': 'EnrichFieldRules',
            'options': 'ContactEnrichOptions'
        }

        self.attribute_map = {
            'id': 'id',
            'division': 'division',
            'matching_identifiers': 'matchingIdentifiers',
            'action': 'action',
            'contact': 'contact',
            'field_rules': 'fieldRules',
            'options': 'options'
        }

        self._id = None
        self._division = None
        self._matching_identifiers = None
        self._action = None
        self._contact = None
        self._field_rules = None
        self._options = None

    @property
    def id(self) -> str:
        """
        Gets the id of this ContactEnrichRequest.
        A user-specified tracker string, only useful in the Bulk-Enrich API. If one Bulk-Enrich operation in a request fails, the requested operation will be repeated in the Bulk API response, including this id field, allowing associating of request and response operations.

        :return: The id of this ContactEnrichRequest.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ContactEnrichRequest.
        A user-specified tracker string, only useful in the Bulk-Enrich API. If one Bulk-Enrich operation in a request fails, the requested operation will be repeated in the Bulk API response, including this id field, allowing associating of request and response operations.

        :param id: The id of this ContactEnrichRequest.
        :type: str
        """
        

        self._id = id

    @property
    def division(self) -> 'WritableStarrableDivision':
        """
        Gets the division of this ContactEnrichRequest.
        The division to which this entity belongs.

        :return: The division of this ContactEnrichRequest.
        :rtype: WritableStarrableDivision
        """
        return self._division

    @division.setter
    def division(self, division: 'WritableStarrableDivision') -> None:
        """
        Sets the division of this ContactEnrichRequest.
        The division to which this entity belongs.

        :param division: The division of this ContactEnrichRequest.
        :type: WritableStarrableDivision
        """
        

        self._division = division

    @property
    def matching_identifiers(self) -> List['ContactIdentifier']:
        """
        Gets the matching_identifiers of this ContactEnrichRequest.
        An ordered list of one or more Identifiers which might each be claimed by a Contact. `action` describes what to do with any possibly matching Contacts. Identifier lookups will occur in the order specified here.

        :return: The matching_identifiers of this ContactEnrichRequest.
        :rtype: list[ContactIdentifier]
        """
        return self._matching_identifiers

    @matching_identifiers.setter
    def matching_identifiers(self, matching_identifiers: List['ContactIdentifier']) -> None:
        """
        Sets the matching_identifiers of this ContactEnrichRequest.
        An ordered list of one or more Identifiers which might each be claimed by a Contact. `action` describes what to do with any possibly matching Contacts. Identifier lookups will occur in the order specified here.

        :param matching_identifiers: The matching_identifiers of this ContactEnrichRequest.
        :type: list[ContactIdentifier]
        """
        

        self._matching_identifiers = matching_identifiers

    @property
    def action(self) -> str:
        """
        Gets the action of this ContactEnrichRequest.
        The action that should be taken based on any Contacts found by `matchingIdentifiers`.

        :return: The action of this ContactEnrichRequest.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action: str) -> None:
        """
        Sets the action of this ContactEnrichRequest.
        The action that should be taken based on any Contacts found by `matchingIdentifiers`.

        :param action: The action of this ContactEnrichRequest.
        :type: str
        """
        if isinstance(action, int):
            action = str(action)
        allowed_values = ["Merge", "Upsert", "Update", "Insert"]
        if action.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for action -> " + action)
            self._action = "outdated_sdk_version"
        else:
            self._action = action

    @property
    def contact(self) -> 'ExternalContact':
        """
        Gets the contact of this ContactEnrichRequest.
        Data to be added, either as an update to an existing Contact or the body of a new Contact. Omitting a field in this contract means that it will be treated as null in the `fieldRules` logic.

        :return: The contact of this ContactEnrichRequest.
        :rtype: ExternalContact
        """
        return self._contact

    @contact.setter
    def contact(self, contact: 'ExternalContact') -> None:
        """
        Sets the contact of this ContactEnrichRequest.
        Data to be added, either as an update to an existing Contact or the body of a new Contact. Omitting a field in this contract means that it will be treated as null in the `fieldRules` logic.

        :param contact: The contact of this ContactEnrichRequest.
        :type: ExternalContact
        """
        

        self._contact = contact

    @property
    def field_rules(self) -> 'EnrichFieldRules':
        """
        Gets the field_rules of this ContactEnrichRequest.
        Logic describing how to combine data from the submitted request with data found in the database.

        :return: The field_rules of this ContactEnrichRequest.
        :rtype: EnrichFieldRules
        """
        return self._field_rules

    @field_rules.setter
    def field_rules(self, field_rules: 'EnrichFieldRules') -> None:
        """
        Sets the field_rules of this ContactEnrichRequest.
        Logic describing how to combine data from the submitted request with data found in the database.

        :param field_rules: The field_rules of this ContactEnrichRequest.
        :type: EnrichFieldRules
        """
        

        self._field_rules = field_rules

    @property
    def options(self) -> 'ContactEnrichOptions':
        """
        Gets the options of this ContactEnrichRequest.
        Additional options modifying the behavior of the API operation.

        :return: The options of this ContactEnrichRequest.
        :rtype: ContactEnrichOptions
        """
        return self._options

    @options.setter
    def options(self, options: 'ContactEnrichOptions') -> None:
        """
        Sets the options of this ContactEnrichRequest.
        Additional options modifying the behavior of the API operation.

        :param options: The options of this ContactEnrichRequest.
        :type: ContactEnrichOptions
        """
        

        self._options = options

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

