# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import TranscriptTranslation

class CommunicationTranslation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CommunicationTranslation - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'communication_id': 'str',
            'transcripts': 'list[TranscriptTranslation]'
        }

        self.attribute_map = {
            'communication_id': 'communicationId',
            'transcripts': 'transcripts'
        }

        self._communication_id = None
        self._transcripts = None

    @property
    def communication_id(self) -> str:
        """
        Gets the communication_id of this CommunicationTranslation.
        Communication Id

        :return: The communication_id of this CommunicationTranslation.
        :rtype: str
        """
        return self._communication_id

    @communication_id.setter
    def communication_id(self, communication_id: str) -> None:
        """
        Sets the communication_id of this CommunicationTranslation.
        Communication Id

        :param communication_id: The communication_id of this CommunicationTranslation.
        :type: str
        """
        

        self._communication_id = communication_id

    @property
    def transcripts(self) -> List['TranscriptTranslation']:
        """
        Gets the transcripts of this CommunicationTranslation.
        List of translated transcripts

        :return: The transcripts of this CommunicationTranslation.
        :rtype: list[TranscriptTranslation]
        """
        return self._transcripts

    @transcripts.setter
    def transcripts(self, transcripts: List['TranscriptTranslation']) -> None:
        """
        Sets the transcripts of this CommunicationTranslation.
        List of translated transcripts

        :param transcripts: The transcripts of this CommunicationTranslation.
        :type: list[TranscriptTranslation]
        """
        

        self._transcripts = transcripts

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

