# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef

class CommonRulePredicateEntity(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CommonRulePredicateEntity - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'entity_type': 'str',
            'user': 'AddressableEntityRef',
            'group': 'AddressableEntityRef',
            'queue': 'AddressableEntityRef',
            'team': 'AddressableEntityRef'
        }

        self.attribute_map = {
            'entity_type': 'entityType',
            'user': 'user',
            'group': 'group',
            'queue': 'queue',
            'team': 'team'
        }

        self._entity_type = None
        self._user = None
        self._group = None
        self._queue = None
        self._team = None

    @property
    def entity_type(self) -> str:
        """
        Gets the entity_type of this CommonRulePredicateEntity.
        Specifies the type of entity being evaluated

        :return: The entity_type of this CommonRulePredicateEntity.
        :rtype: str
        """
        return self._entity_type

    @entity_type.setter
    def entity_type(self, entity_type: str) -> None:
        """
        Sets the entity_type of this CommonRulePredicateEntity.
        Specifies the type of entity being evaluated

        :param entity_type: The entity_type of this CommonRulePredicateEntity.
        :type: str
        """
        if isinstance(entity_type, int):
            entity_type = str(entity_type)
        allowed_values = ["User", "Group", "Queue", "Team", "TeamMembers"]
        if entity_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for entity_type -> " + entity_type)
            self._entity_type = "outdated_sdk_version"
        else:
            self._entity_type = entity_type

    @property
    def user(self) -> 'AddressableEntityRef':
        """
        Gets the user of this CommonRulePredicateEntity.
        User id of the entity being monitored

        :return: The user of this CommonRulePredicateEntity.
        :rtype: AddressableEntityRef
        """
        return self._user

    @user.setter
    def user(self, user: 'AddressableEntityRef') -> None:
        """
        Sets the user of this CommonRulePredicateEntity.
        User id of the entity being monitored

        :param user: The user of this CommonRulePredicateEntity.
        :type: AddressableEntityRef
        """
        

        self._user = user

    @property
    def group(self) -> 'AddressableEntityRef':
        """
        Gets the group of this CommonRulePredicateEntity.
        Group id of the entity being monitored

        :return: The group of this CommonRulePredicateEntity.
        :rtype: AddressableEntityRef
        """
        return self._group

    @group.setter
    def group(self, group: 'AddressableEntityRef') -> None:
        """
        Sets the group of this CommonRulePredicateEntity.
        Group id of the entity being monitored

        :param group: The group of this CommonRulePredicateEntity.
        :type: AddressableEntityRef
        """
        

        self._group = group

    @property
    def queue(self) -> 'AddressableEntityRef':
        """
        Gets the queue of this CommonRulePredicateEntity.
        Queue id of the entity being monitored

        :return: The queue of this CommonRulePredicateEntity.
        :rtype: AddressableEntityRef
        """
        return self._queue

    @queue.setter
    def queue(self, queue: 'AddressableEntityRef') -> None:
        """
        Sets the queue of this CommonRulePredicateEntity.
        Queue id of the entity being monitored

        :param queue: The queue of this CommonRulePredicateEntity.
        :type: AddressableEntityRef
        """
        

        self._queue = queue

    @property
    def team(self) -> 'AddressableEntityRef':
        """
        Gets the team of this CommonRulePredicateEntity.
        Team id of the entity being monitored

        :return: The team of this CommonRulePredicateEntity.
        :rtype: AddressableEntityRef
        """
        return self._team

    @team.setter
    def team(self, team: 'AddressableEntityRef') -> None:
        """
        Sets the team of this CommonRulePredicateEntity.
        Team id of the entity being monitored

        :param team: The team of this CommonRulePredicateEntity.
        :type: AddressableEntityRef
        """
        

        self._team = team

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

