# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import CommonRulePredicateEntity

class CommonRulePredicate(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CommonRulePredicate - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'metric_type': 'str',
            'metric_value_type': 'str',
            'comparison_operator': 'str',
            'value': 'float',
            'status': 'str',
            'topic': 'str',
            'entity': 'CommonRulePredicateEntity',
            'media_type': 'str',
            'metric': 'str'
        }

        self.attribute_map = {
            'metric_type': 'metricType',
            'metric_value_type': 'metricValueType',
            'comparison_operator': 'comparisonOperator',
            'value': 'value',
            'status': 'status',
            'topic': 'topic',
            'entity': 'entity',
            'media_type': 'mediaType',
            'metric': 'metric'
        }

        self._metric_type = None
        self._metric_value_type = None
        self._comparison_operator = None
        self._value = None
        self._status = None
        self._topic = None
        self._entity = None
        self._media_type = None
        self._metric = None

    @property
    def metric_type(self) -> str:
        """
        Gets the metric_type of this CommonRulePredicate.
        The type of metric being evaluated.

        :return: The metric_type of this CommonRulePredicate.
        :rtype: str
        """
        return self._metric_type

    @metric_type.setter
    def metric_type(self, metric_type: str) -> None:
        """
        Sets the metric_type of this CommonRulePredicate.
        The type of metric being evaluated.

        :param metric_type: The metric_type of this CommonRulePredicate.
        :type: str
        """
        if isinstance(metric_type, int):
            metric_type = str(metric_type)
        allowed_values = ["Interval", "Instance"]
        if metric_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for metric_type -> " + metric_type)
            self._metric_type = "outdated_sdk_version"
        else:
            self._metric_type = metric_type

    @property
    def metric_value_type(self) -> str:
        """
        Gets the metric_value_type of this CommonRulePredicate.
        The type of metric value being evaluated.

        :return: The metric_value_type of this CommonRulePredicate.
        :rtype: str
        """
        return self._metric_value_type

    @metric_value_type.setter
    def metric_value_type(self, metric_value_type: str) -> None:
        """
        Sets the metric_value_type of this CommonRulePredicate.
        The type of metric value being evaluated.

        :param metric_value_type: The metric_value_type of this CommonRulePredicate.
        :type: str
        """
        if isinstance(metric_value_type, int):
            metric_value_type = str(metric_value_type)
        allowed_values = ["Count", "Min", "Timer", "Max", "Percentage", "Average", "Observation"]
        if metric_value_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for metric_value_type -> " + metric_value_type)
            self._metric_value_type = "outdated_sdk_version"
        else:
            self._metric_value_type = metric_value_type

    @property
    def comparison_operator(self) -> str:
        """
        Gets the comparison_operator of this CommonRulePredicate.
        The comparison operator being performed on the metric.

        :return: The comparison_operator of this CommonRulePredicate.
        :rtype: str
        """
        return self._comparison_operator

    @comparison_operator.setter
    def comparison_operator(self, comparison_operator: str) -> None:
        """
        Sets the comparison_operator of this CommonRulePredicate.
        The comparison operator being performed on the metric.

        :param comparison_operator: The comparison_operator of this CommonRulePredicate.
        :type: str
        """
        if isinstance(comparison_operator, int):
            comparison_operator = str(comparison_operator)
        allowed_values = ["Gt", "Gte", "Lt", "Lte", "Eq", "Ne"]
        if comparison_operator.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for comparison_operator -> " + comparison_operator)
            self._comparison_operator = "outdated_sdk_version"
        else:
            self._comparison_operator = comparison_operator

    @property
    def value(self) -> float:
        """
        Gets the value of this CommonRulePredicate.
        The value the metric will be compared to.

        :return: The value of this CommonRulePredicate.
        :rtype: float
        """
        return self._value

    @value.setter
    def value(self, value: float) -> None:
        """
        Sets the value of this CommonRulePredicate.
        The value the metric will be compared to.

        :param value: The value of this CommonRulePredicate.
        :type: float
        """
        

        self._value = value

    @property
    def status(self) -> str:
        """
        Gets the status of this CommonRulePredicate.
        The status of the entity corresponding to the metric.

        :return: The status of this CommonRulePredicate.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this CommonRulePredicate.
        The status of the entity corresponding to the metric.

        :param status: The status of this CommonRulePredicate.
        :type: str
        """
        

        self._status = status

    @property
    def topic(self) -> str:
        """
        Gets the topic of this CommonRulePredicate.
        The operational console topic corresponding to the metric.

        :return: The topic of this CommonRulePredicate.
        :rtype: str
        """
        return self._topic

    @topic.setter
    def topic(self, topic: str) -> None:
        """
        Sets the topic of this CommonRulePredicate.
        The operational console topic corresponding to the metric.

        :param topic: The topic of this CommonRulePredicate.
        :type: str
        """
        

        self._topic = topic

    @property
    def entity(self) -> 'CommonRulePredicateEntity':
        """
        Gets the entity of this CommonRulePredicate.
        The entity whose metric is being represented.

        :return: The entity of this CommonRulePredicate.
        :rtype: CommonRulePredicateEntity
        """
        return self._entity

    @entity.setter
    def entity(self, entity: 'CommonRulePredicateEntity') -> None:
        """
        Sets the entity of this CommonRulePredicate.
        The entity whose metric is being represented.

        :param entity: The entity of this CommonRulePredicate.
        :type: CommonRulePredicateEntity
        """
        

        self._entity = entity

    @property
    def media_type(self) -> str:
        """
        Gets the media_type of this CommonRulePredicate.
        The media type of the conversation the metric describes.

        :return: The media_type of this CommonRulePredicate.
        :rtype: str
        """
        return self._media_type

    @media_type.setter
    def media_type(self, media_type: str) -> None:
        """
        Sets the media_type of this CommonRulePredicate.
        The media type of the conversation the metric describes.

        :param media_type: The media_type of this CommonRulePredicate.
        :type: str
        """
        if isinstance(media_type, int):
            media_type = str(media_type)
        allowed_values = ["Voice", "Chat", "Email", "Callback", "Message"]
        if media_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for media_type -> " + media_type)
            self._media_type = "outdated_sdk_version"
        else:
            self._media_type = media_type

    @property
    def metric(self) -> str:
        """
        Gets the metric of this CommonRulePredicate.
        The metric being evaluated.

        :return: The metric of this CommonRulePredicate.
        :rtype: str
        """
        return self._metric

    @metric.setter
    def metric(self, metric: str) -> None:
        """
        Sets the metric of this CommonRulePredicate.
        The metric being evaluated.

        :param metric: The metric of this CommonRulePredicate.
        :type: str
        """
        if isinstance(metric, int):
            metric = str(metric)
        allowed_values = ["nAbandon", "nConnected", "nInteractions", "nOffered", "nOutbound", "nTransferred", "serviceLevel", "oServiceLevel", "oWaiting", "tAbandon", "tAcw", "tAlert", "tAnswered", "tHandle", "tHeldComplete", "tTalkComplete", "tWait", "tTalk", "tHeld", "tOrganizationPresence", "tSystemPresence", "tAgentRoutingStatus", "oUserRoutingStatuses", "oUserPresences", "oInteracting", "tFlowOut", "tAdherenceStatus", "nEvents"]
        if metric.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for metric -> " + metric)
            self._metric = "outdated_sdk_version"
        else:
            self._metric = metric

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

