# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class Column(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        Column - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'column_name': 'str',
            'column_number': 'int',
            'start_position': 'int',
            'length': 'int'
        }

        self.attribute_map = {
            'column_name': 'columnName',
            'column_number': 'columnNumber',
            'start_position': 'startPosition',
            'length': 'length'
        }

        self._column_name = None
        self._column_number = None
        self._start_position = None
        self._length = None

    @property
    def column_name(self) -> str:
        """
        Gets the column_name of this Column.
        Column name. Mandatory for Fixed position/length file format.

        :return: The column_name of this Column.
        :rtype: str
        """
        return self._column_name

    @column_name.setter
    def column_name(self, column_name: str) -> None:
        """
        Sets the column_name of this Column.
        Column name. Mandatory for Fixed position/length file format.

        :param column_name: The column_name of this Column.
        :type: str
        """
        

        self._column_name = column_name

    @property
    def column_number(self) -> int:
        """
        Gets the column_number of this Column.
        0 based column number in delimited file format

        :return: The column_number of this Column.
        :rtype: int
        """
        return self._column_number

    @column_number.setter
    def column_number(self, column_number: int) -> None:
        """
        Sets the column_number of this Column.
        0 based column number in delimited file format

        :param column_number: The column_number of this Column.
        :type: int
        """
        

        self._column_number = column_number

    @property
    def start_position(self) -> int:
        """
        Gets the start_position of this Column.
        Zero-based position of the first column's character. Mandatory for Fixed position/length file format.

        :return: The start_position of this Column.
        :rtype: int
        """
        return self._start_position

    @start_position.setter
    def start_position(self, start_position: int) -> None:
        """
        Sets the start_position of this Column.
        Zero-based position of the first column's character. Mandatory for Fixed position/length file format.

        :param start_position: The start_position of this Column.
        :type: int
        """
        

        self._start_position = start_position

    @property
    def length(self) -> int:
        """
        Gets the length of this Column.
        Column width. Mandatory for Fixed position/length file format.

        :return: The length of this Column.
        :rtype: int
        """
        return self._length

    @length.setter
    def length(self, length: int) -> None:
        """
        Sets the length of this Column.
        Column width. Mandatory for Fixed position/length file format.

        :param length: The length of this Column.
        :type: int
        """
        

        self._length = length

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

