# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ChatPresence
    from . import Contact

class ChatUserRef(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ChatUserRef - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'self_uri': 'str',
            'jid': 'str',
            'inactive': 'bool',
            'integrations': 'list[Contact]',
            'presence': 'ChatPresence'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'self_uri': 'selfUri',
            'jid': 'jid',
            'inactive': 'inactive',
            'integrations': 'integrations',
            'presence': 'presence'
        }

        self._id = None
        self._name = None
        self._self_uri = None
        self._jid = None
        self._inactive = None
        self._integrations = None
        self._presence = None

    @property
    def id(self) -> str:
        """
        Gets the id of this ChatUserRef.


        :return: The id of this ChatUserRef.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ChatUserRef.


        :param id: The id of this ChatUserRef.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this ChatUserRef.


        :return: The name of this ChatUserRef.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this ChatUserRef.


        :param name: The name of this ChatUserRef.
        :type: str
        """
        

        self._name = name

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this ChatUserRef.


        :return: The self_uri of this ChatUserRef.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this ChatUserRef.


        :param self_uri: The self_uri of this ChatUserRef.
        :type: str
        """
        

        self._self_uri = self_uri

    @property
    def jid(self) -> str:
        """
        Gets the jid of this ChatUserRef.


        :return: The jid of this ChatUserRef.
        :rtype: str
        """
        return self._jid

    @jid.setter
    def jid(self, jid: str) -> None:
        """
        Sets the jid of this ChatUserRef.


        :param jid: The jid of this ChatUserRef.
        :type: str
        """
        

        self._jid = jid

    @property
    def inactive(self) -> bool:
        """
        Gets the inactive of this ChatUserRef.


        :return: The inactive of this ChatUserRef.
        :rtype: bool
        """
        return self._inactive

    @inactive.setter
    def inactive(self, inactive: bool) -> None:
        """
        Sets the inactive of this ChatUserRef.


        :param inactive: The inactive of this ChatUserRef.
        :type: bool
        """
        

        self._inactive = inactive

    @property
    def integrations(self) -> List['Contact']:
        """
        Gets the integrations of this ChatUserRef.


        :return: The integrations of this ChatUserRef.
        :rtype: list[Contact]
        """
        return self._integrations

    @integrations.setter
    def integrations(self, integrations: List['Contact']) -> None:
        """
        Sets the integrations of this ChatUserRef.


        :param integrations: The integrations of this ChatUserRef.
        :type: list[Contact]
        """
        

        self._integrations = integrations

    @property
    def presence(self) -> 'ChatPresence':
        """
        Gets the presence of this ChatUserRef.


        :return: The presence of this ChatUserRef.
        :rtype: ChatPresence
        """
        return self._presence

    @presence.setter
    def presence(self, presence: 'ChatPresence') -> None:
        """
        Sets the presence of this ChatUserRef.


        :param presence: The presence of this ChatUserRef.
        :type: ChatPresence
        """
        

        self._presence = presence

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

