# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ChatFavorite
    from . import ChatUserRef
    from . import Image
    from . import Room

class ChatItem(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ChatItem - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'open': 'bool',
            'favorite': 'ChatFavorite',
            'images': 'list[Image]',
            'date_last_message': 'datetime',
            'date_closed': 'datetime',
            'user': 'ChatUserRef',
            'room': 'Room',
            'chat_type': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'open': 'open',
            'favorite': 'favorite',
            'images': 'images',
            'date_last_message': 'dateLastMessage',
            'date_closed': 'dateClosed',
            'user': 'user',
            'room': 'room',
            'chat_type': 'chatType',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._open = None
        self._favorite = None
        self._images = None
        self._date_last_message = None
        self._date_closed = None
        self._user = None
        self._room = None
        self._chat_type = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this ChatItem.
        The globally unique identifier for the object.

        :return: The id of this ChatItem.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ChatItem.
        The globally unique identifier for the object.

        :param id: The id of this ChatItem.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this ChatItem.


        :return: The name of this ChatItem.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this ChatItem.


        :param name: The name of this ChatItem.
        :type: str
        """
        

        self._name = name

    @property
    def open(self) -> bool:
        """
        Gets the open of this ChatItem.
        If the chat is open

        :return: The open of this ChatItem.
        :rtype: bool
        """
        return self._open

    @open.setter
    def open(self, open: bool) -> None:
        """
        Sets the open of this ChatItem.
        If the chat is open

        :param open: The open of this ChatItem.
        :type: bool
        """
        

        self._open = open

    @property
    def favorite(self) -> 'ChatFavorite':
        """
        Gets the favorite of this ChatItem.
        The favorite entity for the chat, only appears if the chat is favorited

        :return: The favorite of this ChatItem.
        :rtype: ChatFavorite
        """
        return self._favorite

    @favorite.setter
    def favorite(self, favorite: 'ChatFavorite') -> None:
        """
        Sets the favorite of this ChatItem.
        The favorite entity for the chat, only appears if the chat is favorited

        :param favorite: The favorite of this ChatItem.
        :type: ChatFavorite
        """
        

        self._favorite = favorite

    @property
    def images(self) -> List['Image']:
        """
        Gets the images of this ChatItem.
        Avatar images for the chat

        :return: The images of this ChatItem.
        :rtype: list[Image]
        """
        return self._images

    @images.setter
    def images(self, images: List['Image']) -> None:
        """
        Sets the images of this ChatItem.
        Avatar images for the chat

        :param images: The images of this ChatItem.
        :type: list[Image]
        """
        

        self._images = images

    @property
    def date_last_message(self) -> datetime:
        """
        Gets the date_last_message of this ChatItem.
        The date of the last message. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_last_message of this ChatItem.
        :rtype: datetime
        """
        return self._date_last_message

    @date_last_message.setter
    def date_last_message(self, date_last_message: datetime) -> None:
        """
        Sets the date_last_message of this ChatItem.
        The date of the last message. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_last_message: The date_last_message of this ChatItem.
        :type: datetime
        """
        

        self._date_last_message = date_last_message

    @property
    def date_closed(self) -> datetime:
        """
        Gets the date_closed of this ChatItem.
        The date the chat was closed. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_closed of this ChatItem.
        :rtype: datetime
        """
        return self._date_closed

    @date_closed.setter
    def date_closed(self, date_closed: datetime) -> None:
        """
        Sets the date_closed of this ChatItem.
        The date the chat was closed. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_closed: The date_closed of this ChatItem.
        :type: datetime
        """
        

        self._date_closed = date_closed

    @property
    def user(self) -> 'ChatUserRef':
        """
        Gets the user of this ChatItem.
        The other 1on1 user

        :return: The user of this ChatItem.
        :rtype: ChatUserRef
        """
        return self._user

    @user.setter
    def user(self, user: 'ChatUserRef') -> None:
        """
        Sets the user of this ChatItem.
        The other 1on1 user

        :param user: The user of this ChatItem.
        :type: ChatUserRef
        """
        

        self._user = user

    @property
    def room(self) -> 'Room':
        """
        Gets the room of this ChatItem.
        The room of the chat

        :return: The room of this ChatItem.
        :rtype: Room
        """
        return self._room

    @room.setter
    def room(self, room: 'Room') -> None:
        """
        Sets the room of this ChatItem.
        The room of the chat

        :param room: The room of this ChatItem.
        :type: Room
        """
        

        self._room = room

    @property
    def chat_type(self) -> str:
        """
        Gets the chat_type of this ChatItem.
        The type of chat

        :return: The chat_type of this ChatItem.
        :rtype: str
        """
        return self._chat_type

    @chat_type.setter
    def chat_type(self, chat_type: str) -> None:
        """
        Sets the chat_type of this ChatItem.
        The type of chat

        :param chat_type: The chat_type of this ChatItem.
        :type: str
        """
        if isinstance(chat_type, int):
            chat_type = str(chat_type)
        allowed_values = ["adhoc", "acd", "group", "oneOnOne", "supervisorAssistance"]
        if chat_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for chat_type -> " + chat_type)
            self._chat_type = "outdated_sdk_version"
        else:
            self._chat_type = chat_type

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this ChatItem.
        The URI for this object

        :return: The self_uri of this ChatItem.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this ChatItem.
        The URI for this object

        :param self_uri: The self_uri of this ChatItem.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

