# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class CannedResponseLibraries(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CannedResponseLibraries - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'library_ids': 'list[str]',
            'mode': 'str'
        }

        self.attribute_map = {
            'library_ids': 'libraryIds',
            'mode': 'mode'
        }

        self._library_ids = None
        self._mode = None

    @property
    def library_ids(self) -> List[str]:
        """
        Gets the library_ids of this CannedResponseLibraries.
        Set of canned response library IDs associated with the queue only when mode is SelectedOnly.

        :return: The library_ids of this CannedResponseLibraries.
        :rtype: list[str]
        """
        return self._library_ids

    @library_ids.setter
    def library_ids(self, library_ids: List[str]) -> None:
        """
        Sets the library_ids of this CannedResponseLibraries.
        Set of canned response library IDs associated with the queue only when mode is SelectedOnly.

        :param library_ids: The library_ids of this CannedResponseLibraries.
        :type: list[str]
        """
        

        self._library_ids = library_ids

    @property
    def mode(self) -> str:
        """
        Gets the mode of this CannedResponseLibraries.
        The association mode of canned response libraries to queue

        :return: The mode of this CannedResponseLibraries.
        :rtype: str
        """
        return self._mode

    @mode.setter
    def mode(self, mode: str) -> None:
        """
        Sets the mode of this CannedResponseLibraries.
        The association mode of canned response libraries to queue

        :param mode: The mode of this CannedResponseLibraries.
        :type: str
        """
        if isinstance(mode, int):
            mode = str(mode)
        allowed_values = ["All", "SelectedOnly", "None"]
        if mode.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for mode -> " + mode)
            self._mode = "outdated_sdk_version"
        else:
            self._mode = mode

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

