# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import CampaignRuleAction
    from . import CampaignRuleCondition
    from . import CampaignRuleConditionGroup
    from . import CampaignRuleEntities
    from . import CampaignRuleExecutionSettings
    from . import CampaignRuleWarning

class CampaignRule(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CampaignRule - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'version': 'int',
            'campaign_rule_entities': 'CampaignRuleEntities',
            'campaign_rule_conditions': 'list[CampaignRuleCondition]',
            'campaign_rule_actions': 'list[CampaignRuleAction]',
            'match_any_conditions': 'bool',
            'enabled': 'bool',
            'campaign_rule_processing': 'str',
            'condition_groups': 'list[CampaignRuleConditionGroup]',
            'execution_settings': 'CampaignRuleExecutionSettings',
            'warnings': 'list[CampaignRuleWarning]',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'version': 'version',
            'campaign_rule_entities': 'campaignRuleEntities',
            'campaign_rule_conditions': 'campaignRuleConditions',
            'campaign_rule_actions': 'campaignRuleActions',
            'match_any_conditions': 'matchAnyConditions',
            'enabled': 'enabled',
            'campaign_rule_processing': 'campaignRuleProcessing',
            'condition_groups': 'conditionGroups',
            'execution_settings': 'executionSettings',
            'warnings': 'warnings',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._date_created = None
        self._date_modified = None
        self._version = None
        self._campaign_rule_entities = None
        self._campaign_rule_conditions = None
        self._campaign_rule_actions = None
        self._match_any_conditions = None
        self._enabled = None
        self._campaign_rule_processing = None
        self._condition_groups = None
        self._execution_settings = None
        self._warnings = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this CampaignRule.
        The globally unique identifier for the object.

        :return: The id of this CampaignRule.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this CampaignRule.
        The globally unique identifier for the object.

        :param id: The id of this CampaignRule.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this CampaignRule.
        The name of the CampaignRule.

        :return: The name of this CampaignRule.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this CampaignRule.
        The name of the CampaignRule.

        :param name: The name of this CampaignRule.
        :type: str
        """
        

        self._name = name

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this CampaignRule.
        Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this CampaignRule.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this CampaignRule.
        Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this CampaignRule.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this CampaignRule.
        Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this CampaignRule.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this CampaignRule.
        Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this CampaignRule.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def version(self) -> int:
        """
        Gets the version of this CampaignRule.
        Required for updates, must match the version number of the most recent update

        :return: The version of this CampaignRule.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version: int) -> None:
        """
        Sets the version of this CampaignRule.
        Required for updates, must match the version number of the most recent update

        :param version: The version of this CampaignRule.
        :type: int
        """
        

        self._version = version

    @property
    def campaign_rule_entities(self) -> 'CampaignRuleEntities':
        """
        Gets the campaign_rule_entities of this CampaignRule.
        The list of entities that this CampaignRule monitors.

        :return: The campaign_rule_entities of this CampaignRule.
        :rtype: CampaignRuleEntities
        """
        return self._campaign_rule_entities

    @campaign_rule_entities.setter
    def campaign_rule_entities(self, campaign_rule_entities: 'CampaignRuleEntities') -> None:
        """
        Sets the campaign_rule_entities of this CampaignRule.
        The list of entities that this CampaignRule monitors.

        :param campaign_rule_entities: The campaign_rule_entities of this CampaignRule.
        :type: CampaignRuleEntities
        """
        

        self._campaign_rule_entities = campaign_rule_entities

    @property
    def campaign_rule_conditions(self) -> List['CampaignRuleCondition']:
        """
        Gets the campaign_rule_conditions of this CampaignRule.
        The list of conditions that are evaluated on the entities.

        :return: The campaign_rule_conditions of this CampaignRule.
        :rtype: list[CampaignRuleCondition]
        """
        return self._campaign_rule_conditions

    @campaign_rule_conditions.setter
    def campaign_rule_conditions(self, campaign_rule_conditions: List['CampaignRuleCondition']) -> None:
        """
        Sets the campaign_rule_conditions of this CampaignRule.
        The list of conditions that are evaluated on the entities.

        :param campaign_rule_conditions: The campaign_rule_conditions of this CampaignRule.
        :type: list[CampaignRuleCondition]
        """
        

        self._campaign_rule_conditions = campaign_rule_conditions

    @property
    def campaign_rule_actions(self) -> List['CampaignRuleAction']:
        """
        Gets the campaign_rule_actions of this CampaignRule.
        The list of actions that are executed if the conditions are satisfied.

        :return: The campaign_rule_actions of this CampaignRule.
        :rtype: list[CampaignRuleAction]
        """
        return self._campaign_rule_actions

    @campaign_rule_actions.setter
    def campaign_rule_actions(self, campaign_rule_actions: List['CampaignRuleAction']) -> None:
        """
        Sets the campaign_rule_actions of this CampaignRule.
        The list of actions that are executed if the conditions are satisfied.

        :param campaign_rule_actions: The campaign_rule_actions of this CampaignRule.
        :type: list[CampaignRuleAction]
        """
        

        self._campaign_rule_actions = campaign_rule_actions

    @property
    def match_any_conditions(self) -> bool:
        """
        Gets the match_any_conditions of this CampaignRule.


        :return: The match_any_conditions of this CampaignRule.
        :rtype: bool
        """
        return self._match_any_conditions

    @match_any_conditions.setter
    def match_any_conditions(self, match_any_conditions: bool) -> None:
        """
        Sets the match_any_conditions of this CampaignRule.


        :param match_any_conditions: The match_any_conditions of this CampaignRule.
        :type: bool
        """
        

        self._match_any_conditions = match_any_conditions

    @property
    def enabled(self) -> bool:
        """
        Gets the enabled of this CampaignRule.
        Whether or not this CampaignRule is currently enabled. Required on updates.

        :return: The enabled of this CampaignRule.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled: bool) -> None:
        """
        Sets the enabled of this CampaignRule.
        Whether or not this CampaignRule is currently enabled. Required on updates.

        :param enabled: The enabled of this CampaignRule.
        :type: bool
        """
        

        self._enabled = enabled

    @property
    def campaign_rule_processing(self) -> str:
        """
        Gets the campaign_rule_processing of this CampaignRule.
        CampaignRule processing algorithm

        :return: The campaign_rule_processing of this CampaignRule.
        :rtype: str
        """
        return self._campaign_rule_processing

    @campaign_rule_processing.setter
    def campaign_rule_processing(self, campaign_rule_processing: str) -> None:
        """
        Sets the campaign_rule_processing of this CampaignRule.
        CampaignRule processing algorithm

        :param campaign_rule_processing: The campaign_rule_processing of this CampaignRule.
        :type: str
        """
        if isinstance(campaign_rule_processing, int):
            campaign_rule_processing = str(campaign_rule_processing)
        allowed_values = ["v2"]
        if campaign_rule_processing.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for campaign_rule_processing -> " + campaign_rule_processing)
            self._campaign_rule_processing = "outdated_sdk_version"
        else:
            self._campaign_rule_processing = campaign_rule_processing

    @property
    def condition_groups(self) -> List['CampaignRuleConditionGroup']:
        """
        Gets the condition_groups of this CampaignRule.
        List of condition groups that are evaluated, used only with campaignRuleProcessing=\"v2\"

        :return: The condition_groups of this CampaignRule.
        :rtype: list[CampaignRuleConditionGroup]
        """
        return self._condition_groups

    @condition_groups.setter
    def condition_groups(self, condition_groups: List['CampaignRuleConditionGroup']) -> None:
        """
        Sets the condition_groups of this CampaignRule.
        List of condition groups that are evaluated, used only with campaignRuleProcessing=\"v2\"

        :param condition_groups: The condition_groups of this CampaignRule.
        :type: list[CampaignRuleConditionGroup]
        """
        

        self._condition_groups = condition_groups

    @property
    def execution_settings(self) -> 'CampaignRuleExecutionSettings':
        """
        Gets the execution_settings of this CampaignRule.
        CampaignRule execution settings

        :return: The execution_settings of this CampaignRule.
        :rtype: CampaignRuleExecutionSettings
        """
        return self._execution_settings

    @execution_settings.setter
    def execution_settings(self, execution_settings: 'CampaignRuleExecutionSettings') -> None:
        """
        Sets the execution_settings of this CampaignRule.
        CampaignRule execution settings

        :param execution_settings: The execution_settings of this CampaignRule.
        :type: CampaignRuleExecutionSettings
        """
        

        self._execution_settings = execution_settings

    @property
    def warnings(self) -> List['CampaignRuleWarning']:
        """
        Gets the warnings of this CampaignRule.
        A list of current warning conditions associated with the campaign rule.

        :return: The warnings of this CampaignRule.
        :rtype: list[CampaignRuleWarning]
        """
        return self._warnings

    @warnings.setter
    def warnings(self, warnings: List['CampaignRuleWarning']) -> None:
        """
        Sets the warnings of this CampaignRule.
        A list of current warning conditions associated with the campaign rule.

        :param warnings: The warnings of this CampaignRule.
        :type: list[CampaignRuleWarning]
        """
        

        self._warnings = warnings

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this CampaignRule.
        The URI for this object

        :return: The self_uri of this CampaignRule.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this CampaignRule.
        The URI for this object

        :param self_uri: The self_uri of this CampaignRule.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

