# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef
    from . import CampaignOutboundLinesAllocation
    from . import CampaignOutboundLinesReservation

class CampaignOutboundLinesDistribution(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CampaignOutboundLinesDistribution - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'campaign': 'AddressableEntityRef',
            'max_outbound_line_count': 'int',
            'max_line_utilization': 'float',
            'available_outbound_lines': 'int',
            'reserved_lines': 'int',
            'campaigns_with_reserved_lines': 'list[CampaignOutboundLinesReservation]',
            'campaigns_with_dynamically_allocated_lines': 'list[CampaignOutboundLinesAllocation]'
        }

        self.attribute_map = {
            'campaign': 'campaign',
            'max_outbound_line_count': 'maxOutboundLineCount',
            'max_line_utilization': 'maxLineUtilization',
            'available_outbound_lines': 'availableOutboundLines',
            'reserved_lines': 'reservedLines',
            'campaigns_with_reserved_lines': 'campaignsWithReservedLines',
            'campaigns_with_dynamically_allocated_lines': 'campaignsWithDynamicallyAllocatedLines'
        }

        self._campaign = None
        self._max_outbound_line_count = None
        self._max_line_utilization = None
        self._available_outbound_lines = None
        self._reserved_lines = None
        self._campaigns_with_reserved_lines = None
        self._campaigns_with_dynamically_allocated_lines = None

    @property
    def campaign(self) -> 'AddressableEntityRef':
        """
        Gets the campaign of this CampaignOutboundLinesDistribution.
        The Campaign for which dialing group distribution information was requested

        :return: The campaign of this CampaignOutboundLinesDistribution.
        :rtype: AddressableEntityRef
        """
        return self._campaign

    @campaign.setter
    def campaign(self, campaign: 'AddressableEntityRef') -> None:
        """
        Sets the campaign of this CampaignOutboundLinesDistribution.
        The Campaign for which dialing group distribution information was requested

        :param campaign: The campaign of this CampaignOutboundLinesDistribution.
        :type: AddressableEntityRef
        """
        

        self._campaign = campaign

    @property
    def max_outbound_line_count(self) -> int:
        """
        Gets the max_outbound_line_count of this CampaignOutboundLinesDistribution.
        Maximum outbound calls that can be placed for Campaign's Edge Group or Site

        :return: The max_outbound_line_count of this CampaignOutboundLinesDistribution.
        :rtype: int
        """
        return self._max_outbound_line_count

    @max_outbound_line_count.setter
    def max_outbound_line_count(self, max_outbound_line_count: int) -> None:
        """
        Sets the max_outbound_line_count of this CampaignOutboundLinesDistribution.
        Maximum outbound calls that can be placed for Campaign's Edge Group or Site

        :param max_outbound_line_count: The max_outbound_line_count of this CampaignOutboundLinesDistribution.
        :type: int
        """
        

        self._max_outbound_line_count = max_outbound_line_count

    @property
    def max_line_utilization(self) -> float:
        """
        Gets the max_line_utilization of this CampaignOutboundLinesDistribution.
        Maximum ratio of dialer calls to Campaign's Edge Group or Site capacity

        :return: The max_line_utilization of this CampaignOutboundLinesDistribution.
        :rtype: float
        """
        return self._max_line_utilization

    @max_line_utilization.setter
    def max_line_utilization(self, max_line_utilization: float) -> None:
        """
        Sets the max_line_utilization of this CampaignOutboundLinesDistribution.
        Maximum ratio of dialer calls to Campaign's Edge Group or Site capacity

        :param max_line_utilization: The max_line_utilization of this CampaignOutboundLinesDistribution.
        :type: float
        """
        

        self._max_line_utilization = max_line_utilization

    @property
    def available_outbound_lines(self) -> int:
        """
        Gets the available_outbound_lines of this CampaignOutboundLinesDistribution.
        Number of available outbound lines in Campaign's Edge Group or Site

        :return: The available_outbound_lines of this CampaignOutboundLinesDistribution.
        :rtype: int
        """
        return self._available_outbound_lines

    @available_outbound_lines.setter
    def available_outbound_lines(self, available_outbound_lines: int) -> None:
        """
        Sets the available_outbound_lines of this CampaignOutboundLinesDistribution.
        Number of available outbound lines in Campaign's Edge Group or Site

        :param available_outbound_lines: The available_outbound_lines of this CampaignOutboundLinesDistribution.
        :type: int
        """
        

        self._available_outbound_lines = available_outbound_lines

    @property
    def reserved_lines(self) -> int:
        """
        Gets the reserved_lines of this CampaignOutboundLinesDistribution.
        Number of reserved outbound lines in Campaign's Edge Group or Site

        :return: The reserved_lines of this CampaignOutboundLinesDistribution.
        :rtype: int
        """
        return self._reserved_lines

    @reserved_lines.setter
    def reserved_lines(self, reserved_lines: int) -> None:
        """
        Sets the reserved_lines of this CampaignOutboundLinesDistribution.
        Number of reserved outbound lines in Campaign's Edge Group or Site

        :param reserved_lines: The reserved_lines of this CampaignOutboundLinesDistribution.
        :type: int
        """
        

        self._reserved_lines = reserved_lines

    @property
    def campaigns_with_reserved_lines(self) -> List['CampaignOutboundLinesReservation']:
        """
        Gets the campaigns_with_reserved_lines of this CampaignOutboundLinesDistribution.
        Information about campaigns with reserving lines in Campaign's Edge Group or Site

        :return: The campaigns_with_reserved_lines of this CampaignOutboundLinesDistribution.
        :rtype: list[CampaignOutboundLinesReservation]
        """
        return self._campaigns_with_reserved_lines

    @campaigns_with_reserved_lines.setter
    def campaigns_with_reserved_lines(self, campaigns_with_reserved_lines: List['CampaignOutboundLinesReservation']) -> None:
        """
        Sets the campaigns_with_reserved_lines of this CampaignOutboundLinesDistribution.
        Information about campaigns with reserving lines in Campaign's Edge Group or Site

        :param campaigns_with_reserved_lines: The campaigns_with_reserved_lines of this CampaignOutboundLinesDistribution.
        :type: list[CampaignOutboundLinesReservation]
        """
        

        self._campaigns_with_reserved_lines = campaigns_with_reserved_lines

    @property
    def campaigns_with_dynamically_allocated_lines(self) -> List['CampaignOutboundLinesAllocation']:
        """
        Gets the campaigns_with_dynamically_allocated_lines of this CampaignOutboundLinesDistribution.
        Information about campaigns using dynamic lines allocation in Campaign's Edge Group or Site

        :return: The campaigns_with_dynamically_allocated_lines of this CampaignOutboundLinesDistribution.
        :rtype: list[CampaignOutboundLinesAllocation]
        """
        return self._campaigns_with_dynamically_allocated_lines

    @campaigns_with_dynamically_allocated_lines.setter
    def campaigns_with_dynamically_allocated_lines(self, campaigns_with_dynamically_allocated_lines: List['CampaignOutboundLinesAllocation']) -> None:
        """
        Sets the campaigns_with_dynamically_allocated_lines of this CampaignOutboundLinesDistribution.
        Information about campaigns using dynamic lines allocation in Campaign's Edge Group or Site

        :param campaigns_with_dynamically_allocated_lines: The campaigns_with_dynamically_allocated_lines of this CampaignOutboundLinesDistribution.
        :type: list[CampaignOutboundLinesAllocation]
        """
        

        self._campaigns_with_dynamically_allocated_lines = campaigns_with_dynamically_allocated_lines

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

