# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class CachedMediaItem(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CachedMediaItem - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'url': 'str',
            'download_url': 'str',
            'media_type': 'str',
            'content_length_bytes': 'int',
            'date_created': 'datetime',
            'date_expires': 'datetime',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'url': 'url',
            'download_url': 'downloadUrl',
            'media_type': 'mediaType',
            'content_length_bytes': 'contentLengthBytes',
            'date_created': 'dateCreated',
            'date_expires': 'dateExpires',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._url = None
        self._download_url = None
        self._media_type = None
        self._content_length_bytes = None
        self._date_created = None
        self._date_expires = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this CachedMediaItem.
        The unique identifier for the cached media.

        :return: The id of this CachedMediaItem.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this CachedMediaItem.
        The unique identifier for the cached media.

        :param id: The id of this CachedMediaItem.
        :type: str
        """
        

        self._id = id

    @property
    def url(self) -> str:
        """
        Gets the url of this CachedMediaItem.
        The URL that represents the external media that has been cached

        :return: The url of this CachedMediaItem.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url: str) -> None:
        """
        Sets the url of this CachedMediaItem.
        The URL that represents the external media that has been cached

        :param url: The url of this CachedMediaItem.
        :type: str
        """
        

        self._url = url

    @property
    def download_url(self) -> str:
        """
        Gets the download_url of this CachedMediaItem.
        A URL to fetch the cached media

        :return: The download_url of this CachedMediaItem.
        :rtype: str
        """
        return self._download_url

    @download_url.setter
    def download_url(self, download_url: str) -> None:
        """
        Sets the download_url of this CachedMediaItem.
        A URL to fetch the cached media

        :param download_url: The download_url of this CachedMediaItem.
        :type: str
        """
        

        self._download_url = download_url

    @property
    def media_type(self) -> str:
        """
        Gets the media_type of this CachedMediaItem.
        The media type for the URL

        :return: The media_type of this CachedMediaItem.
        :rtype: str
        """
        return self._media_type

    @media_type.setter
    def media_type(self, media_type: str) -> None:
        """
        Sets the media_type of this CachedMediaItem.
        The media type for the URL

        :param media_type: The media_type of this CachedMediaItem.
        :type: str
        """
        

        self._media_type = media_type

    @property
    def content_length_bytes(self) -> int:
        """
        Gets the content_length_bytes of this CachedMediaItem.
        The content length of the media represented by the URL, in bytes.

        :return: The content_length_bytes of this CachedMediaItem.
        :rtype: int
        """
        return self._content_length_bytes

    @content_length_bytes.setter
    def content_length_bytes(self, content_length_bytes: int) -> None:
        """
        Sets the content_length_bytes of this CachedMediaItem.
        The content length of the media represented by the URL, in bytes.

        :param content_length_bytes: The content_length_bytes of this CachedMediaItem.
        :type: int
        """
        

        self._content_length_bytes = content_length_bytes

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this CachedMediaItem.
        The date the cached item was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this CachedMediaItem.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this CachedMediaItem.
        The date the cached item was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this CachedMediaItem.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_expires(self) -> datetime:
        """
        Gets the date_expires of this CachedMediaItem.
        The date the cached item expires and will be removed from the cache. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_expires of this CachedMediaItem.
        :rtype: datetime
        """
        return self._date_expires

    @date_expires.setter
    def date_expires(self, date_expires: datetime) -> None:
        """
        Sets the date_expires of this CachedMediaItem.
        The date the cached item expires and will be removed from the cache. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_expires: The date_expires of this CachedMediaItem.
        :type: datetime
        """
        

        self._date_expires = date_expires

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this CachedMediaItem.
        The URI for this object

        :return: The self_uri of this CachedMediaItem.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this CachedMediaItem.
        The URI for this object

        :param self_uri: The self_uri of this CachedMediaItem.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

