# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class BulkJob(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        BulkJob - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'state': 'str',
            'action': 'str',
            'total_count': 'int',
            'successful_count': 'int',
            'failed_count': 'int',
            'date_started': 'datetime',
            'date_finished': 'datetime',
            'date_modified': 'datetime',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'state': 'state',
            'action': 'action',
            'total_count': 'totalCount',
            'successful_count': 'successfulCount',
            'failed_count': 'failedCount',
            'date_started': 'dateStarted',
            'date_finished': 'dateFinished',
            'date_modified': 'dateModified',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._state = None
        self._action = None
        self._total_count = None
        self._successful_count = None
        self._failed_count = None
        self._date_started = None
        self._date_finished = None
        self._date_modified = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this BulkJob.
        The globally unique identifier for the object.

        :return: The id of this BulkJob.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this BulkJob.
        The globally unique identifier for the object.

        :param id: The id of this BulkJob.
        :type: str
        """
        

        self._id = id

    @property
    def state(self) -> str:
        """
        Gets the state of this BulkJob.
        The bulk job state.

        :return: The state of this BulkJob.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this BulkJob.
        The bulk job state.

        :param state: The state of this BulkJob.
        :type: str
        """
        if isinstance(state, int):
            state = str(state)
        allowed_values = ["Idle", "Queued", "Running", "Succeeded", "Failed", "Cancelled", "Terminated"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def action(self) -> str:
        """
        Gets the action of this BulkJob.
        The bulk job action. This determines what the bulk job does, for example, terminate workitems.

        :return: The action of this BulkJob.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action: str) -> None:
        """
        Sets the action of this BulkJob.
        The bulk job action. This determines what the bulk job does, for example, terminate workitems.

        :param action: The action of this BulkJob.
        :type: str
        """
        if isinstance(action, int):
            action = str(action)
        allowed_values = ["TerminateWorkitems", "AddWorkitems"]
        if action.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for action -> " + action)
            self._action = "outdated_sdk_version"
        else:
            self._action = action

    @property
    def total_count(self) -> int:
        """
        Gets the total_count of this BulkJob.
        Total count of items to be processed in the bulk job.

        :return: The total_count of this BulkJob.
        :rtype: int
        """
        return self._total_count

    @total_count.setter
    def total_count(self, total_count: int) -> None:
        """
        Sets the total_count of this BulkJob.
        Total count of items to be processed in the bulk job.

        :param total_count: The total_count of this BulkJob.
        :type: int
        """
        

        self._total_count = total_count

    @property
    def successful_count(self) -> int:
        """
        Gets the successful_count of this BulkJob.
        Count of successfully processed items in the bulk job.

        :return: The successful_count of this BulkJob.
        :rtype: int
        """
        return self._successful_count

    @successful_count.setter
    def successful_count(self, successful_count: int) -> None:
        """
        Sets the successful_count of this BulkJob.
        Count of successfully processed items in the bulk job.

        :param successful_count: The successful_count of this BulkJob.
        :type: int
        """
        

        self._successful_count = successful_count

    @property
    def failed_count(self) -> int:
        """
        Gets the failed_count of this BulkJob.
        Count of failed processed items in the bulk job.

        :return: The failed_count of this BulkJob.
        :rtype: int
        """
        return self._failed_count

    @failed_count.setter
    def failed_count(self, failed_count: int) -> None:
        """
        Sets the failed_count of this BulkJob.
        Count of failed processed items in the bulk job.

        :param failed_count: The failed_count of this BulkJob.
        :type: int
        """
        

        self._failed_count = failed_count

    @property
    def date_started(self) -> datetime:
        """
        Gets the date_started of this BulkJob.
        The bulk job start date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_started of this BulkJob.
        :rtype: datetime
        """
        return self._date_started

    @date_started.setter
    def date_started(self, date_started: datetime) -> None:
        """
        Sets the date_started of this BulkJob.
        The bulk job start date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_started: The date_started of this BulkJob.
        :type: datetime
        """
        

        self._date_started = date_started

    @property
    def date_finished(self) -> datetime:
        """
        Gets the date_finished of this BulkJob.
        The bulk job finished date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_finished of this BulkJob.
        :rtype: datetime
        """
        return self._date_finished

    @date_finished.setter
    def date_finished(self, date_finished: datetime) -> None:
        """
        Sets the date_finished of this BulkJob.
        The bulk job finished date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_finished: The date_finished of this BulkJob.
        :type: datetime
        """
        

        self._date_finished = date_finished

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this BulkJob.
        The bulk job modification date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this BulkJob.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this BulkJob.
        The bulk job modification date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this BulkJob.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this BulkJob.
        The URI for this object

        :return: The self_uri of this BulkJob.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this BulkJob.
        The URI for this object

        :param self_uri: The self_uri of this BulkJob.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

