# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import BulkErrorDetail
    from . import Relationship

class BulkEntityErrorRelationship(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        BulkEntityErrorRelationship - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'code': 'str',
            'message': 'str',
            'status': 'int',
            'retryable': 'bool',
            'details': 'list[BulkErrorDetail]',
            'entity': 'Relationship'
        }

        self.attribute_map = {
            'code': 'code',
            'message': 'message',
            'status': 'status',
            'retryable': 'retryable',
            'details': 'details',
            'entity': 'entity'
        }

        self._code = None
        self._message = None
        self._status = None
        self._retryable = None
        self._details = None
        self._entity = None

    @property
    def code(self) -> str:
        """
        Gets the code of this BulkEntityErrorRelationship.
        An error code for the specific error condition.

        :return: The code of this BulkEntityErrorRelationship.
        :rtype: str
        """
        return self._code

    @code.setter
    def code(self, code: str) -> None:
        """
        Sets the code of this BulkEntityErrorRelationship.
        An error code for the specific error condition.

        :param code: The code of this BulkEntityErrorRelationship.
        :type: str
        """
        

        self._code = code

    @property
    def message(self) -> str:
        """
        Gets the message of this BulkEntityErrorRelationship.
        A short error message.

        :return: The message of this BulkEntityErrorRelationship.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message: str) -> None:
        """
        Sets the message of this BulkEntityErrorRelationship.
        A short error message.

        :param message: The message of this BulkEntityErrorRelationship.
        :type: str
        """
        

        self._message = message

    @property
    def status(self) -> int:
        """
        Gets the status of this BulkEntityErrorRelationship.
        The HTTP Status Code for the error.

        :return: The status of this BulkEntityErrorRelationship.
        :rtype: int
        """
        return self._status

    @status.setter
    def status(self, status: int) -> None:
        """
        Sets the status of this BulkEntityErrorRelationship.
        The HTTP Status Code for the error.

        :param status: The status of this BulkEntityErrorRelationship.
        :type: int
        """
        

        self._status = status

    @property
    def retryable(self) -> bool:
        """
        Gets the retryable of this BulkEntityErrorRelationship.
        Whether this particular error should be retried.

        :return: The retryable of this BulkEntityErrorRelationship.
        :rtype: bool
        """
        return self._retryable

    @retryable.setter
    def retryable(self, retryable: bool) -> None:
        """
        Sets the retryable of this BulkEntityErrorRelationship.
        Whether this particular error should be retried.

        :param retryable: The retryable of this BulkEntityErrorRelationship.
        :type: bool
        """
        

        self._retryable = retryable

    @property
    def details(self) -> List['BulkErrorDetail']:
        """
        Gets the details of this BulkEntityErrorRelationship.
        Additional error details for specific fields.

        :return: The details of this BulkEntityErrorRelationship.
        :rtype: list[BulkErrorDetail]
        """
        return self._details

    @details.setter
    def details(self, details: List['BulkErrorDetail']) -> None:
        """
        Sets the details of this BulkEntityErrorRelationship.
        Additional error details for specific fields.

        :param details: The details of this BulkEntityErrorRelationship.
        :type: list[BulkErrorDetail]
        """
        

        self._details = details

    @property
    def entity(self) -> 'Relationship':
        """
        Gets the entity of this BulkEntityErrorRelationship.
        The entity body specified in the Bulk request operation that caused this error.

        :return: The entity of this BulkEntityErrorRelationship.
        :rtype: Relationship
        """
        return self._entity

    @entity.setter
    def entity(self, entity: 'Relationship') -> None:
        """
        Sets the entity of this BulkEntityErrorRelationship.
        The entity body specified in the Bulk request operation that caused this error.

        :param entity: The entity of this BulkEntityErrorRelationship.
        :type: Relationship
        """
        

        self._entity = entity

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

