# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import BuTimeOffLimitReference
    from . import HrisTimeOffType
    from . import TimeOffPlanBusinessUnitAssociation
    from . import TimeOffPlanManagementUnitAssociation
    from . import WfmVersionedEntityMetadata

class BuTimeOffPlanResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        BuTimeOffPlanResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'activity_code_ids': 'list[str]',
            'time_off_limits': 'list[BuTimeOffLimitReference]',
            'auto_approval_rule': 'str',
            'days_before_start_to_expire_from_waitlist': 'int',
            'hris_time_off_type': 'HrisTimeOffType',
            'enabled': 'bool',
            'count_against_time_off_limits': 'bool',
            'business_unit_association': 'TimeOffPlanBusinessUnitAssociation',
            'management_unit_association': 'TimeOffPlanManagementUnitAssociation',
            'metadata': 'WfmVersionedEntityMetadata',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'activity_code_ids': 'activityCodeIds',
            'time_off_limits': 'timeOffLimits',
            'auto_approval_rule': 'autoApprovalRule',
            'days_before_start_to_expire_from_waitlist': 'daysBeforeStartToExpireFromWaitlist',
            'hris_time_off_type': 'hrisTimeOffType',
            'enabled': 'enabled',
            'count_against_time_off_limits': 'countAgainstTimeOffLimits',
            'business_unit_association': 'businessUnitAssociation',
            'management_unit_association': 'managementUnitAssociation',
            'metadata': 'metadata',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._activity_code_ids = None
        self._time_off_limits = None
        self._auto_approval_rule = None
        self._days_before_start_to_expire_from_waitlist = None
        self._hris_time_off_type = None
        self._enabled = None
        self._count_against_time_off_limits = None
        self._business_unit_association = None
        self._management_unit_association = None
        self._metadata = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this BuTimeOffPlanResponse.
        The globally unique identifier for the object.

        :return: The id of this BuTimeOffPlanResponse.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this BuTimeOffPlanResponse.
        The globally unique identifier for the object.

        :param id: The id of this BuTimeOffPlanResponse.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this BuTimeOffPlanResponse.
        The name of this time-off plan

        :return: The name of this BuTimeOffPlanResponse.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this BuTimeOffPlanResponse.
        The name of this time-off plan

        :param name: The name of this BuTimeOffPlanResponse.
        :type: str
        """
        

        self._name = name

    @property
    def activity_code_ids(self) -> List[str]:
        """
        Gets the activity_code_ids of this BuTimeOffPlanResponse.
        The IDs of activity codes associated with this time-off plan

        :return: The activity_code_ids of this BuTimeOffPlanResponse.
        :rtype: list[str]
        """
        return self._activity_code_ids

    @activity_code_ids.setter
    def activity_code_ids(self, activity_code_ids: List[str]) -> None:
        """
        Sets the activity_code_ids of this BuTimeOffPlanResponse.
        The IDs of activity codes associated with this time-off plan

        :param activity_code_ids: The activity_code_ids of this BuTimeOffPlanResponse.
        :type: list[str]
        """
        

        self._activity_code_ids = activity_code_ids

    @property
    def time_off_limits(self) -> List['BuTimeOffLimitReference']:
        """
        Gets the time_off_limits of this BuTimeOffPlanResponse.
        The IDs of time-off limits associated with this time-off plan

        :return: The time_off_limits of this BuTimeOffPlanResponse.
        :rtype: list[BuTimeOffLimitReference]
        """
        return self._time_off_limits

    @time_off_limits.setter
    def time_off_limits(self, time_off_limits: List['BuTimeOffLimitReference']) -> None:
        """
        Sets the time_off_limits of this BuTimeOffPlanResponse.
        The IDs of time-off limits associated with this time-off plan

        :param time_off_limits: The time_off_limits of this BuTimeOffPlanResponse.
        :type: list[BuTimeOffLimitReference]
        """
        

        self._time_off_limits = time_off_limits

    @property
    def auto_approval_rule(self) -> str:
        """
        Gets the auto_approval_rule of this BuTimeOffPlanResponse.
        Auto approval rule for this time-off plan

        :return: The auto_approval_rule of this BuTimeOffPlanResponse.
        :rtype: str
        """
        return self._auto_approval_rule

    @auto_approval_rule.setter
    def auto_approval_rule(self, auto_approval_rule: str) -> None:
        """
        Sets the auto_approval_rule of this BuTimeOffPlanResponse.
        Auto approval rule for this time-off plan

        :param auto_approval_rule: The auto_approval_rule of this BuTimeOffPlanResponse.
        :type: str
        """
        if isinstance(auto_approval_rule, int):
            auto_approval_rule = str(auto_approval_rule)
        allowed_values = ["Never", "Always", "CheckLimits", "CheckActivityCodes", "CheckLimitsAndActivityCodes"]
        if auto_approval_rule.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for auto_approval_rule -> " + auto_approval_rule)
            self._auto_approval_rule = "outdated_sdk_version"
        else:
            self._auto_approval_rule = auto_approval_rule

    @property
    def days_before_start_to_expire_from_waitlist(self) -> int:
        """
        Gets the days_before_start_to_expire_from_waitlist of this BuTimeOffPlanResponse.
        The number of days before the time-off request start date for when the request will be expired from the waitlist

        :return: The days_before_start_to_expire_from_waitlist of this BuTimeOffPlanResponse.
        :rtype: int
        """
        return self._days_before_start_to_expire_from_waitlist

    @days_before_start_to_expire_from_waitlist.setter
    def days_before_start_to_expire_from_waitlist(self, days_before_start_to_expire_from_waitlist: int) -> None:
        """
        Sets the days_before_start_to_expire_from_waitlist of this BuTimeOffPlanResponse.
        The number of days before the time-off request start date for when the request will be expired from the waitlist

        :param days_before_start_to_expire_from_waitlist: The days_before_start_to_expire_from_waitlist of this BuTimeOffPlanResponse.
        :type: int
        """
        

        self._days_before_start_to_expire_from_waitlist = days_before_start_to_expire_from_waitlist

    @property
    def hris_time_off_type(self) -> 'HrisTimeOffType':
        """
        Gets the hris_time_off_type of this BuTimeOffPlanResponse.
        Time-off type, if this time-off plan is associated with the integration

        :return: The hris_time_off_type of this BuTimeOffPlanResponse.
        :rtype: HrisTimeOffType
        """
        return self._hris_time_off_type

    @hris_time_off_type.setter
    def hris_time_off_type(self, hris_time_off_type: 'HrisTimeOffType') -> None:
        """
        Sets the hris_time_off_type of this BuTimeOffPlanResponse.
        Time-off type, if this time-off plan is associated with the integration

        :param hris_time_off_type: The hris_time_off_type of this BuTimeOffPlanResponse.
        :type: HrisTimeOffType
        """
        

        self._hris_time_off_type = hris_time_off_type

    @property
    def enabled(self) -> bool:
        """
        Gets the enabled of this BuTimeOffPlanResponse.
        Whether this time-off plan is currently being used by agents

        :return: The enabled of this BuTimeOffPlanResponse.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled: bool) -> None:
        """
        Sets the enabled of this BuTimeOffPlanResponse.
        Whether this time-off plan is currently being used by agents

        :param enabled: The enabled of this BuTimeOffPlanResponse.
        :type: bool
        """
        

        self._enabled = enabled

    @property
    def count_against_time_off_limits(self) -> bool:
        """
        Gets the count_against_time_off_limits of this BuTimeOffPlanResponse.
        Whether this time-off plan counts against time-off limits

        :return: The count_against_time_off_limits of this BuTimeOffPlanResponse.
        :rtype: bool
        """
        return self._count_against_time_off_limits

    @count_against_time_off_limits.setter
    def count_against_time_off_limits(self, count_against_time_off_limits: bool) -> None:
        """
        Sets the count_against_time_off_limits of this BuTimeOffPlanResponse.
        Whether this time-off plan counts against time-off limits

        :param count_against_time_off_limits: The count_against_time_off_limits of this BuTimeOffPlanResponse.
        :type: bool
        """
        

        self._count_against_time_off_limits = count_against_time_off_limits

    @property
    def business_unit_association(self) -> 'TimeOffPlanBusinessUnitAssociation':
        """
        Gets the business_unit_association of this BuTimeOffPlanResponse.
        Business unit association, if the time-off plan belongs to a business unit. managementUnitAssociation must not be set if this is populated

        :return: The business_unit_association of this BuTimeOffPlanResponse.
        :rtype: TimeOffPlanBusinessUnitAssociation
        """
        return self._business_unit_association

    @business_unit_association.setter
    def business_unit_association(self, business_unit_association: 'TimeOffPlanBusinessUnitAssociation') -> None:
        """
        Sets the business_unit_association of this BuTimeOffPlanResponse.
        Business unit association, if the time-off plan belongs to a business unit. managementUnitAssociation must not be set if this is populated

        :param business_unit_association: The business_unit_association of this BuTimeOffPlanResponse.
        :type: TimeOffPlanBusinessUnitAssociation
        """
        

        self._business_unit_association = business_unit_association

    @property
    def management_unit_association(self) -> 'TimeOffPlanManagementUnitAssociation':
        """
        Gets the management_unit_association of this BuTimeOffPlanResponse.
        Management Unit association, if the time-off plan belongs to a management unit. businessUnitAssociation must not be set if this is populated

        :return: The management_unit_association of this BuTimeOffPlanResponse.
        :rtype: TimeOffPlanManagementUnitAssociation
        """
        return self._management_unit_association

    @management_unit_association.setter
    def management_unit_association(self, management_unit_association: 'TimeOffPlanManagementUnitAssociation') -> None:
        """
        Sets the management_unit_association of this BuTimeOffPlanResponse.
        Management Unit association, if the time-off plan belongs to a management unit. businessUnitAssociation must not be set if this is populated

        :param management_unit_association: The management_unit_association of this BuTimeOffPlanResponse.
        :type: TimeOffPlanManagementUnitAssociation
        """
        

        self._management_unit_association = management_unit_association

    @property
    def metadata(self) -> 'WfmVersionedEntityMetadata':
        """
        Gets the metadata of this BuTimeOffPlanResponse.
        Version metadata for the time-off plan

        :return: The metadata of this BuTimeOffPlanResponse.
        :rtype: WfmVersionedEntityMetadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata: 'WfmVersionedEntityMetadata') -> None:
        """
        Sets the metadata of this BuTimeOffPlanResponse.
        Version metadata for the time-off plan

        :param metadata: The metadata of this BuTimeOffPlanResponse.
        :type: WfmVersionedEntityMetadata
        """
        

        self._metadata = metadata

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this BuTimeOffPlanResponse.
        The URI for this object

        :return: The self_uri of this BuTimeOffPlanResponse.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this BuTimeOffPlanResponse.
        The URI for this object

        :param self_uri: The self_uri of this BuTimeOffPlanResponse.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

