# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class BuCreateTimeOffLimitRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        BuCreateTimeOffLimitRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'staffing_group_id': 'str',
            'management_unit_id': 'str'
        }

        self.attribute_map = {
            'staffing_group_id': 'staffingGroupId',
            'management_unit_id': 'managementUnitId'
        }

        self._staffing_group_id = None
        self._management_unit_id = None

    @property
    def staffing_group_id(self) -> str:
        """
        Gets the staffing_group_id of this BuCreateTimeOffLimitRequest.
        The ID of the staffing group to which this time-off limit is associated. It can be either management unit or business unit level staffing group. One of managementUnitId or staffingGroupId must be set. This must not be set if managementUnitId has value

        :return: The staffing_group_id of this BuCreateTimeOffLimitRequest.
        :rtype: str
        """
        return self._staffing_group_id

    @staffing_group_id.setter
    def staffing_group_id(self, staffing_group_id: str) -> None:
        """
        Sets the staffing_group_id of this BuCreateTimeOffLimitRequest.
        The ID of the staffing group to which this time-off limit is associated. It can be either management unit or business unit level staffing group. One of managementUnitId or staffingGroupId must be set. This must not be set if managementUnitId has value

        :param staffing_group_id: The staffing_group_id of this BuCreateTimeOffLimitRequest.
        :type: str
        """
        

        self._staffing_group_id = staffing_group_id

    @property
    def management_unit_id(self) -> str:
        """
        Gets the management_unit_id of this BuCreateTimeOffLimitRequest.
        The ID of the management unit to which this time-off limit is associated. One of managementUnitId or staffingGroupId must be set. This must not be set if staffingGroupId has value

        :return: The management_unit_id of this BuCreateTimeOffLimitRequest.
        :rtype: str
        """
        return self._management_unit_id

    @management_unit_id.setter
    def management_unit_id(self, management_unit_id: str) -> None:
        """
        Sets the management_unit_id of this BuCreateTimeOffLimitRequest.
        The ID of the management unit to which this time-off limit is associated. One of managementUnitId or staffingGroupId must be set. This must not be set if staffingGroupId has value

        :param management_unit_id: The management_unit_id of this BuCreateTimeOffLimitRequest.
        :type: str
        """
        

        self._management_unit_id = management_unit_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

