# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AgentCountRange

class BidGroupWorkPlanRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        BidGroupWorkPlanRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'work_plan_id': 'str',
            'override_agent_count': 'int',
            'suggested_agent_count': 'int',
            'agent_count_range': 'AgentCountRange'
        }

        self.attribute_map = {
            'work_plan_id': 'workPlanId',
            'override_agent_count': 'overrideAgentCount',
            'suggested_agent_count': 'suggestedAgentCount',
            'agent_count_range': 'agentCountRange'
        }

        self._work_plan_id = None
        self._override_agent_count = None
        self._suggested_agent_count = None
        self._agent_count_range = None

    @property
    def work_plan_id(self) -> str:
        """
        Gets the work_plan_id of this BidGroupWorkPlanRequest.
        The ID of the work plan used in the bid group

        :return: The work_plan_id of this BidGroupWorkPlanRequest.
        :rtype: str
        """
        return self._work_plan_id

    @work_plan_id.setter
    def work_plan_id(self, work_plan_id: str) -> None:
        """
        Sets the work_plan_id of this BidGroupWorkPlanRequest.
        The ID of the work plan used in the bid group

        :param work_plan_id: The work_plan_id of this BidGroupWorkPlanRequest.
        :type: str
        """
        

        self._work_plan_id = work_plan_id

    @property
    def override_agent_count(self) -> int:
        """
        Gets the override_agent_count of this BidGroupWorkPlanRequest.
        The modified agent count for this work plan

        :return: The override_agent_count of this BidGroupWorkPlanRequest.
        :rtype: int
        """
        return self._override_agent_count

    @override_agent_count.setter
    def override_agent_count(self, override_agent_count: int) -> None:
        """
        Sets the override_agent_count of this BidGroupWorkPlanRequest.
        The modified agent count for this work plan

        :param override_agent_count: The override_agent_count of this BidGroupWorkPlanRequest.
        :type: int
        """
        

        self._override_agent_count = override_agent_count

    @property
    def suggested_agent_count(self) -> int:
        """
        Gets the suggested_agent_count of this BidGroupWorkPlanRequest.
        The number of agents needed for this work plan to produce the optimal schedule

        :return: The suggested_agent_count of this BidGroupWorkPlanRequest.
        :rtype: int
        """
        return self._suggested_agent_count

    @suggested_agent_count.setter
    def suggested_agent_count(self, suggested_agent_count: int) -> None:
        """
        Sets the suggested_agent_count of this BidGroupWorkPlanRequest.
        The number of agents needed for this work plan to produce the optimal schedule

        :param suggested_agent_count: The suggested_agent_count of this BidGroupWorkPlanRequest.
        :type: int
        """
        

        self._suggested_agent_count = suggested_agent_count

    @property
    def agent_count_range(self) -> 'AgentCountRange':
        """
        Gets the agent_count_range of this BidGroupWorkPlanRequest.
        The range of agent slot count per work plan. The suggested slot count must be in agent count range

        :return: The agent_count_range of this BidGroupWorkPlanRequest.
        :rtype: AgentCountRange
        """
        return self._agent_count_range

    @agent_count_range.setter
    def agent_count_range(self, agent_count_range: 'AgentCountRange') -> None:
        """
        Sets the agent_count_range of this BidGroupWorkPlanRequest.
        The range of agent slot count per work plan. The suggested slot count must be in agent count range

        :param agent_count_range: The agent_count_range of this BidGroupWorkPlanRequest.
        :type: AgentCountRange
        """
        

        self._agent_count_range = agent_count_range

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

