# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AudioUpdatedEvent
    from . import CommunicationAnsweredEvent
    from . import CommunicationDispositionAppliedEvent
    from . import CommunicationEndedEvent
    from . import ConsultTransferEvent
    from . import EmailBeginTransmittingEvent
    from . import EmailCommunicationAnsweredEvent
    from . import EmailCommunicationDispositionAppliedEvent
    from . import EmailCommunicationEndedEvent
    from . import EmailCommunicationSentMessageEvent
    from . import EmailEndTransferEvent
    from . import EmailExternalEstablishedEvent
    from . import EmailFlowEstablishedEvent
    from . import EmailHoldUpdatedEvent
    from . import EmailProgressTransferEvent
    from . import EmailRoutingEstablishedEvent
    from . import EmailRoutingTransferEvent
    from . import EmailUserEstablishedEvent
    from . import EmailUserTransferEvent
    from . import EndConsultTransferEvent
    from . import EndTransferEvent
    from . import ExternalEstablishedEvent
    from . import HoldUpdatedEvent
    from . import IvrEstablishedEvent
    from . import PhoneEstablishedEvent
    from . import PhoneTransferEvent
    from . import ProgressConsultTransferEvent
    from . import ProgressTransferEvent
    from . import RoutingEstablishedEvent
    from . import RoutingTransferEvent
    from . import UserEstablishedEvent
    from . import UserTransferEvent

class BatchConversationEventRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        BatchConversationEventRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'end_transfer_events': 'list[EndTransferEvent]',
            'phone_transfer_events': 'list[PhoneTransferEvent]',
            'progress_transfer_events': 'list[ProgressTransferEvent]',
            'routing_transfer_events': 'list[RoutingTransferEvent]',
            'user_transfer_events': 'list[UserTransferEvent]',
            'communication_answered_events': 'list[CommunicationAnsweredEvent]',
            'communication_disposition_applied_events': 'list[CommunicationDispositionAppliedEvent]',
            'hold_updated_events': 'list[HoldUpdatedEvent]',
            'external_established_events': 'list[ExternalEstablishedEvent]',
            'ivr_established_events': 'list[IvrEstablishedEvent]',
            'phone_established_events': 'list[PhoneEstablishedEvent]',
            'routing_established_events': 'list[RoutingEstablishedEvent]',
            'user_established_events': 'list[UserEstablishedEvent]',
            'audio_updated_events': 'list[AudioUpdatedEvent]',
            'communication_ended_events': 'list[CommunicationEndedEvent]',
            'consult_transfer_events': 'list[ConsultTransferEvent]',
            'progress_consult_transfer_events': 'list[ProgressConsultTransferEvent]',
            'end_consult_transfer_events': 'list[EndConsultTransferEvent]',
            'email_begin_transmitting_events': 'list[EmailBeginTransmittingEvent]',
            'email_communication_ended_events': 'list[EmailCommunicationEndedEvent]',
            'email_external_established_events': 'list[EmailExternalEstablishedEvent]',
            'email_flow_established_events': 'list[EmailFlowEstablishedEvent]',
            'email_routing_established_events': 'list[EmailRoutingEstablishedEvent]',
            'email_user_established_events': 'list[EmailUserEstablishedEvent]',
            'email_communication_answered_events': 'list[EmailCommunicationAnsweredEvent]',
            'email_communication_disposition_applied_events': 'list[EmailCommunicationDispositionAppliedEvent]',
            'email_communication_sent_message_events': 'list[EmailCommunicationSentMessageEvent]',
            'email_hold_updated_events': 'list[EmailHoldUpdatedEvent]',
            'email_end_transfer_events': 'list[EmailEndTransferEvent]',
            'email_progress_transfer_events': 'list[EmailProgressTransferEvent]',
            'email_routing_transfer_events': 'list[EmailRoutingTransferEvent]',
            'email_user_transfer_events': 'list[EmailUserTransferEvent]'
        }

        self.attribute_map = {
            'end_transfer_events': 'endTransferEvents',
            'phone_transfer_events': 'phoneTransferEvents',
            'progress_transfer_events': 'progressTransferEvents',
            'routing_transfer_events': 'routingTransferEvents',
            'user_transfer_events': 'userTransferEvents',
            'communication_answered_events': 'communicationAnsweredEvents',
            'communication_disposition_applied_events': 'communicationDispositionAppliedEvents',
            'hold_updated_events': 'holdUpdatedEvents',
            'external_established_events': 'externalEstablishedEvents',
            'ivr_established_events': 'ivrEstablishedEvents',
            'phone_established_events': 'phoneEstablishedEvents',
            'routing_established_events': 'routingEstablishedEvents',
            'user_established_events': 'userEstablishedEvents',
            'audio_updated_events': 'audioUpdatedEvents',
            'communication_ended_events': 'communicationEndedEvents',
            'consult_transfer_events': 'consultTransferEvents',
            'progress_consult_transfer_events': 'progressConsultTransferEvents',
            'end_consult_transfer_events': 'endConsultTransferEvents',
            'email_begin_transmitting_events': 'emailBeginTransmittingEvents',
            'email_communication_ended_events': 'emailCommunicationEndedEvents',
            'email_external_established_events': 'emailExternalEstablishedEvents',
            'email_flow_established_events': 'emailFlowEstablishedEvents',
            'email_routing_established_events': 'emailRoutingEstablishedEvents',
            'email_user_established_events': 'emailUserEstablishedEvents',
            'email_communication_answered_events': 'emailCommunicationAnsweredEvents',
            'email_communication_disposition_applied_events': 'emailCommunicationDispositionAppliedEvents',
            'email_communication_sent_message_events': 'emailCommunicationSentMessageEvents',
            'email_hold_updated_events': 'emailHoldUpdatedEvents',
            'email_end_transfer_events': 'emailEndTransferEvents',
            'email_progress_transfer_events': 'emailProgressTransferEvents',
            'email_routing_transfer_events': 'emailRoutingTransferEvents',
            'email_user_transfer_events': 'emailUserTransferEvents'
        }

        self._end_transfer_events = None
        self._phone_transfer_events = None
        self._progress_transfer_events = None
        self._routing_transfer_events = None
        self._user_transfer_events = None
        self._communication_answered_events = None
        self._communication_disposition_applied_events = None
        self._hold_updated_events = None
        self._external_established_events = None
        self._ivr_established_events = None
        self._phone_established_events = None
        self._routing_established_events = None
        self._user_established_events = None
        self._audio_updated_events = None
        self._communication_ended_events = None
        self._consult_transfer_events = None
        self._progress_consult_transfer_events = None
        self._end_consult_transfer_events = None
        self._email_begin_transmitting_events = None
        self._email_communication_ended_events = None
        self._email_external_established_events = None
        self._email_flow_established_events = None
        self._email_routing_established_events = None
        self._email_user_established_events = None
        self._email_communication_answered_events = None
        self._email_communication_disposition_applied_events = None
        self._email_communication_sent_message_events = None
        self._email_hold_updated_events = None
        self._email_end_transfer_events = None
        self._email_progress_transfer_events = None
        self._email_routing_transfer_events = None
        self._email_user_transfer_events = None

    @property
    def end_transfer_events(self) -> List['EndTransferEvent']:
        """
        Gets the end_transfer_events of this BatchConversationEventRequest.
        Voice - EndTransfer events for this batch

        :return: The end_transfer_events of this BatchConversationEventRequest.
        :rtype: list[EndTransferEvent]
        """
        return self._end_transfer_events

    @end_transfer_events.setter
    def end_transfer_events(self, end_transfer_events: List['EndTransferEvent']) -> None:
        """
        Sets the end_transfer_events of this BatchConversationEventRequest.
        Voice - EndTransfer events for this batch

        :param end_transfer_events: The end_transfer_events of this BatchConversationEventRequest.
        :type: list[EndTransferEvent]
        """
        

        self._end_transfer_events = end_transfer_events

    @property
    def phone_transfer_events(self) -> List['PhoneTransferEvent']:
        """
        Gets the phone_transfer_events of this BatchConversationEventRequest.
        Voice - PhoneTransfer events for this batch

        :return: The phone_transfer_events of this BatchConversationEventRequest.
        :rtype: list[PhoneTransferEvent]
        """
        return self._phone_transfer_events

    @phone_transfer_events.setter
    def phone_transfer_events(self, phone_transfer_events: List['PhoneTransferEvent']) -> None:
        """
        Sets the phone_transfer_events of this BatchConversationEventRequest.
        Voice - PhoneTransfer events for this batch

        :param phone_transfer_events: The phone_transfer_events of this BatchConversationEventRequest.
        :type: list[PhoneTransferEvent]
        """
        

        self._phone_transfer_events = phone_transfer_events

    @property
    def progress_transfer_events(self) -> List['ProgressTransferEvent']:
        """
        Gets the progress_transfer_events of this BatchConversationEventRequest.
        Voice - ProgressTransfer events for this batch

        :return: The progress_transfer_events of this BatchConversationEventRequest.
        :rtype: list[ProgressTransferEvent]
        """
        return self._progress_transfer_events

    @progress_transfer_events.setter
    def progress_transfer_events(self, progress_transfer_events: List['ProgressTransferEvent']) -> None:
        """
        Sets the progress_transfer_events of this BatchConversationEventRequest.
        Voice - ProgressTransfer events for this batch

        :param progress_transfer_events: The progress_transfer_events of this BatchConversationEventRequest.
        :type: list[ProgressTransferEvent]
        """
        

        self._progress_transfer_events = progress_transfer_events

    @property
    def routing_transfer_events(self) -> List['RoutingTransferEvent']:
        """
        Gets the routing_transfer_events of this BatchConversationEventRequest.
        Voice - RoutingTransfer events for this batch

        :return: The routing_transfer_events of this BatchConversationEventRequest.
        :rtype: list[RoutingTransferEvent]
        """
        return self._routing_transfer_events

    @routing_transfer_events.setter
    def routing_transfer_events(self, routing_transfer_events: List['RoutingTransferEvent']) -> None:
        """
        Sets the routing_transfer_events of this BatchConversationEventRequest.
        Voice - RoutingTransfer events for this batch

        :param routing_transfer_events: The routing_transfer_events of this BatchConversationEventRequest.
        :type: list[RoutingTransferEvent]
        """
        

        self._routing_transfer_events = routing_transfer_events

    @property
    def user_transfer_events(self) -> List['UserTransferEvent']:
        """
        Gets the user_transfer_events of this BatchConversationEventRequest.
        Voice - UserTransfer events for this batch

        :return: The user_transfer_events of this BatchConversationEventRequest.
        :rtype: list[UserTransferEvent]
        """
        return self._user_transfer_events

    @user_transfer_events.setter
    def user_transfer_events(self, user_transfer_events: List['UserTransferEvent']) -> None:
        """
        Sets the user_transfer_events of this BatchConversationEventRequest.
        Voice - UserTransfer events for this batch

        :param user_transfer_events: The user_transfer_events of this BatchConversationEventRequest.
        :type: list[UserTransferEvent]
        """
        

        self._user_transfer_events = user_transfer_events

    @property
    def communication_answered_events(self) -> List['CommunicationAnsweredEvent']:
        """
        Gets the communication_answered_events of this BatchConversationEventRequest.
        Voice - CommunicationAnswered events for this batch

        :return: The communication_answered_events of this BatchConversationEventRequest.
        :rtype: list[CommunicationAnsweredEvent]
        """
        return self._communication_answered_events

    @communication_answered_events.setter
    def communication_answered_events(self, communication_answered_events: List['CommunicationAnsweredEvent']) -> None:
        """
        Sets the communication_answered_events of this BatchConversationEventRequest.
        Voice - CommunicationAnswered events for this batch

        :param communication_answered_events: The communication_answered_events of this BatchConversationEventRequest.
        :type: list[CommunicationAnsweredEvent]
        """
        

        self._communication_answered_events = communication_answered_events

    @property
    def communication_disposition_applied_events(self) -> List['CommunicationDispositionAppliedEvent']:
        """
        Gets the communication_disposition_applied_events of this BatchConversationEventRequest.
        Voice - CommunicationDispositionApplied events for this batch

        :return: The communication_disposition_applied_events of this BatchConversationEventRequest.
        :rtype: list[CommunicationDispositionAppliedEvent]
        """
        return self._communication_disposition_applied_events

    @communication_disposition_applied_events.setter
    def communication_disposition_applied_events(self, communication_disposition_applied_events: List['CommunicationDispositionAppliedEvent']) -> None:
        """
        Sets the communication_disposition_applied_events of this BatchConversationEventRequest.
        Voice - CommunicationDispositionApplied events for this batch

        :param communication_disposition_applied_events: The communication_disposition_applied_events of this BatchConversationEventRequest.
        :type: list[CommunicationDispositionAppliedEvent]
        """
        

        self._communication_disposition_applied_events = communication_disposition_applied_events

    @property
    def hold_updated_events(self) -> List['HoldUpdatedEvent']:
        """
        Gets the hold_updated_events of this BatchConversationEventRequest.
        Voice - HoldUpdated events for this batch

        :return: The hold_updated_events of this BatchConversationEventRequest.
        :rtype: list[HoldUpdatedEvent]
        """
        return self._hold_updated_events

    @hold_updated_events.setter
    def hold_updated_events(self, hold_updated_events: List['HoldUpdatedEvent']) -> None:
        """
        Sets the hold_updated_events of this BatchConversationEventRequest.
        Voice - HoldUpdated events for this batch

        :param hold_updated_events: The hold_updated_events of this BatchConversationEventRequest.
        :type: list[HoldUpdatedEvent]
        """
        

        self._hold_updated_events = hold_updated_events

    @property
    def external_established_events(self) -> List['ExternalEstablishedEvent']:
        """
        Gets the external_established_events of this BatchConversationEventRequest.
        Voice - ExternalEstablished events for this batch

        :return: The external_established_events of this BatchConversationEventRequest.
        :rtype: list[ExternalEstablishedEvent]
        """
        return self._external_established_events

    @external_established_events.setter
    def external_established_events(self, external_established_events: List['ExternalEstablishedEvent']) -> None:
        """
        Sets the external_established_events of this BatchConversationEventRequest.
        Voice - ExternalEstablished events for this batch

        :param external_established_events: The external_established_events of this BatchConversationEventRequest.
        :type: list[ExternalEstablishedEvent]
        """
        

        self._external_established_events = external_established_events

    @property
    def ivr_established_events(self) -> List['IvrEstablishedEvent']:
        """
        Gets the ivr_established_events of this BatchConversationEventRequest.
        Voice - IvrEstablished events for this batch

        :return: The ivr_established_events of this BatchConversationEventRequest.
        :rtype: list[IvrEstablishedEvent]
        """
        return self._ivr_established_events

    @ivr_established_events.setter
    def ivr_established_events(self, ivr_established_events: List['IvrEstablishedEvent']) -> None:
        """
        Sets the ivr_established_events of this BatchConversationEventRequest.
        Voice - IvrEstablished events for this batch

        :param ivr_established_events: The ivr_established_events of this BatchConversationEventRequest.
        :type: list[IvrEstablishedEvent]
        """
        

        self._ivr_established_events = ivr_established_events

    @property
    def phone_established_events(self) -> List['PhoneEstablishedEvent']:
        """
        Gets the phone_established_events of this BatchConversationEventRequest.
        Voice - PhoneEstablished events for this batch

        :return: The phone_established_events of this BatchConversationEventRequest.
        :rtype: list[PhoneEstablishedEvent]
        """
        return self._phone_established_events

    @phone_established_events.setter
    def phone_established_events(self, phone_established_events: List['PhoneEstablishedEvent']) -> None:
        """
        Sets the phone_established_events of this BatchConversationEventRequest.
        Voice - PhoneEstablished events for this batch

        :param phone_established_events: The phone_established_events of this BatchConversationEventRequest.
        :type: list[PhoneEstablishedEvent]
        """
        

        self._phone_established_events = phone_established_events

    @property
    def routing_established_events(self) -> List['RoutingEstablishedEvent']:
        """
        Gets the routing_established_events of this BatchConversationEventRequest.
        Voice - RoutingEstablished events for this batch

        :return: The routing_established_events of this BatchConversationEventRequest.
        :rtype: list[RoutingEstablishedEvent]
        """
        return self._routing_established_events

    @routing_established_events.setter
    def routing_established_events(self, routing_established_events: List['RoutingEstablishedEvent']) -> None:
        """
        Sets the routing_established_events of this BatchConversationEventRequest.
        Voice - RoutingEstablished events for this batch

        :param routing_established_events: The routing_established_events of this BatchConversationEventRequest.
        :type: list[RoutingEstablishedEvent]
        """
        

        self._routing_established_events = routing_established_events

    @property
    def user_established_events(self) -> List['UserEstablishedEvent']:
        """
        Gets the user_established_events of this BatchConversationEventRequest.
        Voice - UserEstablished events for this batch

        :return: The user_established_events of this BatchConversationEventRequest.
        :rtype: list[UserEstablishedEvent]
        """
        return self._user_established_events

    @user_established_events.setter
    def user_established_events(self, user_established_events: List['UserEstablishedEvent']) -> None:
        """
        Sets the user_established_events of this BatchConversationEventRequest.
        Voice - UserEstablished events for this batch

        :param user_established_events: The user_established_events of this BatchConversationEventRequest.
        :type: list[UserEstablishedEvent]
        """
        

        self._user_established_events = user_established_events

    @property
    def audio_updated_events(self) -> List['AudioUpdatedEvent']:
        """
        Gets the audio_updated_events of this BatchConversationEventRequest.
        Voice - AudioUpdated events for this batch

        :return: The audio_updated_events of this BatchConversationEventRequest.
        :rtype: list[AudioUpdatedEvent]
        """
        return self._audio_updated_events

    @audio_updated_events.setter
    def audio_updated_events(self, audio_updated_events: List['AudioUpdatedEvent']) -> None:
        """
        Sets the audio_updated_events of this BatchConversationEventRequest.
        Voice - AudioUpdated events for this batch

        :param audio_updated_events: The audio_updated_events of this BatchConversationEventRequest.
        :type: list[AudioUpdatedEvent]
        """
        

        self._audio_updated_events = audio_updated_events

    @property
    def communication_ended_events(self) -> List['CommunicationEndedEvent']:
        """
        Gets the communication_ended_events of this BatchConversationEventRequest.
        Voice - CommunicationEnded events for this batch

        :return: The communication_ended_events of this BatchConversationEventRequest.
        :rtype: list[CommunicationEndedEvent]
        """
        return self._communication_ended_events

    @communication_ended_events.setter
    def communication_ended_events(self, communication_ended_events: List['CommunicationEndedEvent']) -> None:
        """
        Sets the communication_ended_events of this BatchConversationEventRequest.
        Voice - CommunicationEnded events for this batch

        :param communication_ended_events: The communication_ended_events of this BatchConversationEventRequest.
        :type: list[CommunicationEndedEvent]
        """
        

        self._communication_ended_events = communication_ended_events

    @property
    def consult_transfer_events(self) -> List['ConsultTransferEvent']:
        """
        Gets the consult_transfer_events of this BatchConversationEventRequest.
        Voice - ConsultTransfer events for this batch

        :return: The consult_transfer_events of this BatchConversationEventRequest.
        :rtype: list[ConsultTransferEvent]
        """
        return self._consult_transfer_events

    @consult_transfer_events.setter
    def consult_transfer_events(self, consult_transfer_events: List['ConsultTransferEvent']) -> None:
        """
        Sets the consult_transfer_events of this BatchConversationEventRequest.
        Voice - ConsultTransfer events for this batch

        :param consult_transfer_events: The consult_transfer_events of this BatchConversationEventRequest.
        :type: list[ConsultTransferEvent]
        """
        

        self._consult_transfer_events = consult_transfer_events

    @property
    def progress_consult_transfer_events(self) -> List['ProgressConsultTransferEvent']:
        """
        Gets the progress_consult_transfer_events of this BatchConversationEventRequest.
        Voice - ProgressConsultTransfer events for this batch

        :return: The progress_consult_transfer_events of this BatchConversationEventRequest.
        :rtype: list[ProgressConsultTransferEvent]
        """
        return self._progress_consult_transfer_events

    @progress_consult_transfer_events.setter
    def progress_consult_transfer_events(self, progress_consult_transfer_events: List['ProgressConsultTransferEvent']) -> None:
        """
        Sets the progress_consult_transfer_events of this BatchConversationEventRequest.
        Voice - ProgressConsultTransfer events for this batch

        :param progress_consult_transfer_events: The progress_consult_transfer_events of this BatchConversationEventRequest.
        :type: list[ProgressConsultTransferEvent]
        """
        

        self._progress_consult_transfer_events = progress_consult_transfer_events

    @property
    def end_consult_transfer_events(self) -> List['EndConsultTransferEvent']:
        """
        Gets the end_consult_transfer_events of this BatchConversationEventRequest.
        Voice - EndConsultTransfer events for this batch

        :return: The end_consult_transfer_events of this BatchConversationEventRequest.
        :rtype: list[EndConsultTransferEvent]
        """
        return self._end_consult_transfer_events

    @end_consult_transfer_events.setter
    def end_consult_transfer_events(self, end_consult_transfer_events: List['EndConsultTransferEvent']) -> None:
        """
        Sets the end_consult_transfer_events of this BatchConversationEventRequest.
        Voice - EndConsultTransfer events for this batch

        :param end_consult_transfer_events: The end_consult_transfer_events of this BatchConversationEventRequest.
        :type: list[EndConsultTransferEvent]
        """
        

        self._end_consult_transfer_events = end_consult_transfer_events

    @property
    def email_begin_transmitting_events(self) -> List['EmailBeginTransmittingEvent']:
        """
        Gets the email_begin_transmitting_events of this BatchConversationEventRequest.
        Email - EmailBeginTransmittingEvent events for this batch

        :return: The email_begin_transmitting_events of this BatchConversationEventRequest.
        :rtype: list[EmailBeginTransmittingEvent]
        """
        return self._email_begin_transmitting_events

    @email_begin_transmitting_events.setter
    def email_begin_transmitting_events(self, email_begin_transmitting_events: List['EmailBeginTransmittingEvent']) -> None:
        """
        Sets the email_begin_transmitting_events of this BatchConversationEventRequest.
        Email - EmailBeginTransmittingEvent events for this batch

        :param email_begin_transmitting_events: The email_begin_transmitting_events of this BatchConversationEventRequest.
        :type: list[EmailBeginTransmittingEvent]
        """
        

        self._email_begin_transmitting_events = email_begin_transmitting_events

    @property
    def email_communication_ended_events(self) -> List['EmailCommunicationEndedEvent']:
        """
        Gets the email_communication_ended_events of this BatchConversationEventRequest.
        Email - EmailCommunicationEndedEvent events for this batch

        :return: The email_communication_ended_events of this BatchConversationEventRequest.
        :rtype: list[EmailCommunicationEndedEvent]
        """
        return self._email_communication_ended_events

    @email_communication_ended_events.setter
    def email_communication_ended_events(self, email_communication_ended_events: List['EmailCommunicationEndedEvent']) -> None:
        """
        Sets the email_communication_ended_events of this BatchConversationEventRequest.
        Email - EmailCommunicationEndedEvent events for this batch

        :param email_communication_ended_events: The email_communication_ended_events of this BatchConversationEventRequest.
        :type: list[EmailCommunicationEndedEvent]
        """
        

        self._email_communication_ended_events = email_communication_ended_events

    @property
    def email_external_established_events(self) -> List['EmailExternalEstablishedEvent']:
        """
        Gets the email_external_established_events of this BatchConversationEventRequest.
        Email - EmailExternalEstablishedEvent events for this batch

        :return: The email_external_established_events of this BatchConversationEventRequest.
        :rtype: list[EmailExternalEstablishedEvent]
        """
        return self._email_external_established_events

    @email_external_established_events.setter
    def email_external_established_events(self, email_external_established_events: List['EmailExternalEstablishedEvent']) -> None:
        """
        Sets the email_external_established_events of this BatchConversationEventRequest.
        Email - EmailExternalEstablishedEvent events for this batch

        :param email_external_established_events: The email_external_established_events of this BatchConversationEventRequest.
        :type: list[EmailExternalEstablishedEvent]
        """
        

        self._email_external_established_events = email_external_established_events

    @property
    def email_flow_established_events(self) -> List['EmailFlowEstablishedEvent']:
        """
        Gets the email_flow_established_events of this BatchConversationEventRequest.
        Email - EmailFlowEstablishedEvent events for this batch

        :return: The email_flow_established_events of this BatchConversationEventRequest.
        :rtype: list[EmailFlowEstablishedEvent]
        """
        return self._email_flow_established_events

    @email_flow_established_events.setter
    def email_flow_established_events(self, email_flow_established_events: List['EmailFlowEstablishedEvent']) -> None:
        """
        Sets the email_flow_established_events of this BatchConversationEventRequest.
        Email - EmailFlowEstablishedEvent events for this batch

        :param email_flow_established_events: The email_flow_established_events of this BatchConversationEventRequest.
        :type: list[EmailFlowEstablishedEvent]
        """
        

        self._email_flow_established_events = email_flow_established_events

    @property
    def email_routing_established_events(self) -> List['EmailRoutingEstablishedEvent']:
        """
        Gets the email_routing_established_events of this BatchConversationEventRequest.
        Email - EmailRoutingEstablishedEvent events for this batch

        :return: The email_routing_established_events of this BatchConversationEventRequest.
        :rtype: list[EmailRoutingEstablishedEvent]
        """
        return self._email_routing_established_events

    @email_routing_established_events.setter
    def email_routing_established_events(self, email_routing_established_events: List['EmailRoutingEstablishedEvent']) -> None:
        """
        Sets the email_routing_established_events of this BatchConversationEventRequest.
        Email - EmailRoutingEstablishedEvent events for this batch

        :param email_routing_established_events: The email_routing_established_events of this BatchConversationEventRequest.
        :type: list[EmailRoutingEstablishedEvent]
        """
        

        self._email_routing_established_events = email_routing_established_events

    @property
    def email_user_established_events(self) -> List['EmailUserEstablishedEvent']:
        """
        Gets the email_user_established_events of this BatchConversationEventRequest.
        Email - EmailUserEstablishedEvent events for this batch

        :return: The email_user_established_events of this BatchConversationEventRequest.
        :rtype: list[EmailUserEstablishedEvent]
        """
        return self._email_user_established_events

    @email_user_established_events.setter
    def email_user_established_events(self, email_user_established_events: List['EmailUserEstablishedEvent']) -> None:
        """
        Sets the email_user_established_events of this BatchConversationEventRequest.
        Email - EmailUserEstablishedEvent events for this batch

        :param email_user_established_events: The email_user_established_events of this BatchConversationEventRequest.
        :type: list[EmailUserEstablishedEvent]
        """
        

        self._email_user_established_events = email_user_established_events

    @property
    def email_communication_answered_events(self) -> List['EmailCommunicationAnsweredEvent']:
        """
        Gets the email_communication_answered_events of this BatchConversationEventRequest.
        Email - EmailCommunicationAnsweredEvent events for this batch

        :return: The email_communication_answered_events of this BatchConversationEventRequest.
        :rtype: list[EmailCommunicationAnsweredEvent]
        """
        return self._email_communication_answered_events

    @email_communication_answered_events.setter
    def email_communication_answered_events(self, email_communication_answered_events: List['EmailCommunicationAnsweredEvent']) -> None:
        """
        Sets the email_communication_answered_events of this BatchConversationEventRequest.
        Email - EmailCommunicationAnsweredEvent events for this batch

        :param email_communication_answered_events: The email_communication_answered_events of this BatchConversationEventRequest.
        :type: list[EmailCommunicationAnsweredEvent]
        """
        

        self._email_communication_answered_events = email_communication_answered_events

    @property
    def email_communication_disposition_applied_events(self) -> List['EmailCommunicationDispositionAppliedEvent']:
        """
        Gets the email_communication_disposition_applied_events of this BatchConversationEventRequest.
        Email - EmailCommunicationDispositionAppliedEvent events for this batch

        :return: The email_communication_disposition_applied_events of this BatchConversationEventRequest.
        :rtype: list[EmailCommunicationDispositionAppliedEvent]
        """
        return self._email_communication_disposition_applied_events

    @email_communication_disposition_applied_events.setter
    def email_communication_disposition_applied_events(self, email_communication_disposition_applied_events: List['EmailCommunicationDispositionAppliedEvent']) -> None:
        """
        Sets the email_communication_disposition_applied_events of this BatchConversationEventRequest.
        Email - EmailCommunicationDispositionAppliedEvent events for this batch

        :param email_communication_disposition_applied_events: The email_communication_disposition_applied_events of this BatchConversationEventRequest.
        :type: list[EmailCommunicationDispositionAppliedEvent]
        """
        

        self._email_communication_disposition_applied_events = email_communication_disposition_applied_events

    @property
    def email_communication_sent_message_events(self) -> List['EmailCommunicationSentMessageEvent']:
        """
        Gets the email_communication_sent_message_events of this BatchConversationEventRequest.
        Email - EmailCommunicationSentMessageEvent events for this batch

        :return: The email_communication_sent_message_events of this BatchConversationEventRequest.
        :rtype: list[EmailCommunicationSentMessageEvent]
        """
        return self._email_communication_sent_message_events

    @email_communication_sent_message_events.setter
    def email_communication_sent_message_events(self, email_communication_sent_message_events: List['EmailCommunicationSentMessageEvent']) -> None:
        """
        Sets the email_communication_sent_message_events of this BatchConversationEventRequest.
        Email - EmailCommunicationSentMessageEvent events for this batch

        :param email_communication_sent_message_events: The email_communication_sent_message_events of this BatchConversationEventRequest.
        :type: list[EmailCommunicationSentMessageEvent]
        """
        

        self._email_communication_sent_message_events = email_communication_sent_message_events

    @property
    def email_hold_updated_events(self) -> List['EmailHoldUpdatedEvent']:
        """
        Gets the email_hold_updated_events of this BatchConversationEventRequest.
        Email - EmailHoldUpdatedEvent events for this batch

        :return: The email_hold_updated_events of this BatchConversationEventRequest.
        :rtype: list[EmailHoldUpdatedEvent]
        """
        return self._email_hold_updated_events

    @email_hold_updated_events.setter
    def email_hold_updated_events(self, email_hold_updated_events: List['EmailHoldUpdatedEvent']) -> None:
        """
        Sets the email_hold_updated_events of this BatchConversationEventRequest.
        Email - EmailHoldUpdatedEvent events for this batch

        :param email_hold_updated_events: The email_hold_updated_events of this BatchConversationEventRequest.
        :type: list[EmailHoldUpdatedEvent]
        """
        

        self._email_hold_updated_events = email_hold_updated_events

    @property
    def email_end_transfer_events(self) -> List['EmailEndTransferEvent']:
        """
        Gets the email_end_transfer_events of this BatchConversationEventRequest.
        Email - EmailEndTransferEvent events for this batch

        :return: The email_end_transfer_events of this BatchConversationEventRequest.
        :rtype: list[EmailEndTransferEvent]
        """
        return self._email_end_transfer_events

    @email_end_transfer_events.setter
    def email_end_transfer_events(self, email_end_transfer_events: List['EmailEndTransferEvent']) -> None:
        """
        Sets the email_end_transfer_events of this BatchConversationEventRequest.
        Email - EmailEndTransferEvent events for this batch

        :param email_end_transfer_events: The email_end_transfer_events of this BatchConversationEventRequest.
        :type: list[EmailEndTransferEvent]
        """
        

        self._email_end_transfer_events = email_end_transfer_events

    @property
    def email_progress_transfer_events(self) -> List['EmailProgressTransferEvent']:
        """
        Gets the email_progress_transfer_events of this BatchConversationEventRequest.
        Email - EmailProgressTransferEvent events for this batch

        :return: The email_progress_transfer_events of this BatchConversationEventRequest.
        :rtype: list[EmailProgressTransferEvent]
        """
        return self._email_progress_transfer_events

    @email_progress_transfer_events.setter
    def email_progress_transfer_events(self, email_progress_transfer_events: List['EmailProgressTransferEvent']) -> None:
        """
        Sets the email_progress_transfer_events of this BatchConversationEventRequest.
        Email - EmailProgressTransferEvent events for this batch

        :param email_progress_transfer_events: The email_progress_transfer_events of this BatchConversationEventRequest.
        :type: list[EmailProgressTransferEvent]
        """
        

        self._email_progress_transfer_events = email_progress_transfer_events

    @property
    def email_routing_transfer_events(self) -> List['EmailRoutingTransferEvent']:
        """
        Gets the email_routing_transfer_events of this BatchConversationEventRequest.
        Email - EmailRoutingTransferEvent events for this batch

        :return: The email_routing_transfer_events of this BatchConversationEventRequest.
        :rtype: list[EmailRoutingTransferEvent]
        """
        return self._email_routing_transfer_events

    @email_routing_transfer_events.setter
    def email_routing_transfer_events(self, email_routing_transfer_events: List['EmailRoutingTransferEvent']) -> None:
        """
        Sets the email_routing_transfer_events of this BatchConversationEventRequest.
        Email - EmailRoutingTransferEvent events for this batch

        :param email_routing_transfer_events: The email_routing_transfer_events of this BatchConversationEventRequest.
        :type: list[EmailRoutingTransferEvent]
        """
        

        self._email_routing_transfer_events = email_routing_transfer_events

    @property
    def email_user_transfer_events(self) -> List['EmailUserTransferEvent']:
        """
        Gets the email_user_transfer_events of this BatchConversationEventRequest.
        Email - EmailUserTransferEvent events for this batch

        :return: The email_user_transfer_events of this BatchConversationEventRequest.
        :rtype: list[EmailUserTransferEvent]
        """
        return self._email_user_transfer_events

    @email_user_transfer_events.setter
    def email_user_transfer_events(self, email_user_transfer_events: List['EmailUserTransferEvent']) -> None:
        """
        Sets the email_user_transfer_events of this BatchConversationEventRequest.
        Email - EmailUserTransferEvent events for this batch

        :param email_user_transfer_events: The email_user_transfer_events of this BatchConversationEventRequest.
        :type: list[EmailUserTransferEvent]
        """
        

        self._email_user_transfer_events = email_user_transfer_events

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

