# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import Subject
    from . import TypedAttribute

class AuthorizationPolicy(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        AuthorizationPolicy - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'target_resource': 'str',
            'subject': 'Subject',
            'effect': 'str',
            'condition': 'object',
            'description': 'str',
            'date_modified': 'datetime',
            'preset_attributes': 'dict(str, TypedAttribute)',
            'active': 'bool',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'target_resource': 'targetResource',
            'subject': 'subject',
            'effect': 'effect',
            'condition': 'condition',
            'description': 'description',
            'date_modified': 'dateModified',
            'preset_attributes': 'presetAttributes',
            'active': 'active',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._target_resource = None
        self._subject = None
        self._effect = None
        self._condition = None
        self._description = None
        self._date_modified = None
        self._preset_attributes = None
        self._active = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this AuthorizationPolicy.
        The globally unique identifier for the object.

        :return: The id of this AuthorizationPolicy.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this AuthorizationPolicy.
        The globally unique identifier for the object.

        :param id: The id of this AuthorizationPolicy.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this AuthorizationPolicy.


        :return: The name of this AuthorizationPolicy.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this AuthorizationPolicy.


        :param name: The name of this AuthorizationPolicy.
        :type: str
        """
        

        self._name = name

    @property
    def target_resource(self) -> str:
        """
        Gets the target_resource of this AuthorizationPolicy.
        The targeted resource to which the policy should apply, in the form of domain:entity:action

        :return: The target_resource of this AuthorizationPolicy.
        :rtype: str
        """
        return self._target_resource

    @target_resource.setter
    def target_resource(self, target_resource: str) -> None:
        """
        Sets the target_resource of this AuthorizationPolicy.
        The targeted resource to which the policy should apply, in the form of domain:entity:action

        :param target_resource: The target_resource of this AuthorizationPolicy.
        :type: str
        """
        

        self._target_resource = target_resource

    @property
    def subject(self) -> 'Subject':
        """
        Gets the subject of this AuthorizationPolicy.
        The subject to whom the policy will apply, including type and id

        :return: The subject of this AuthorizationPolicy.
        :rtype: Subject
        """
        return self._subject

    @subject.setter
    def subject(self, subject: 'Subject') -> None:
        """
        Sets the subject of this AuthorizationPolicy.
        The subject to whom the policy will apply, including type and id

        :param subject: The subject of this AuthorizationPolicy.
        :type: Subject
        """
        

        self._subject = subject

    @property
    def effect(self) -> str:
        """
        Gets the effect of this AuthorizationPolicy.
        The effect this policy should have when its conditions are met

        :return: The effect of this AuthorizationPolicy.
        :rtype: str
        """
        return self._effect

    @effect.setter
    def effect(self, effect: str) -> None:
        """
        Sets the effect of this AuthorizationPolicy.
        The effect this policy should have when its conditions are met

        :param effect: The effect of this AuthorizationPolicy.
        :type: str
        """
        if isinstance(effect, int):
            effect = str(effect)
        allowed_values = ["ALLOW", "DENY"]
        if effect.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for effect -> " + effect)
            self._effect = "outdated_sdk_version"
        else:
            self._effect = effect

    @property
    def condition(self) -> 'object':
        """
        Gets the condition of this AuthorizationPolicy.
        The condition tree the policy will evaluate

        :return: The condition of this AuthorizationPolicy.
        :rtype: object
        """
        return self._condition

    @condition.setter
    def condition(self, condition: 'object') -> None:
        """
        Sets the condition of this AuthorizationPolicy.
        The condition tree the policy will evaluate

        :param condition: The condition of this AuthorizationPolicy.
        :type: object
        """
        

        self._condition = condition

    @property
    def description(self) -> str:
        """
        Gets the description of this AuthorizationPolicy.


        :return: The description of this AuthorizationPolicy.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this AuthorizationPolicy.


        :param description: The description of this AuthorizationPolicy.
        :type: str
        """
        

        self._description = description

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this AuthorizationPolicy.
        Date this policy was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this AuthorizationPolicy.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this AuthorizationPolicy.
        Date this policy was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this AuthorizationPolicy.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def preset_attributes(self) -> Dict[str, 'TypedAttribute']:
        """
        Gets the preset_attributes of this AuthorizationPolicy.
        Map of names and values of preset attributes to use in policy evaluation

        :return: The preset_attributes of this AuthorizationPolicy.
        :rtype: dict(str, TypedAttribute)
        """
        return self._preset_attributes

    @preset_attributes.setter
    def preset_attributes(self, preset_attributes: Dict[str, 'TypedAttribute']) -> None:
        """
        Sets the preset_attributes of this AuthorizationPolicy.
        Map of names and values of preset attributes to use in policy evaluation

        :param preset_attributes: The preset_attributes of this AuthorizationPolicy.
        :type: dict(str, TypedAttribute)
        """
        

        self._preset_attributes = preset_attributes

    @property
    def active(self) -> bool:
        """
        Gets the active of this AuthorizationPolicy.
        Flag for active enforcement. If this value is false or null, the policy will be saved but will not be checked or enforced on users.

        :return: The active of this AuthorizationPolicy.
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active: bool) -> None:
        """
        Sets the active of this AuthorizationPolicy.
        Flag for active enforcement. If this value is false or null, the policy will be saved but will not be checked or enforced on users.

        :param active: The active of this AuthorizationPolicy.
        :type: bool
        """
        

        self._active = active

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this AuthorizationPolicy.
        The URI for this object

        :return: The self_uri of this AuthorizationPolicy.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this AuthorizationPolicy.
        The URI for this object

        :param self_uri: The self_uri of this AuthorizationPolicy.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

