# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AttributeDetailEventTopicCommunication

class AttributeDetailEventTopicAttributeUpdateEvent(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        AttributeDetailEventTopicAttributeUpdateEvent - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'event_time': 'int',
            'conversation_id': 'str',
            'participant_id': 'str',
            'attributes': 'dict(str, str)',
            'conversation_external_contact_ids': 'list[str]',
            'conversation_external_organization_ids': 'list[str]',
            'communications': 'list[AttributeDetailEventTopicCommunication]'
        }

        self.attribute_map = {
            'event_time': 'eventTime',
            'conversation_id': 'conversationId',
            'participant_id': 'participantId',
            'attributes': 'attributes',
            'conversation_external_contact_ids': 'conversationExternalContactIds',
            'conversation_external_organization_ids': 'conversationExternalOrganizationIds',
            'communications': 'communications'
        }

        self._event_time = None
        self._conversation_id = None
        self._participant_id = None
        self._attributes = None
        self._conversation_external_contact_ids = None
        self._conversation_external_organization_ids = None
        self._communications = None

    @property
    def event_time(self) -> int:
        """
        Gets the event_time of this AttributeDetailEventTopicAttributeUpdateEvent.


        :return: The event_time of this AttributeDetailEventTopicAttributeUpdateEvent.
        :rtype: int
        """
        return self._event_time

    @event_time.setter
    def event_time(self, event_time: int) -> None:
        """
        Sets the event_time of this AttributeDetailEventTopicAttributeUpdateEvent.


        :param event_time: The event_time of this AttributeDetailEventTopicAttributeUpdateEvent.
        :type: int
        """
        

        self._event_time = event_time

    @property
    def conversation_id(self) -> str:
        """
        Gets the conversation_id of this AttributeDetailEventTopicAttributeUpdateEvent.


        :return: The conversation_id of this AttributeDetailEventTopicAttributeUpdateEvent.
        :rtype: str
        """
        return self._conversation_id

    @conversation_id.setter
    def conversation_id(self, conversation_id: str) -> None:
        """
        Sets the conversation_id of this AttributeDetailEventTopicAttributeUpdateEvent.


        :param conversation_id: The conversation_id of this AttributeDetailEventTopicAttributeUpdateEvent.
        :type: str
        """
        

        self._conversation_id = conversation_id

    @property
    def participant_id(self) -> str:
        """
        Gets the participant_id of this AttributeDetailEventTopicAttributeUpdateEvent.


        :return: The participant_id of this AttributeDetailEventTopicAttributeUpdateEvent.
        :rtype: str
        """
        return self._participant_id

    @participant_id.setter
    def participant_id(self, participant_id: str) -> None:
        """
        Sets the participant_id of this AttributeDetailEventTopicAttributeUpdateEvent.


        :param participant_id: The participant_id of this AttributeDetailEventTopicAttributeUpdateEvent.
        :type: str
        """
        

        self._participant_id = participant_id

    @property
    def attributes(self) -> Dict[str, str]:
        """
        Gets the attributes of this AttributeDetailEventTopicAttributeUpdateEvent.


        :return: The attributes of this AttributeDetailEventTopicAttributeUpdateEvent.
        :rtype: dict(str, str)
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes: Dict[str, str]) -> None:
        """
        Sets the attributes of this AttributeDetailEventTopicAttributeUpdateEvent.


        :param attributes: The attributes of this AttributeDetailEventTopicAttributeUpdateEvent.
        :type: dict(str, str)
        """
        

        self._attributes = attributes

    @property
    def conversation_external_contact_ids(self) -> List[str]:
        """
        Gets the conversation_external_contact_ids of this AttributeDetailEventTopicAttributeUpdateEvent.


        :return: The conversation_external_contact_ids of this AttributeDetailEventTopicAttributeUpdateEvent.
        :rtype: list[str]
        """
        return self._conversation_external_contact_ids

    @conversation_external_contact_ids.setter
    def conversation_external_contact_ids(self, conversation_external_contact_ids: List[str]) -> None:
        """
        Sets the conversation_external_contact_ids of this AttributeDetailEventTopicAttributeUpdateEvent.


        :param conversation_external_contact_ids: The conversation_external_contact_ids of this AttributeDetailEventTopicAttributeUpdateEvent.
        :type: list[str]
        """
        

        self._conversation_external_contact_ids = conversation_external_contact_ids

    @property
    def conversation_external_organization_ids(self) -> List[str]:
        """
        Gets the conversation_external_organization_ids of this AttributeDetailEventTopicAttributeUpdateEvent.


        :return: The conversation_external_organization_ids of this AttributeDetailEventTopicAttributeUpdateEvent.
        :rtype: list[str]
        """
        return self._conversation_external_organization_ids

    @conversation_external_organization_ids.setter
    def conversation_external_organization_ids(self, conversation_external_organization_ids: List[str]) -> None:
        """
        Sets the conversation_external_organization_ids of this AttributeDetailEventTopicAttributeUpdateEvent.


        :param conversation_external_organization_ids: The conversation_external_organization_ids of this AttributeDetailEventTopicAttributeUpdateEvent.
        :type: list[str]
        """
        

        self._conversation_external_organization_ids = conversation_external_organization_ids

    @property
    def communications(self) -> List['AttributeDetailEventTopicCommunication']:
        """
        Gets the communications of this AttributeDetailEventTopicAttributeUpdateEvent.


        :return: The communications of this AttributeDetailEventTopicAttributeUpdateEvent.
        :rtype: list[AttributeDetailEventTopicCommunication]
        """
        return self._communications

    @communications.setter
    def communications(self, communications: List['AttributeDetailEventTopicCommunication']) -> None:
        """
        Sets the communications of this AttributeDetailEventTopicAttributeUpdateEvent.


        :param communications: The communications of this AttributeDetailEventTopicAttributeUpdateEvent.
        :type: list[AttributeDetailEventTopicCommunication]
        """
        

        self._communications = communications

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

