# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef
    from . import ArchitectJobMessage

class ArchitectJobStateResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ArchitectJobStateResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'flow': 'AddressableEntityRef',
            'status': 'str',
            'command': 'str',
            'messages': 'list[ArchitectJobMessage]',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'flow': 'flow',
            'status': 'status',
            'command': 'command',
            'messages': 'messages',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._flow = None
        self._status = None
        self._command = None
        self._messages = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this ArchitectJobStateResponse.
        The globally unique identifier for the object.

        :return: The id of this ArchitectJobStateResponse.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ArchitectJobStateResponse.
        The globally unique identifier for the object.

        :param id: The id of this ArchitectJobStateResponse.
        :type: str
        """
        

        self._id = id

    @property
    def flow(self) -> 'AddressableEntityRef':
        """
        Gets the flow of this ArchitectJobStateResponse.
        Flow created from the Architect Job

        :return: The flow of this ArchitectJobStateResponse.
        :rtype: AddressableEntityRef
        """
        return self._flow

    @flow.setter
    def flow(self, flow: 'AddressableEntityRef') -> None:
        """
        Sets the flow of this ArchitectJobStateResponse.
        Flow created from the Architect Job

        :param flow: The flow of this ArchitectJobStateResponse.
        :type: AddressableEntityRef
        """
        

        self._flow = flow

    @property
    def status(self) -> str:
        """
        Gets the status of this ArchitectJobStateResponse.
        Status of the Architect Job

        :return: The status of this ArchitectJobStateResponse.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this ArchitectJobStateResponse.
        Status of the Architect Job

        :param status: The status of this ArchitectJobStateResponse.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Registered", "Started", "Success", "Failure"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def command(self) -> str:
        """
        Gets the command of this ArchitectJobStateResponse.
        The command executed by the Architect Job

        :return: The command of this ArchitectJobStateResponse.
        :rtype: str
        """
        return self._command

    @command.setter
    def command(self, command: str) -> None:
        """
        Sets the command of this ArchitectJobStateResponse.
        The command executed by the Architect Job

        :param command: The command of this ArchitectJobStateResponse.
        :type: str
        """
        if isinstance(command, int):
            command = str(command)
        allowed_values = ["Publish", "Create", "Update", "Export"]
        if command.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for command -> " + command)
            self._command = "outdated_sdk_version"
        else:
            self._command = command

    @property
    def messages(self) -> List['ArchitectJobMessage']:
        """
        Gets the messages of this ArchitectJobStateResponse.
        Warnings and Errors messages of the Architect Job

        :return: The messages of this ArchitectJobStateResponse.
        :rtype: list[ArchitectJobMessage]
        """
        return self._messages

    @messages.setter
    def messages(self, messages: List['ArchitectJobMessage']) -> None:
        """
        Sets the messages of this ArchitectJobStateResponse.
        Warnings and Errors messages of the Architect Job

        :param messages: The messages of this ArchitectJobStateResponse.
        :type: list[ArchitectJobMessage]
        """
        

        self._messages = messages

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this ArchitectJobStateResponse.
        The URI for this object

        :return: The self_uri of this ArchitectJobStateResponse.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this ArchitectJobStateResponse.
        The URI for this object

        :param self_uri: The self_uri of this ArchitectJobStateResponse.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

