# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class ApprovalNamespace(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ApprovalNamespace - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'namespace': 'str',
            'status': 'str',
            'type': 'str'
        }

        self.attribute_map = {
            'namespace': 'namespace',
            'status': 'status',
            'type': 'type'
        }

        self._namespace = None
        self._status = None
        self._type = None

    @property
    def namespace(self) -> str:
        """
        Gets the namespace of this ApprovalNamespace.
        The namespace of the associated approvers.

        :return: The namespace of this ApprovalNamespace.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace: str) -> None:
        """
        Sets the namespace of this ApprovalNamespace.
        The namespace of the associated approvers.

        :param namespace: The namespace of this ApprovalNamespace.
        :type: str
        """
        if isinstance(namespace, int):
            namespace = str(namespace)
        allowed_values = ["agent.assistant", "analytics.agents", "analytics.alerting", "analytics", "analytics.realtime", "analytics.reporting.settings", "architect", "audiohook", "audit", "auth.api", "authorization", "automation.testing", "bots", "bots.voice", "business.rules", "callback", "cobrowse", "content.management", "conversation", "dataactions", "datatables", "directory", "dsar", "email", "employee.engagement", "event.orchestration", "external.contacts", "external.events.data.ingestion", "gamification", "gcv", "gdpr", "groups", "historical.adherence", "infrastructureascode", "integrations", "intent.miner", "internal.messaging", "journey", "knowledge", "language.understanding", "learning", "limit.registry", "marketplace", "media.communications", "messaging", "micro.frontend", "notifications", "onboarding", "outbound", "platform.api", "predictive.routing", "presence", "quality", "recording", "response.management", "routing", "scim", "search", "secondary.automation.testing", "skills", "social.media", "speech.and.text.analytics", "speech.integration", "supportability", "task.management", "telephony.configuration", "usage", "users", "web.deployments", "web.messaging", "webchat", "webhooks", "workforce.management.forecast", "workforce.management", "system"]
        if namespace.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for namespace -> " + namespace)
            self._namespace = "outdated_sdk_version"
        else:
            self._namespace = namespace

    @property
    def status(self) -> str:
        """
        Gets the status of this ApprovalNamespace.
        The current namespace approval status.

        :return: The status of this ApprovalNamespace.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this ApprovalNamespace.
        The current namespace approval status.

        :param status: The status of this ApprovalNamespace.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Approved", "Rejected", "Rollback", "Pending", "Open", "SecondaryApprovalNamespacesAdded", "ReviewerApproved", "ReviewerRejected", "ReviewerRollback", "ImplementingChange", "ChangeImplemented", "ImplementingRollback", "RollbackImplemented"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def type(self) -> str:
        """
        Gets the type of this ApprovalNamespace.
        The type of namespace approval.

        :return: The type of this ApprovalNamespace.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this ApprovalNamespace.
        The type of namespace approval.

        :param type: The type of this ApprovalNamespace.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["Primary", "Secondary", "System"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

