# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AnalyticsAgentStateAgentSessionResult

class AnalyticsAgentStateAgentResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        AnalyticsAgentStateAgentResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'user_id': 'str',
            'division_id': 'str',
            'user_name': 'str',
            'manager_id': 'str',
            'session_count': 'int',
            'sessions': 'list[AnalyticsAgentStateAgentSessionResult]'
        }

        self.attribute_map = {
            'user_id': 'userId',
            'division_id': 'divisionId',
            'user_name': 'userName',
            'manager_id': 'managerId',
            'session_count': 'sessionCount',
            'sessions': 'sessions'
        }

        self._user_id = None
        self._division_id = None
        self._user_name = None
        self._manager_id = None
        self._session_count = None
        self._sessions = None

    @property
    def user_id(self) -> str:
        """
        Gets the user_id of this AnalyticsAgentStateAgentResponse.
        User Id - only returned if division is covered by agentStateNames permission

        :return: The user_id of this AnalyticsAgentStateAgentResponse.
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id: str) -> None:
        """
        Sets the user_id of this AnalyticsAgentStateAgentResponse.
        User Id - only returned if division is covered by agentStateNames permission

        :param user_id: The user_id of this AnalyticsAgentStateAgentResponse.
        :type: str
        """
        

        self._user_id = user_id

    @property
    def division_id(self) -> str:
        """
        Gets the division_id of this AnalyticsAgentStateAgentResponse.
        Division Id

        :return: The division_id of this AnalyticsAgentStateAgentResponse.
        :rtype: str
        """
        return self._division_id

    @division_id.setter
    def division_id(self, division_id: str) -> None:
        """
        Sets the division_id of this AnalyticsAgentStateAgentResponse.
        Division Id

        :param division_id: The division_id of this AnalyticsAgentStateAgentResponse.
        :type: str
        """
        

        self._division_id = division_id

    @property
    def user_name(self) -> str:
        """
        Gets the user_name of this AnalyticsAgentStateAgentResponse.
        User name - only returned if division is covered by agentStateNames permission

        :return: The user_name of this AnalyticsAgentStateAgentResponse.
        :rtype: str
        """
        return self._user_name

    @user_name.setter
    def user_name(self, user_name: str) -> None:
        """
        Sets the user_name of this AnalyticsAgentStateAgentResponse.
        User name - only returned if division is covered by agentStateNames permission

        :param user_name: The user_name of this AnalyticsAgentStateAgentResponse.
        :type: str
        """
        

        self._user_name = user_name

    @property
    def manager_id(self) -> str:
        """
        Gets the manager_id of this AnalyticsAgentStateAgentResponse.
        The user that this user reports to

        :return: The manager_id of this AnalyticsAgentStateAgentResponse.
        :rtype: str
        """
        return self._manager_id

    @manager_id.setter
    def manager_id(self, manager_id: str) -> None:
        """
        Sets the manager_id of this AnalyticsAgentStateAgentResponse.
        The user that this user reports to

        :param manager_id: The manager_id of this AnalyticsAgentStateAgentResponse.
        :type: str
        """
        

        self._manager_id = manager_id

    @property
    def session_count(self) -> int:
        """
        Gets the session_count of this AnalyticsAgentStateAgentResponse.
        The count of sessions

        :return: The session_count of this AnalyticsAgentStateAgentResponse.
        :rtype: int
        """
        return self._session_count

    @session_count.setter
    def session_count(self, session_count: int) -> None:
        """
        Sets the session_count of this AnalyticsAgentStateAgentResponse.
        The count of sessions

        :param session_count: The session_count of this AnalyticsAgentStateAgentResponse.
        :type: int
        """
        

        self._session_count = session_count

    @property
    def sessions(self) -> List['AnalyticsAgentStateAgentSessionResult']:
        """
        Gets the sessions of this AnalyticsAgentStateAgentResponse.
        List of sessions

        :return: The sessions of this AnalyticsAgentStateAgentResponse.
        :rtype: list[AnalyticsAgentStateAgentSessionResult]
        """
        return self._sessions

    @sessions.setter
    def sessions(self, sessions: List['AnalyticsAgentStateAgentSessionResult']) -> None:
        """
        Sets the sessions of this AnalyticsAgentStateAgentResponse.
        List of sessions

        :param sessions: The sessions of this AnalyticsAgentStateAgentResponse.
        :type: list[AnalyticsAgentStateAgentSessionResult]
        """
        

        self._sessions = sessions

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

