# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AlternativeShiftAgentScheduledShift
    from . import AlternativeShiftScheduleLookup
    from . import ManagementUnitReference
    from . import UserReference
    from . import WfmVersionedEntityMetadata

class AlternativeShiftTradeResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        AlternativeShiftTradeResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'shift_offer_job_id': 'str',
            'existing_shifts': 'list[AlternativeShiftAgentScheduledShift]',
            'offered_shifts': 'list[AlternativeShiftAgentScheduledShift]',
            'schedule': 'AlternativeShiftScheduleLookup',
            'management_unit': 'ManagementUnitReference',
            'user': 'UserReference',
            'week_date': 'date',
            'expiration_date': 'datetime',
            'state': 'str',
            'processing_status': 'str',
            'system_date_reviewed': 'datetime',
            'admin_date_reviewed': 'datetime',
            'admin_reviewed_by': 'UserReference',
            'violations': 'list[str]',
            'metadata': 'WfmVersionedEntityMetadata',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'shift_offer_job_id': 'shiftOfferJobId',
            'existing_shifts': 'existingShifts',
            'offered_shifts': 'offeredShifts',
            'schedule': 'schedule',
            'management_unit': 'managementUnit',
            'user': 'user',
            'week_date': 'weekDate',
            'expiration_date': 'expirationDate',
            'state': 'state',
            'processing_status': 'processingStatus',
            'system_date_reviewed': 'systemDateReviewed',
            'admin_date_reviewed': 'adminDateReviewed',
            'admin_reviewed_by': 'adminReviewedBy',
            'violations': 'violations',
            'metadata': 'metadata',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._shift_offer_job_id = None
        self._existing_shifts = None
        self._offered_shifts = None
        self._schedule = None
        self._management_unit = None
        self._user = None
        self._week_date = None
        self._expiration_date = None
        self._state = None
        self._processing_status = None
        self._system_date_reviewed = None
        self._admin_date_reviewed = None
        self._admin_reviewed_by = None
        self._violations = None
        self._metadata = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this AlternativeShiftTradeResponse.
        The globally unique identifier for the object.

        :return: The id of this AlternativeShiftTradeResponse.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this AlternativeShiftTradeResponse.
        The globally unique identifier for the object.

        :param id: The id of this AlternativeShiftTradeResponse.
        :type: str
        """
        

        self._id = id

    @property
    def shift_offer_job_id(self) -> str:
        """
        Gets the shift_offer_job_id of this AlternativeShiftTradeResponse.
        The job ID of the alternative shift offer listing, from which the trade was chosen

        :return: The shift_offer_job_id of this AlternativeShiftTradeResponse.
        :rtype: str
        """
        return self._shift_offer_job_id

    @shift_offer_job_id.setter
    def shift_offer_job_id(self, shift_offer_job_id: str) -> None:
        """
        Sets the shift_offer_job_id of this AlternativeShiftTradeResponse.
        The job ID of the alternative shift offer listing, from which the trade was chosen

        :param shift_offer_job_id: The shift_offer_job_id of this AlternativeShiftTradeResponse.
        :type: str
        """
        

        self._shift_offer_job_id = shift_offer_job_id

    @property
    def existing_shifts(self) -> List['AlternativeShiftAgentScheduledShift']:
        """
        Gets the existing_shifts of this AlternativeShiftTradeResponse.
        The existing shifts from the offer, may be empty

        :return: The existing_shifts of this AlternativeShiftTradeResponse.
        :rtype: list[AlternativeShiftAgentScheduledShift]
        """
        return self._existing_shifts

    @existing_shifts.setter
    def existing_shifts(self, existing_shifts: List['AlternativeShiftAgentScheduledShift']) -> None:
        """
        Sets the existing_shifts of this AlternativeShiftTradeResponse.
        The existing shifts from the offer, may be empty

        :param existing_shifts: The existing_shifts of this AlternativeShiftTradeResponse.
        :type: list[AlternativeShiftAgentScheduledShift]
        """
        

        self._existing_shifts = existing_shifts

    @property
    def offered_shifts(self) -> List['AlternativeShiftAgentScheduledShift']:
        """
        Gets the offered_shifts of this AlternativeShiftTradeResponse.
        The offered shifts from the offer, may be empty

        :return: The offered_shifts of this AlternativeShiftTradeResponse.
        :rtype: list[AlternativeShiftAgentScheduledShift]
        """
        return self._offered_shifts

    @offered_shifts.setter
    def offered_shifts(self, offered_shifts: List['AlternativeShiftAgentScheduledShift']) -> None:
        """
        Sets the offered_shifts of this AlternativeShiftTradeResponse.
        The offered shifts from the offer, may be empty

        :param offered_shifts: The offered_shifts of this AlternativeShiftTradeResponse.
        :type: list[AlternativeShiftAgentScheduledShift]
        """
        

        self._offered_shifts = offered_shifts

    @property
    def schedule(self) -> 'AlternativeShiftScheduleLookup':
        """
        Gets the schedule of this AlternativeShiftTradeResponse.
        The existing schedule information associated with the trade

        :return: The schedule of this AlternativeShiftTradeResponse.
        :rtype: AlternativeShiftScheduleLookup
        """
        return self._schedule

    @schedule.setter
    def schedule(self, schedule: 'AlternativeShiftScheduleLookup') -> None:
        """
        Sets the schedule of this AlternativeShiftTradeResponse.
        The existing schedule information associated with the trade

        :param schedule: The schedule of this AlternativeShiftTradeResponse.
        :type: AlternativeShiftScheduleLookup
        """
        

        self._schedule = schedule

    @property
    def management_unit(self) -> 'ManagementUnitReference':
        """
        Gets the management_unit of this AlternativeShiftTradeResponse.
        The management unit of this alternative shift trade request

        :return: The management_unit of this AlternativeShiftTradeResponse.
        :rtype: ManagementUnitReference
        """
        return self._management_unit

    @management_unit.setter
    def management_unit(self, management_unit: 'ManagementUnitReference') -> None:
        """
        Sets the management_unit of this AlternativeShiftTradeResponse.
        The management unit of this alternative shift trade request

        :param management_unit: The management_unit of this AlternativeShiftTradeResponse.
        :type: ManagementUnitReference
        """
        

        self._management_unit = management_unit

    @property
    def user(self) -> 'UserReference':
        """
        Gets the user of this AlternativeShiftTradeResponse.
        The user who submitted the trade request

        :return: The user of this AlternativeShiftTradeResponse.
        :rtype: UserReference
        """
        return self._user

    @user.setter
    def user(self, user: 'UserReference') -> None:
        """
        Sets the user of this AlternativeShiftTradeResponse.
        The user who submitted the trade request

        :param user: The user of this AlternativeShiftTradeResponse.
        :type: UserReference
        """
        

        self._user = user

    @property
    def week_date(self) -> date:
        """
        Gets the week_date of this AlternativeShiftTradeResponse.
        The start week date of the associated schedule in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The week_date of this AlternativeShiftTradeResponse.
        :rtype: date
        """
        return self._week_date

    @week_date.setter
    def week_date(self, week_date: date) -> None:
        """
        Sets the week_date of this AlternativeShiftTradeResponse.
        The start week date of the associated schedule in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param week_date: The week_date of this AlternativeShiftTradeResponse.
        :type: date
        """
        

        self._week_date = week_date

    @property
    def expiration_date(self) -> datetime:
        """
        Gets the expiration_date of this AlternativeShiftTradeResponse.
        The date when the trade will expire in ISO-8601 format. The trade cannot be approved after expiration

        :return: The expiration_date of this AlternativeShiftTradeResponse.
        :rtype: datetime
        """
        return self._expiration_date

    @expiration_date.setter
    def expiration_date(self, expiration_date: datetime) -> None:
        """
        Sets the expiration_date of this AlternativeShiftTradeResponse.
        The date when the trade will expire in ISO-8601 format. The trade cannot be approved after expiration

        :param expiration_date: The expiration_date of this AlternativeShiftTradeResponse.
        :type: datetime
        """
        

        self._expiration_date = expiration_date

    @property
    def state(self) -> str:
        """
        Gets the state of this AlternativeShiftTradeResponse.
        The state of this alternative shift trade

        :return: The state of this AlternativeShiftTradeResponse.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this AlternativeShiftTradeResponse.
        The state of this alternative shift trade

        :param state: The state of this AlternativeShiftTradeResponse.
        :type: str
        """
        if isinstance(state, int):
            state = str(state)
        allowed_values = ["Canceled", "Denied", "Expired", "Submitted", "Approved"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def processing_status(self) -> str:
        """
        Gets the processing_status of this AlternativeShiftTradeResponse.
        The processing status of this alternative shift trade

        :return: The processing_status of this AlternativeShiftTradeResponse.
        :rtype: str
        """
        return self._processing_status

    @processing_status.setter
    def processing_status(self, processing_status: str) -> None:
        """
        Sets the processing_status of this AlternativeShiftTradeResponse.
        The processing status of this alternative shift trade

        :param processing_status: The processing_status of this AlternativeShiftTradeResponse.
        :type: str
        """
        if isinstance(processing_status, int):
            processing_status = str(processing_status)
        allowed_values = ["Error", "WaitingForScheduleUpdate", "ScheduleUpdating", "ScheduleUpdated", "WaitingForReview", "Reviewing"]
        if processing_status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for processing_status -> " + processing_status)
            self._processing_status = "outdated_sdk_version"
        else:
            self._processing_status = processing_status

    @property
    def system_date_reviewed(self) -> datetime:
        """
        Gets the system_date_reviewed of this AlternativeShiftTradeResponse.
        The timestamp of when the trade request was reviewed by the system in ISO-8601 format

        :return: The system_date_reviewed of this AlternativeShiftTradeResponse.
        :rtype: datetime
        """
        return self._system_date_reviewed

    @system_date_reviewed.setter
    def system_date_reviewed(self, system_date_reviewed: datetime) -> None:
        """
        Sets the system_date_reviewed of this AlternativeShiftTradeResponse.
        The timestamp of when the trade request was reviewed by the system in ISO-8601 format

        :param system_date_reviewed: The system_date_reviewed of this AlternativeShiftTradeResponse.
        :type: datetime
        """
        

        self._system_date_reviewed = system_date_reviewed

    @property
    def admin_date_reviewed(self) -> datetime:
        """
        Gets the admin_date_reviewed of this AlternativeShiftTradeResponse.
        The timestamp of when the trade request was reviewed by an admin in ISO-8601 format

        :return: The admin_date_reviewed of this AlternativeShiftTradeResponse.
        :rtype: datetime
        """
        return self._admin_date_reviewed

    @admin_date_reviewed.setter
    def admin_date_reviewed(self, admin_date_reviewed: datetime) -> None:
        """
        Sets the admin_date_reviewed of this AlternativeShiftTradeResponse.
        The timestamp of when the trade request was reviewed by an admin in ISO-8601 format

        :param admin_date_reviewed: The admin_date_reviewed of this AlternativeShiftTradeResponse.
        :type: datetime
        """
        

        self._admin_date_reviewed = admin_date_reviewed

    @property
    def admin_reviewed_by(self) -> 'UserReference':
        """
        Gets the admin_reviewed_by of this AlternativeShiftTradeResponse.
        The admin who reviewed this alternative shift trade after system denial

        :return: The admin_reviewed_by of this AlternativeShiftTradeResponse.
        :rtype: UserReference
        """
        return self._admin_reviewed_by

    @admin_reviewed_by.setter
    def admin_reviewed_by(self, admin_reviewed_by: 'UserReference') -> None:
        """
        Sets the admin_reviewed_by of this AlternativeShiftTradeResponse.
        The admin who reviewed this alternative shift trade after system denial

        :param admin_reviewed_by: The admin_reviewed_by of this AlternativeShiftTradeResponse.
        :type: UserReference
        """
        

        self._admin_reviewed_by = admin_reviewed_by

    @property
    def violations(self) -> List[str]:
        """
        Gets the violations of this AlternativeShiftTradeResponse.
        A list of trade match violations

        :return: The violations of this AlternativeShiftTradeResponse.
        :rtype: list[str]
        """
        return self._violations

    @violations.setter
    def violations(self, violations: List[str]) -> None:
        """
        Sets the violations of this AlternativeShiftTradeResponse.
        A list of trade match violations

        :param violations: The violations of this AlternativeShiftTradeResponse.
        :type: list[str]
        """
        

        self._violations = violations

    @property
    def metadata(self) -> 'WfmVersionedEntityMetadata':
        """
        Gets the metadata of this AlternativeShiftTradeResponse.
        Version metadata for this alternative shift trade

        :return: The metadata of this AlternativeShiftTradeResponse.
        :rtype: WfmVersionedEntityMetadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata: 'WfmVersionedEntityMetadata') -> None:
        """
        Sets the metadata of this AlternativeShiftTradeResponse.
        Version metadata for this alternative shift trade

        :param metadata: The metadata of this AlternativeShiftTradeResponse.
        :type: WfmVersionedEntityMetadata
        """
        

        self._metadata = metadata

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this AlternativeShiftTradeResponse.
        The URI for this object

        :return: The self_uri of this AlternativeShiftTradeResponse.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this AlternativeShiftTradeResponse.
        The URI for this object

        :param self_uri: The self_uri of this AlternativeShiftTradeResponse.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

