# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AlternativeShiftAgentScheduledShift
    from . import AlternativeShiftScheduleLookup

class AlternativeShiftOffersViewResponseTemplate(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        AlternativeShiftOffersViewResponseTemplate - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'job_id': 'str',
            'business_unit_id': 'str',
            'agent_id': 'str',
            'management_unit_id': 'str',
            'schedule': 'AlternativeShiftScheduleLookup',
            'offer_week_date': 'date',
            'shifts': 'list[AlternativeShiftAgentScheduledShift]',
            'alternative_days': 'list[AlternativeShiftAgentScheduledShift]'
        }

        self.attribute_map = {
            'job_id': 'jobId',
            'business_unit_id': 'businessUnitId',
            'agent_id': 'agentId',
            'management_unit_id': 'managementUnitId',
            'schedule': 'schedule',
            'offer_week_date': 'offerWeekDate',
            'shifts': 'shifts',
            'alternative_days': 'alternativeDays'
        }

        self._job_id = None
        self._business_unit_id = None
        self._agent_id = None
        self._management_unit_id = None
        self._schedule = None
        self._offer_week_date = None
        self._shifts = None
        self._alternative_days = None

    @property
    def job_id(self) -> str:
        """
        Gets the job_id of this AlternativeShiftOffersViewResponseTemplate.
        The unique identifier of the async list job that created this file

        :return: The job_id of this AlternativeShiftOffersViewResponseTemplate.
        :rtype: str
        """
        return self._job_id

    @job_id.setter
    def job_id(self, job_id: str) -> None:
        """
        Sets the job_id of this AlternativeShiftOffersViewResponseTemplate.
        The unique identifier of the async list job that created this file

        :param job_id: The job_id of this AlternativeShiftOffersViewResponseTemplate.
        :type: str
        """
        

        self._job_id = job_id

    @property
    def business_unit_id(self) -> str:
        """
        Gets the business_unit_id of this AlternativeShiftOffersViewResponseTemplate.
        The unique identifier of the business unit to which the user (agent) belongs at the time the offer is created

        :return: The business_unit_id of this AlternativeShiftOffersViewResponseTemplate.
        :rtype: str
        """
        return self._business_unit_id

    @business_unit_id.setter
    def business_unit_id(self, business_unit_id: str) -> None:
        """
        Sets the business_unit_id of this AlternativeShiftOffersViewResponseTemplate.
        The unique identifier of the business unit to which the user (agent) belongs at the time the offer is created

        :param business_unit_id: The business_unit_id of this AlternativeShiftOffersViewResponseTemplate.
        :type: str
        """
        

        self._business_unit_id = business_unit_id

    @property
    def agent_id(self) -> str:
        """
        Gets the agent_id of this AlternativeShiftOffersViewResponseTemplate.
        The unique identifier of the agent for whom the offer was made

        :return: The agent_id of this AlternativeShiftOffersViewResponseTemplate.
        :rtype: str
        """
        return self._agent_id

    @agent_id.setter
    def agent_id(self, agent_id: str) -> None:
        """
        Sets the agent_id of this AlternativeShiftOffersViewResponseTemplate.
        The unique identifier of the agent for whom the offer was made

        :param agent_id: The agent_id of this AlternativeShiftOffersViewResponseTemplate.
        :type: str
        """
        

        self._agent_id = agent_id

    @property
    def management_unit_id(self) -> str:
        """
        Gets the management_unit_id of this AlternativeShiftOffersViewResponseTemplate.
        The unique identifier of the management unit to which the user (agent) belongs at the time the offer is created

        :return: The management_unit_id of this AlternativeShiftOffersViewResponseTemplate.
        :rtype: str
        """
        return self._management_unit_id

    @management_unit_id.setter
    def management_unit_id(self, management_unit_id: str) -> None:
        """
        Sets the management_unit_id of this AlternativeShiftOffersViewResponseTemplate.
        The unique identifier of the management unit to which the user (agent) belongs at the time the offer is created

        :param management_unit_id: The management_unit_id of this AlternativeShiftOffersViewResponseTemplate.
        :type: str
        """
        

        self._management_unit_id = management_unit_id

    @property
    def schedule(self) -> 'AlternativeShiftScheduleLookup':
        """
        Gets the schedule of this AlternativeShiftOffersViewResponseTemplate.
        The existing schedule information associated with the offer

        :return: The schedule of this AlternativeShiftOffersViewResponseTemplate.
        :rtype: AlternativeShiftScheduleLookup
        """
        return self._schedule

    @schedule.setter
    def schedule(self, schedule: 'AlternativeShiftScheduleLookup') -> None:
        """
        Sets the schedule of this AlternativeShiftOffersViewResponseTemplate.
        The existing schedule information associated with the offer

        :param schedule: The schedule of this AlternativeShiftOffersViewResponseTemplate.
        :type: AlternativeShiftScheduleLookup
        """
        

        self._schedule = schedule

    @property
    def offer_week_date(self) -> date:
        """
        Gets the offer_week_date of this AlternativeShiftOffersViewResponseTemplate.
        The first date of the week for the schedule we are querying in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The offer_week_date of this AlternativeShiftOffersViewResponseTemplate.
        :rtype: date
        """
        return self._offer_week_date

    @offer_week_date.setter
    def offer_week_date(self, offer_week_date: date) -> None:
        """
        Sets the offer_week_date of this AlternativeShiftOffersViewResponseTemplate.
        The first date of the week for the schedule we are querying in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param offer_week_date: The offer_week_date of this AlternativeShiftOffersViewResponseTemplate.
        :type: date
        """
        

        self._offer_week_date = offer_week_date

    @property
    def shifts(self) -> List['AlternativeShiftAgentScheduledShift']:
        """
        Gets the shifts of this AlternativeShiftOffersViewResponseTemplate.
        The shifts the agent is scheduled for at the time the offer is created

        :return: The shifts of this AlternativeShiftOffersViewResponseTemplate.
        :rtype: list[AlternativeShiftAgentScheduledShift]
        """
        return self._shifts

    @shifts.setter
    def shifts(self, shifts: List['AlternativeShiftAgentScheduledShift']) -> None:
        """
        Sets the shifts of this AlternativeShiftOffersViewResponseTemplate.
        The shifts the agent is scheduled for at the time the offer is created

        :param shifts: The shifts of this AlternativeShiftOffersViewResponseTemplate.
        :type: list[AlternativeShiftAgentScheduledShift]
        """
        

        self._shifts = shifts

    @property
    def alternative_days(self) -> List['AlternativeShiftAgentScheduledShift']:
        """
        Gets the alternative_days of this AlternativeShiftOffersViewResponseTemplate.
        The offered alternative shift days in this week at the time the offer is created

        :return: The alternative_days of this AlternativeShiftOffersViewResponseTemplate.
        :rtype: list[AlternativeShiftAgentScheduledShift]
        """
        return self._alternative_days

    @alternative_days.setter
    def alternative_days(self, alternative_days: List['AlternativeShiftAgentScheduledShift']) -> None:
        """
        Sets the alternative_days of this AlternativeShiftOffersViewResponseTemplate.
        The offered alternative shift days in this week at the time the offer is created

        :param alternative_days: The alternative_days of this AlternativeShiftOffersViewResponseTemplate.
        :type: list[AlternativeShiftAgentScheduledShift]
        """
        

        self._alternative_days = alternative_days

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

