# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import BuAgentScheduleActivity

class AlternativeShiftAgentScheduledShift(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        AlternativeShiftAgentScheduledShift - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'day_index': 'int',
            'reference_key': 'str',
            'start_date': 'datetime',
            'length_minutes': 'int',
            'activities': 'list[BuAgentScheduleActivity]'
        }

        self.attribute_map = {
            'day_index': 'dayIndex',
            'reference_key': 'referenceKey',
            'start_date': 'startDate',
            'length_minutes': 'lengthMinutes',
            'activities': 'activities'
        }

        self._day_index = None
        self._reference_key = None
        self._start_date = None
        self._length_minutes = None
        self._activities = None

    @property
    def day_index(self) -> int:
        """
        Gets the day_index of this AlternativeShiftAgentScheduledShift.
        The number of days since start of schedule

        :return: The day_index of this AlternativeShiftAgentScheduledShift.
        :rtype: int
        """
        return self._day_index

    @day_index.setter
    def day_index(self, day_index: int) -> None:
        """
        Sets the day_index of this AlternativeShiftAgentScheduledShift.
        The number of days since start of schedule

        :param day_index: The day_index of this AlternativeShiftAgentScheduledShift.
        :type: int
        """
        

        self._day_index = day_index

    @property
    def reference_key(self) -> str:
        """
        Gets the reference_key of this AlternativeShiftAgentScheduledShift.
        A key generated for an offer to help facilitate alternative shift trading

        :return: The reference_key of this AlternativeShiftAgentScheduledShift.
        :rtype: str
        """
        return self._reference_key

    @reference_key.setter
    def reference_key(self, reference_key: str) -> None:
        """
        Sets the reference_key of this AlternativeShiftAgentScheduledShift.
        A key generated for an offer to help facilitate alternative shift trading

        :param reference_key: The reference_key of this AlternativeShiftAgentScheduledShift.
        :type: str
        """
        

        self._reference_key = reference_key

    @property
    def start_date(self) -> datetime:
        """
        Gets the start_date of this AlternativeShiftAgentScheduledShift.
        The start date of this shift in ISO-8601 format

        :return: The start_date of this AlternativeShiftAgentScheduledShift.
        :rtype: datetime
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date: datetime) -> None:
        """
        Sets the start_date of this AlternativeShiftAgentScheduledShift.
        The start date of this shift in ISO-8601 format

        :param start_date: The start_date of this AlternativeShiftAgentScheduledShift.
        :type: datetime
        """
        

        self._start_date = start_date

    @property
    def length_minutes(self) -> int:
        """
        Gets the length_minutes of this AlternativeShiftAgentScheduledShift.
        The length of this shift in minutes

        :return: The length_minutes of this AlternativeShiftAgentScheduledShift.
        :rtype: int
        """
        return self._length_minutes

    @length_minutes.setter
    def length_minutes(self, length_minutes: int) -> None:
        """
        Sets the length_minutes of this AlternativeShiftAgentScheduledShift.
        The length of this shift in minutes

        :param length_minutes: The length_minutes of this AlternativeShiftAgentScheduledShift.
        :type: int
        """
        

        self._length_minutes = length_minutes

    @property
    def activities(self) -> List['BuAgentScheduleActivity']:
        """
        Gets the activities of this AlternativeShiftAgentScheduledShift.
        A list of activities in this shift

        :return: The activities of this AlternativeShiftAgentScheduledShift.
        :rtype: list[BuAgentScheduleActivity]
        """
        return self._activities

    @activities.setter
    def activities(self, activities: List['BuAgentScheduleActivity']) -> None:
        """
        Sets the activities of this AlternativeShiftAgentScheduledShift.
        A list of activities in this shift

        :param activities: The activities of this AlternativeShiftAgentScheduledShift.
        :type: list[BuAgentScheduleActivity]
        """
        

        self._activities = activities

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

