# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import UnreadFields

class AlertRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        AlertRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'type': 'str',
            'date_start': 'datetime',
            'date_end': 'datetime',
            'unread': 'UnreadFields',
            'valid_request': 'bool'
        }

        self.attribute_map = {
            'type': 'type',
            'date_start': 'dateStart',
            'date_end': 'dateEnd',
            'unread': 'unread',
            'valid_request': 'validRequest'
        }

        self._type = None
        self._date_start = None
        self._date_end = None
        self._unread = None
        self._valid_request = None

    @property
    def type(self) -> str:
        """
        Gets the type of this AlertRequest.
        The action being taken on the alert.

        :return: The type of this AlertRequest.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this AlertRequest.
        The action being taken on the alert.

        :param type: The type of this AlertRequest.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["Mute", "Snooze", "Unread"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def date_start(self) -> datetime:
        """
        Gets the date_start of this AlertRequest.
        The start date of the mute/snooze period. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_start of this AlertRequest.
        :rtype: datetime
        """
        return self._date_start

    @date_start.setter
    def date_start(self, date_start: datetime) -> None:
        """
        Sets the date_start of this AlertRequest.
        The start date of the mute/snooze period. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_start: The date_start of this AlertRequest.
        :type: datetime
        """
        

        self._date_start = date_start

    @property
    def date_end(self) -> datetime:
        """
        Gets the date_end of this AlertRequest.
        The end date of the mute/snooze period. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_end of this AlertRequest.
        :rtype: datetime
        """
        return self._date_end

    @date_end.setter
    def date_end(self, date_end: datetime) -> None:
        """
        Sets the date_end of this AlertRequest.
        The end date of the mute/snooze period. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_end: The date_end of this AlertRequest.
        :type: datetime
        """
        

        self._date_end = date_end

    @property
    def unread(self) -> 'UnreadFields':
        """
        Gets the unread of this AlertRequest.
        The fields need for an unread update requests

        :return: The unread of this AlertRequest.
        :rtype: UnreadFields
        """
        return self._unread

    @unread.setter
    def unread(self, unread: 'UnreadFields') -> None:
        """
        Sets the unread of this AlertRequest.
        The fields need for an unread update requests

        :param unread: The unread of this AlertRequest.
        :type: UnreadFields
        """
        

        self._unread = unread

    @property
    def valid_request(self) -> bool:
        """
        Gets the valid_request of this AlertRequest.


        :return: The valid_request of this AlertRequest.
        :rtype: bool
        """
        return self._valid_request

    @valid_request.setter
    def valid_request(self, valid_request: bool) -> None:
        """
        Sets the valid_request of this AlertRequest.


        :param valid_request: The valid_request of this AlertRequest.
        :type: bool
        """
        

        self._valid_request = valid_request

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

