# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AgentStateSessionFilter
    from . import AgentStateUserFilter

class AgentStateQueryRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        AgentStateQueryRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'user_filter': 'AgentStateUserFilter',
            'session_filter': 'AgentStateSessionFilter',
            'user_order_by': 'str',
            'user_order': 'str',
            'session_order_by': 'str',
            'session_order': 'str'
        }

        self.attribute_map = {
            'user_filter': 'userFilter',
            'session_filter': 'sessionFilter',
            'user_order_by': 'userOrderBy',
            'user_order': 'userOrder',
            'session_order_by': 'sessionOrderBy',
            'session_order': 'sessionOrder'
        }

        self._user_filter = None
        self._session_filter = None
        self._user_order_by = None
        self._user_order = None
        self._session_order_by = None
        self._session_order = None

    @property
    def user_filter(self) -> 'AgentStateUserFilter':
        """
        Gets the user_filter of this AgentStateQueryRequest.
        Filters that target user-level data

        :return: The user_filter of this AgentStateQueryRequest.
        :rtype: AgentStateUserFilter
        """
        return self._user_filter

    @user_filter.setter
    def user_filter(self, user_filter: 'AgentStateUserFilter') -> None:
        """
        Sets the user_filter of this AgentStateQueryRequest.
        Filters that target user-level data

        :param user_filter: The user_filter of this AgentStateQueryRequest.
        :type: AgentStateUserFilter
        """
        

        self._user_filter = user_filter

    @property
    def session_filter(self) -> 'AgentStateSessionFilter':
        """
        Gets the session_filter of this AgentStateQueryRequest.
        Filters that target session-level data

        :return: The session_filter of this AgentStateQueryRequest.
        :rtype: AgentStateSessionFilter
        """
        return self._session_filter

    @session_filter.setter
    def session_filter(self, session_filter: 'AgentStateSessionFilter') -> None:
        """
        Sets the session_filter of this AgentStateQueryRequest.
        Filters that target session-level data

        :param session_filter: The session_filter of this AgentStateQueryRequest.
        :type: AgentStateSessionFilter
        """
        

        self._session_filter = session_filter

    @property
    def user_order_by(self) -> str:
        """
        Gets the user_order_by of this AgentStateQueryRequest.
        Search user order dimension names; default to userName

        :return: The user_order_by of this AgentStateQueryRequest.
        :rtype: str
        """
        return self._user_order_by

    @user_order_by.setter
    def user_order_by(self, user_order_by: str) -> None:
        """
        Sets the user_order_by of this AgentStateQueryRequest.
        Search user order dimension names; default to userName

        :param user_order_by: The user_order_by of this AgentStateQueryRequest.
        :type: str
        """
        if isinstance(user_order_by, int):
            user_order_by = str(user_order_by)
        allowed_values = ["userName", "segmentStart", "sessionStart"]
        if user_order_by.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for user_order_by -> " + user_order_by)
            self._user_order_by = "outdated_sdk_version"
        else:
            self._user_order_by = user_order_by

    @property
    def user_order(self) -> str:
        """
        Gets the user_order of this AgentStateQueryRequest.
        Search user order direction; default to asc

        :return: The user_order of this AgentStateQueryRequest.
        :rtype: str
        """
        return self._user_order

    @user_order.setter
    def user_order(self, user_order: str) -> None:
        """
        Sets the user_order of this AgentStateQueryRequest.
        Search user order direction; default to asc

        :param user_order: The user_order of this AgentStateQueryRequest.
        :type: str
        """
        if isinstance(user_order, int):
            user_order = str(user_order)
        allowed_values = ["asc", "desc"]
        if user_order.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for user_order -> " + user_order)
            self._user_order = "outdated_sdk_version"
        else:
            self._user_order = user_order

    @property
    def session_order_by(self) -> str:
        """
        Gets the session_order_by of this AgentStateQueryRequest.
        Search session order dimension names; default to segmentStart

        :return: The session_order_by of this AgentStateQueryRequest.
        :rtype: str
        """
        return self._session_order_by

    @session_order_by.setter
    def session_order_by(self, session_order_by: str) -> None:
        """
        Sets the session_order_by of this AgentStateQueryRequest.
        Search session order dimension names; default to segmentStart

        :param session_order_by: The session_order_by of this AgentStateQueryRequest.
        :type: str
        """
        if isinstance(session_order_by, int):
            session_order_by = str(session_order_by)
        allowed_values = ["segmentStart", "sessionStart"]
        if session_order_by.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for session_order_by -> " + session_order_by)
            self._session_order_by = "outdated_sdk_version"
        else:
            self._session_order_by = session_order_by

    @property
    def session_order(self) -> str:
        """
        Gets the session_order of this AgentStateQueryRequest.
        Search session order direction; default to asc

        :return: The session_order of this AgentStateQueryRequest.
        :rtype: str
        """
        return self._session_order

    @session_order.setter
    def session_order(self, session_order: str) -> None:
        """
        Sets the session_order of this AgentStateQueryRequest.
        Search session order direction; default to asc

        :param session_order: The session_order of this AgentStateQueryRequest.
        :type: str
        """
        if isinstance(session_order, int):
            session_order = str(session_order)
        allowed_values = ["asc", "desc"]
        if session_order.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for session_order -> " + session_order)
            self._session_order = "outdated_sdk_version"
        else:
            self._session_order = session_order

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

